/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Arrays;
import java.util.Set;
import java.util.Vector;
import proper.cardinalization.CardinalizerTable;
import proper.cardinalization.SqlEngine;
import proper.database.Column;
import proper.database.Dropper;
import proper.database.Join;
import proper.database.JoinTreeNode;
import proper.database.RelationDiscoverer;
import proper.database.TableLister;
import proper.engine.DatabaseEngine;

public class Cardinalizer
extends DatabaseEngine {
    private SqlEngine sql;
    private TableLister tabLister;
    private RelationDiscoverer discoverer;
    private Dropper dropper;
    private int tableNumber;

    private void dropTables(boolean onlyTemp) {
        Vector tables = this.tabLister.getList(String.valueOf(this.getStringParameter("result_table")) + "_tmp_%");
        if (!onlyTemp) {
            tables.add(this.getStringParameter("result_table"));
        }
        this.dropper.drop(tables);
    }

    private void init() {
        this.sql = new SqlEngine(this.conn);
        this.sql.setUsePrimaryKey(!this.exists("any_index"));
        if (this.getStringParameter("exclude_fields") != null && !this.getStringParameter("exclude_fields").isEmpty()) {
            this.sql.setExcludes(this.getStringParameter("exclude_fields"));
        }
        this.tabLister = new TableLister(this.conn);
        this.tabLister.setSort(true);
        this.dropper = new Dropper(this.conn);
        this.discoverer = new RelationDiscoverer(this.conn);
        this.discoverer.setExcludes(this.getStringParameter("exclude_tables"));
        this.discoverer.setTable(this.getStringParameter("table"));
        if (this.getStringParameter("associated_tables") != null && !this.getStringParameter("associated_tables").isEmpty()) {
            this.discoverer.setAssociatedTables(Arrays.asList(this.getStringParameter("associated_tables").split(",")));
        }
        this.discoverer.setMaxDepth(Integer.parseInt(this.getStringParameter("max_depth")));
        this.discoverer.setUseForeignKeys(this.exists("use_foreign_keys"));
        this.tableNumber = 0;
    }

    private CardinalizerTable buildCardinalizationStructure(CardinalizerTable mainTable, CardinalizerTable aggrTable, Join join, boolean discretize, int nbThresEqFreq) {
        this.println("Creating Structure...");
        CardinalizerTable cardzTable = new CardinalizerTable(String.valueOf(this.getStringParameter("result_table")) + "_tmp_" + this.tableNumber);
        cardzTable.addColumn(mainTable.getJoinColumn(), true);
        ++this.tableNumber;
        int maxColumn = discretize ? (this.exists("discretize-parts") ? Integer.parseInt(this.getStringParameter("discretize-parts")) : this.sql.sqlCountAvgInstance(mainTable, aggrTable, join)) : this.sql.sqlCountMaxInstance(mainTable, aggrTable, join);
        Set<Integer> thresEqFreqList = null;
        if (nbThresEqFreq != -1) {
            thresEqFreqList = this.sql.sqlCountInstance(mainTable, aggrTable, join, 10);
        }
        int i = 0;
        while (i < aggrTable.columnCount()) {
            Column tmpCol = aggrTable.getColumn(i);
            if (tmpCol.isNumerical() && !tmpCol.equals(aggrTable.getJoinColumn()) && !tmpCol.equals(mainTable.getJoinColumn()) && !tmpCol.getName().contains("id")) {
                int j = 1;
                while (j <= maxColumn) {
                    if (this.exists("discretize-parts")) {
                        if (j < maxColumn) {
                            cardzTable.addColumn(String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + Integer.parseInt(this.getStringParameter("discretize-parts")) + "_" + tmpCol.getName(), tmpCol.getType());
                        }
                    } else if (nbThresEqFreq == -1 || thresEqFreqList.contains(j)) {
                        cardzTable.addColumn(String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + tmpCol.getName(), tmpCol.getType());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return cardzTable;
    }

    private boolean cardinalize(CardinalizerTable mainTable, Join join, boolean discretize) {
        CardinalizerTable aggrTable = this.sql.getTable(join.toString());
        this.println("\nCardinalizing : " + aggrTable.getName() + " on " + mainTable.getName());
        boolean needDiscretize = false;
        int discretizeParts = -1;
        System.out.println("VALUES ==== " + this.getStringParameter("discretize"));
        if (discretize && this.sql.sqlCountMaxInstance(mainTable, aggrTable, join) >= Integer.parseInt(this.getStringParameter("discretize"))) {
            needDiscretize = true;
            if (this.exists("discretize-parts")) {
                discretizeParts = Integer.parseInt(this.getStringParameter("discretize-parts"));
            }
        }
        int nbThresEqFreq = -1;
        if (this.exists("nb_thres_eq_freq")) {
            nbThresEqFreq = Integer.parseInt(this.getStringParameter("nb_thres_eq_freq"));
        }
        CardinalizerTable cardzTable = this.buildCardinalizationStructure(mainTable, aggrTable, join, needDiscretize, nbThresEqFreq);
        this.sql.sqlCreateTable(cardzTable);
        this.sql.sqlCopyColumnValues(mainTable, cardzTable, mainTable.getJoinColumn().getName());
        this.println("Processing data...");
        return this.sql.cardinalize(mainTable, aggrTable, cardzTable, join, needDiscretize, discretizeParts, nbThresEqFreq);
    }

    private boolean cardinalize(JoinTreeNode root, boolean discretize) {
        boolean result = true;
        CardinalizerTable mainTable = this.sql.getTable(root.toString());
        Vector<CardinalizerTable> tables = new Vector<CardinalizerTable>();
        int i = 0;
        while (i < root.getChildCount() && result) {
            result = this.cardinalize(mainTable, root.getChildJoinAt(i), discretize);
            ++i;
        }
        if (result) {
            tables.add(mainTable);
            int j = 0;
            while (j < this.tableNumber) {
                tables.add(this.sql.getTable(String.valueOf(this.getStringParameter("result_table")) + "_tmp_" + j));
                ++j;
            }
            this.println("\nJoining all cardinalized tables...");
            CardinalizerTable finalTable = this.sql.sqlCreateAsSelect(tables, this.getStringParameter("result_table"));
            this.println("Record-Count (" + mainTable.getName() + "/" + finalTable.getName() + "): " + this.sql.sqlCountInstance(mainTable) + "/" + this.sql.sqlCountInstance(finalTable));
        }
        return result;
    }

    @Override
    public boolean execute() {
        super.execute();
        this.init();
        this.dropTables(false);
        JoinTreeNode root = !this.getStringParameter("tree").equals("") ? JoinTreeNode.parseTreeString(this.getStringParameter("tree")) : this.discoverer.discover();
        this.println("Second table:" + this.getStringParameter("second_table"));
        this.println("Relation to Cardinalize :");
        this.println(root.toString(true));
        this.println("Left over tables :" + this.discoverer.leftOverTables(root).toString());
        boolean result = this.cardinalize(root, this.exists("discretize"));
        this.dropTables(true);
        return true;
    }

    private CardinalizerTable buildCardinalizationGeoStructure(CardinalizerTable mainTable, CardinalizerTable aggrTable, Join join, boolean discretize) {
        this.println("Creating Structure...");
        CardinalizerTable cardzTable = new CardinalizerTable(String.valueOf(this.getStringParameter("result_table")) + "_tmp_" + this.tableNumber);
        cardzTable.addColumn(mainTable.getJoinColumn(), true);
        ++this.tableNumber;
        int maxColumn = discretize ? (this.exists("discretize-parts") ? Integer.parseInt(this.getStringParameter("discretize-parts")) : this.sql.sqlCountAvgInstance(mainTable, aggrTable, join)) : this.sql.sqlCountMaxInstance(mainTable, aggrTable, join);
        int i = 0;
        while (i < aggrTable.columnCount()) {
            Column tmpCol = aggrTable.getColumn(i);
            if (!(tmpCol.equals(aggrTable.getJoinColumn()) || tmpCol.equals(mainTable.getJoinColumn()) || tmpCol.getName().contains("id"))) {
                if (tmpCol.isNumerical()) {
                    int j = 1;
                    while (j <= maxColumn) {
                        cardzTable.addColumn(String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + tmpCol.getName(), tmpCol.getType());
                        ++j;
                    }
                } else if (tmpCol.isNominal()) {
                    Vector<String> values = this.sql.sqlGetNominalValues(aggrTable.getName(), tmpCol);
                    int v = 0;
                    while (v < values.size()) {
                        int nbValues = this.sql.sqlCountNominalValue(aggrTable.getName(), tmpCol, values.get(v));
                        int j = 1;
                        while (j <= nbValues) {
                            cardzTable.addColumn(String.valueOf(aggrTable.getName()) + "_distance_" + j + "_" + values.get(v), tmpCol.getType());
                            ++j;
                        }
                        ++v;
                    }
                }
            }
            ++i;
        }
        return cardzTable;
    }

    private void cardinalizeGeo(CardinalizerTable mainTable, Join join, boolean discretize) {
        CardinalizerTable aggrTable = this.sql.getTable(join.getLeftTable());
        this.println("\nCardinalizing : " + aggrTable.getName() + " on " + mainTable.getName());
        boolean needDiscretize = false;
        int discretizeParts = -1;
        if (discretize && this.sql.sqlCountMaxInstance(mainTable, aggrTable, join) > Integer.parseInt(this.getStringParameter("discretize"))) {
            needDiscretize = true;
            if (this.exists("discretize-parts")) {
                discretizeParts = Integer.parseInt(this.getStringParameter("discretize-parts"));
            }
        }
        CardinalizerTable cardzTable = this.buildCardinalizationGeoStructure(mainTable, aggrTable, join, needDiscretize);
        this.sql.sqlCreateTable(cardzTable);
        this.sql.sqlCopyColumnValues(mainTable, cardzTable, mainTable.getJoinColumn().getName());
        this.println("Processing data...");
        this.sql.cardinalizeGeo(mainTable, aggrTable, cardzTable, join, needDiscretize, discretizeParts);
    }

    private void cardinalizeGeo(JoinTreeNode root, boolean discretize) {
        CardinalizerTable mainTable = this.sql.getTable(root.getTable().getName());
        Vector<CardinalizerTable> tables = new Vector<CardinalizerTable>();
        int i = 0;
        while (i < root.getChildCount()) {
            this.cardinalizeGeo(mainTable, root.getChildJoinAt(i), discretize);
            ++i;
        }
        tables.add(mainTable);
        i = 0;
        while (i < this.tableNumber) {
            tables.add(this.sql.getTable(String.valueOf(this.getStringParameter("result_table")) + "_tmp_" + i));
            ++i;
        }
        this.println("\nJoining all cardinalized tables...");
        CardinalizerTable finalTable = this.sql.sqlCreateAsSelect(tables, this.getStringParameter("result_table"));
        this.println("Record-Count (" + mainTable.getName() + "/" + finalTable.getName() + "): " + this.sql.sqlCountInstance(mainTable) + "/" + this.sql.sqlCountInstance(finalTable));
    }
}

