/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import proper.gui.core.frame.DummyFrame;
import proper.gui.core.frame.ProperFrame;

public class ProperDialog
extends JDialog
implements ActionListener,
KeyListener,
MouseListener,
WindowListener {
    protected static final int WIDTH = 400;
    protected static final int HEIGHT = 300;
    protected static final int DEFAULT_WIDTH = -1;
    protected static final int DEFAULT_HEIGHT = -1;
    protected static final int DEFAULT_LEFT = -1;
    protected static final int DEFAULT_TOP = -1;
    protected String font;
    protected int width;
    protected int height;
    protected int top;
    protected int left;
    protected boolean approved;
    private ProperFrame parent;

    public ProperDialog(String title) {
        this(new DummyFrame(), title);
    }

    public ProperDialog(ProperFrame parent, String title) {
        super(parent, title, true);
        this.parent = parent;
    }

    public ProperFrame getParentFrame() {
        return this.parent;
    }

    protected String getCustomFont() {
        return this.font;
    }

    protected void setCustomFont(String font) {
        this.font = font;
    }

    protected void initialize() {
        this.approved = false;
        this.font = "Monospaced-regular-12";
    }

    protected void createDialog() {
        this.setSize(400, 300);
        this.setCenteredLocation();
        this.setDefaultCloseOperation(2);
        this.removeWindowListener(this);
        this.addWindowListener(this);
    }

    protected void resizeDialog() {
        if (this.width != -1) {
            this.setSize(this.width, this.getSize().height);
        }
        if (this.height != -1) {
            this.setSize(this.getSize().width, this.height);
        }
        this.setCenteredLocation();
        if (this.top != -1) {
            this.setLocation(this.getLocation().x, this.top);
        }
        if (this.left != -1) {
            this.setLocation(this.left, this.getLocation().y);
        }
    }

    protected int getCenteredLeft() {
        int width = this.getBounds().width;
        int x = (this.getGraphicsConfiguration().getBounds().width - width) / 2;
        if (x < 0) {
            x = 0;
        }
        return x;
    }

    protected int getCenteredTop() {
        int height = this.getBounds().height;
        int y = (this.getGraphicsConfiguration().getBounds().height - height) / 2;
        if (y < 0) {
            y = 0;
        }
        return y;
    }

    public void setCenteredLocation() {
        this.setLocation(this.getCenteredLeft(), this.getCenteredTop());
    }

    public void refresh() {
        this.validate();
        this.repaint();
    }

    public void close() {
        this.dispose();
    }

    public boolean approved() {
        return this.approved;
    }

    @Override
    public void show() {
        this.approved = false;
        super.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.parent instanceof DummyFrame) {
            this.parent.dispose();
            this.parent = null;
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

