/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.Executor;
import proper.database.JoinTreeNode;
import proper.database.Joiner;
import proper.database.RelationDiscoverer;
import proper.database.TableLister;
import proper.gui.core.dialog.EditDialog;
import proper.gui.core.dialog.JoinBuilderDialog;
import proper.gui.core.dialog.ListDialog;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.panel.DatabasePanel;
import proper.gui.core.panel.ProperPanel;
import proper.gui.core.tree.ProperTree;
import proper.util.ProperVector;
import proper.util.Strings;

public class RelationsPanel
extends ProperPanel
implements TreeSelectionListener,
PropertyChangeListener {
    private static final String ACTION_SHOW = "show";
    private static final String ACTION_EXPAND = "expand";
    private static final String ACTION_COLLAPSE = "collapse";
    private static final String ACTION_SEARCH = "search";
    private static final String ACTION_TREE = "tree";
    private static final String ACTION_ADD = "add";
    private static final String ACTION_ADDMANUALLY = "add_manual";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_DELETESUB = "delete_subtree";
    private static final String ACTION_JOININFO = "join_info";
    private JButton buttonExpand;
    private JButton buttonCollapse;
    private JButton buttonSearch;
    private JButton buttonTree;
    private JButton buttonShow;
    private JButton buttonJoinInfo;
    private JCheckBox checkboxForeignKeys;
    private JLabel labelMaxDepth;
    private JLabel labelLeftOvers;
    private JLabel labelJoinColumns;
    private JLabel labelRecordCount;
    private JLabel labelSearch;
    private JTextField textMaxDepth;
    private JTextField textLeftOvers;
    private JTextField textJoinColumns;
    private JTextField textRecordCount;
    private JTextField textSearch;
    private ProperTree treeRelations;
    private JPanel panelRelations;
    private JScrollPane paneRelations;
    private JPopupMenu popupRelations;
    private DatabasePanel panelDB;
    private ProperFrame parent;
    private String maxDepth;
    private String title;
    private String driver;
    private String url;
    private String database;
    private String table;
    private String user;
    private String password;
    private String excludes;
    private String preferredTree;
    private String classField;

    public RelationsPanel(ProperFrame parent) {
        this(parent, "org.gjt.mm.mysql.Driver", "jdbc:mysql://localhost:3306/", "", "nobody", "", "", "_*", "1");
    }

    public RelationsPanel(ProperFrame parent, String driver, String url, String database, String user, String password, String table, String excludes, String maxDepth) {
        this.parent = parent;
        this.driver = driver;
        this.url = url;
        this.database = database;
        this.user = user;
        this.password = password;
        this.table = table;
        this.excludes = excludes;
        this.maxDepth = maxDepth;
        this.initialize();
        this.createPanel();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.title = "";
        this.classField = "";
    }

    @Override
    protected void createPanel() {
        super.createPanel();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "North");
        this.panelDB = new DatabasePanel();
        this.panelDB.setShowTables(true);
        this.panelDB.addPropertyChangeListener(this);
        this.panelDB.setDriver(this.getValue(this.driver, this.panelDB.getDriver()));
        this.panelDB.setUrl(this.getValue(this.url, this.panelDB.getUrl()));
        this.panelDB.setUser(this.getValue(this.user, this.panelDB.getUser()));
        this.panelDB.setPassword(this.getValue(this.password, this.panelDB.getPassword()));
        this.panelDB.setExcludes(this.getValue(this.excludes, this.panelDB.getExcludes()));
        this.panelDB.setPreferredDatabase(this.getValue(this.database, ""));
        this.panelDB.setPreferredTable(this.getValue(this.table, ""));
        panel.add((Component)this.panelDB, "North");
        this.labelMaxDepth = new JLabel("max. Depth");
        this.textMaxDepth = new JTextField(this.getValue(this.maxDepth, "1"), 4);
        this.buttonShow = new JButton("Show", ImageLoader.getImageIcon("run.gif"));
        this.buttonShow.setActionCommand(ACTION_SHOW);
        this.buttonShow.addActionListener(this);
        this.checkboxForeignKeys = new JCheckBox("use Foreign Keys");
        JPanel panel2 = new JPanel(new FlowLayout(3));
        panel2.add(this.labelMaxDepth);
        panel2.add(this.textMaxDepth);
        panel2.add(this.checkboxForeignKeys);
        panel2.add(this.buttonShow);
        panel.add((Component)panel2, "Center");
        this.treeRelations = new ProperTree((Vector)new ProperVector());
        this.treeRelations.addKeyListener(this);
        this.treeRelations.addMouseListener(this);
        this.treeRelations.addTreeSelectionListener(this);
        this.treeRelations.setRootVisible(true);
        this.treeRelations.clear();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        this.treeRelations.setCellRenderer(renderer);
        this.paneRelations = new JScrollPane(this.treeRelations);
        this.panelRelations = new JPanel(new BorderLayout());
        this.panelRelations.add((Component)this.paneRelations, "Center");
        this.add((Component)this.panelRelations, "Center");
        this.popupRelations = new JPopupMenu();
        this.popupRelations.addMouseListener(this);
        JMenuItem menuItem = new JMenuItem("Add...");
        menuItem.setActionCommand(ACTION_ADD);
        menuItem.addActionListener(this);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.popupRelations.add(menuItem);
        menuItem = new JMenuItem("Add manually...");
        menuItem.setActionCommand(ACTION_ADDMANUALLY);
        menuItem.addActionListener(this);
        this.popupRelations.add(menuItem);
        this.popupRelations.addSeparator();
        menuItem = new JMenuItem("Delete");
        menuItem.setActionCommand(ACTION_DELETE);
        menuItem.addActionListener(this);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.popupRelations.add(menuItem);
        menuItem = new JMenuItem("Delete subtree");
        menuItem.setActionCommand(ACTION_DELETESUB);
        menuItem.addActionListener(this);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 1));
        this.popupRelations.add(menuItem);
        this.buttonExpand = new JButton("Expand", ImageLoader.getImageIcon("tree.gif"));
        this.buttonExpand.setActionCommand(ACTION_EXPAND);
        this.buttonExpand.addActionListener(this);
        this.buttonCollapse = new JButton("Collapse", ImageLoader.getImageIcon("delete.gif"));
        this.buttonCollapse.setActionCommand(ACTION_COLLAPSE);
        this.buttonCollapse.addActionListener(this);
        this.buttonTree = new JButton("Tree", ImageLoader.getImageIcon("copy.gif"));
        this.buttonTree.setActionCommand(ACTION_TREE);
        this.buttonTree.addActionListener(this);
        this.textSearch = new JTextField("", 10);
        this.buttonSearch = new JButton("Search", ImageLoader.getImageIcon("find.gif"));
        this.buttonSearch.setActionCommand(ACTION_SEARCH);
        this.buttonSearch.addActionListener(this);
        this.labelSearch = new JLabel("");
        panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.buttonExpand);
        panel.add(this.buttonCollapse);
        panel.add(this.buttonTree);
        panel.add(this.textSearch);
        panel.add(this.buttonSearch);
        panel.add(this.labelSearch);
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.add((Component)panel2, "East");
        this.labelLeftOvers = new JLabel("left over tables");
        this.textLeftOvers = new JTextField("", 20);
        this.labelJoinColumns = new JLabel("Join Columns");
        this.textJoinColumns = new JTextField("", 20);
        this.buttonJoinInfo = new JButton("...");
        this.buttonJoinInfo.setActionCommand(ACTION_JOININFO);
        this.buttonJoinInfo.addActionListener(this);
        this.labelRecordCount = new JLabel("Record Count");
        this.textRecordCount = new JTextField("", 6);
        panel = new JPanel(new FlowLayout(3));
        panel.add(this.labelLeftOvers);
        panel.add(this.textLeftOvers);
        panel.add(this.labelJoinColumns);
        panel.add(this.textJoinColumns);
        panel.add(this.buttonJoinInfo);
        panel.add(this.labelRecordCount);
        panel.add(this.textRecordCount);
        this.add((Component)panel, "South");
        this.invalidate();
        this.setEnabledState("");
    }

    public String getValue(String value, String defaultValue) {
        if (!value.equals("")) {
            return value;
        }
        return defaultValue;
    }

    public ProperFrame getParentFrame() {
        return this.parent;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setConnector(Connector conn) {
        this.panelDB.setConnector(conn);
    }

    public Connector getConnector() {
        return this.panelDB.getConnector();
    }

    public String getTree() {
        JoinTreeNode root = (JoinTreeNode)this.treeRelations.getModel().getRoot();
        if (root == null) {
            return "";
        }
        return root.toTreeString(true);
    }

    public void setTree(String tree) {
        this.preferredTree = tree;
    }

    private void showTree() {
        if (this.preferredTree == null || this.preferredTree.equals("")) {
            return;
        }
        JoinTreeNode root = JoinTreeNode.parseTreeString(this.preferredTree);
        Vector tables = this.panelDB.getTables();
        if (tables.contains(root.toString())) {
            this.treeRelations.setModel(new DefaultTreeModel(root));
            this.treeRelations.expandAll();
            this.showLeftOvers();
        } else {
            this.treeRelations.setModel(null);
            this.getParentFrame().println("The table '" + root + "' is not in this database! Tree cannot be displayed.");
        }
    }

    private void createTitle() {
        String title = "";
        if (!this.panelDB.getDatabase().equals("")) {
            title = this.panelDB.getDatabase();
        }
        if (!this.panelDB.getTable().equals("")) {
            title = String.valueOf(title) + "." + this.panelDB.getTable();
        }
    }

    @Override
    protected void setEnabledState(String action) {
        if (action.equals("")) {
            this.buttonShow.setEnabled(false);
            this.textMaxDepth.setEnabled(false);
            this.labelSearch.setText("");
        } else if (action.equals("connect")) {
            this.buttonShow.setEnabled(false);
            this.textMaxDepth.setEnabled(false);
            this.labelSearch.setText("");
        } else if (action.equals("select_database")) {
            this.buttonShow.setEnabled(true);
            this.textMaxDepth.setEnabled(true);
            this.labelSearch.setText("");
        }
    }

    private void showRelations() {
        RelationDiscoverer discoverer = new RelationDiscoverer(this.panelDB.getConnector());
        discoverer.setTable(this.panelDB.getTable());
        discoverer.setMaxDepth(Integer.parseInt(this.textMaxDepth.getText()));
        discoverer.setExcludes(this.panelDB.getExcludes());
        discoverer.setUseForeignKeys(this.checkboxForeignKeys.isSelected());
        JoinTreeNode root = discoverer.discover();
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.treeRelations.setModel(model);
        this.treeRelations.expandAll();
        this.showLeftOvers();
    }

    private void showLeftOvers() {
        RelationDiscoverer discoverer = new RelationDiscoverer(this.panelDB.getConnector());
        discoverer.setTable(this.panelDB.getTable());
        discoverer.setMaxDepth(Integer.parseInt(this.textMaxDepth.getText()));
        discoverer.setExcludes(this.panelDB.getExcludes());
        DefaultTreeModel model = (DefaultTreeModel)this.treeRelations.getModel();
        JoinTreeNode root = (JoinTreeNode)model.getRoot();
        Vector leftOvers = discoverer.leftOverTables(root);
        String tmp = "";
        int i = 0;
        while (i < leftOvers.size()) {
            if (i > 0) {
                tmp = String.valueOf(tmp) + ", ";
            }
            tmp = String.valueOf(tmp) + leftOvers.get(i).toString();
            ++i;
        }
        this.textLeftOvers.setText(tmp);
    }

    private void search() {
        this.treeRelations.clearSelection();
        this.labelSearch.setText("");
        if (this.textSearch.getText().equals("")) {
            return;
        }
        this.expandTree();
        String searchStr = this.textSearch.getText();
        boolean first = true;
        int i = 0;
        while (i < this.treeRelations.getRowCount()) {
            TreePath path = this.treeRelations.getPathForRow(i);
            String nodeStr = path.getLastPathComponent().toString();
            if (nodeStr.equals(searchStr)) {
                this.treeRelations.addSelectionPath(path);
                if (first) {
                    this.treeRelations.scrollPathToVisible(path);
                    first = false;
                }
            }
            ++i;
        }
        this.labelSearch.setText(String.valueOf(Integer.toString(this.treeRelations.getSelectionCount())) + " found");
    }

    private void showJoins(JoinTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.isJoin()) {
            this.textJoinColumns.setText(node.getJoin().toStringJoin());
        } else {
            this.textJoinColumns.setText("");
        }
    }

    private void showJoinInfo() {
        if (this.treeRelations.getSelectionPath() == null) {
            return;
        }
        JoinTreeNode node = (JoinTreeNode)this.treeRelations.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.getParent() == null) {
            return;
        }
        ColumnLister cols = new ColumnLister(this.panelDB.getConnector());
        cols.setTable(this.treeRelations.getModel().getRoot().toString());
        cols.setSort(true);
        ListDialog classDialog = new ListDialog(this.getParentFrame(), "Choose Class...");
        Vector columns = cols.getList();
        classDialog.setItems(columns);
        if (!this.classField.equals("")) {
            classDialog.setSelectedIndex(columns.indexOf(new Column(this.classField)));
        }
        classDialog.show();
        if (!classDialog.approved()) {
            return;
        }
        this.classField = classDialog.getSelectedValue().toString();
        String table1 = node.getJoin().getRightTable();
        String table2 = node.getJoin().getLeftTable();
        Joiner joiner = new Joiner(this.panelDB.getConnector());
        joiner.setUseForeignKeys(this.checkboxForeignKeys.isSelected());
        Executor exec = new Executor(this.panelDB.getConnector());
        columns = new ProperVector();
        columns.add(node.getJoin());
        int count1 = exec.getDistinctCount(table1, node.getJoin().getRightColumn());
        int classCount1 = joiner.getRowsWithClassCount(table1, table2, columns, this.classField, 1);
        int classes1 = joiner.getClassCount(table1, table2, columns, this.classField, 1);
        int count2 = exec.getDistinctCount(table2, node.getJoin().getLeftColumn());
        int classCount2 = joiner.getRowsWithClassCount(table1, table2, columns, this.classField, 2);
        int classes2 = joiner.getClassCount(table1, table2, columns, this.classField, 2);
        int type = joiner.determineBestJoin(table1, table2, columns, this.classField);
        String tmp = "Table '" + table1 + " and '" + table2 + "':\n" + "1. LEFT OUTER JOIN\n" + " - classrows = " + classCount1 + "\n" + " - rows = " + count1 + "\n" + " - classes = " + classes1 + "\n" + "\n" + "2. RIGHT OUTER JOIN\n" + " - classrows = " + classCount2 + "\n" + " - rows = " + count2 + "\n" + " - classes = " + classes2 + "\n" + "\n" + "=> " + Joiner.typeToString(type) + " (" + type + ")\n" + "\n" + "Used Join:\n" + joiner.createJoin(table1, table2, columns, type) + "\n";
        EditDialog infoDialog = new EditDialog(this.getParentFrame(), "Join-Info");
        infoDialog.setText(tmp);
        infoDialog.show();
    }

    private void showRecordCount(JoinTreeNode node) {
        int count = node.isJoin() ? node.getJoin().getSize() : 0;
        this.textRecordCount.setText(Integer.toString(count));
    }

    private void expandTree() {
        this.treeRelations.expandAll();
    }

    private void collapseTree() {
        this.treeRelations.collapseAll();
        TreePath rootPath = new TreePath(this.treeRelations.getModel().getRoot());
        this.treeRelations.expandPath(rootPath);
    }

    private void treeToString() {
        if (this.treeRelations.getModel() == null) {
            return;
        }
        JoinTreeNode root = (JoinTreeNode)this.treeRelations.getModel().getRoot();
        if (root == null) {
            return;
        }
        EditDialog edit = new EditDialog(this.getParentFrame(), "Tree");
        edit.setText(root.toTreeString(true));
        edit.setEditable(true);
        edit.show();
        if (edit.approved()) {
            root = JoinTreeNode.parseTreeString(edit.getText());
            this.treeRelations.setModel(new DefaultTreeModel(root));
            this.treeRelations.expandAll();
            this.showLeftOvers();
        }
    }

    private void addItems() {
        if (this.treeRelations.getSelectionRows().length == 0) {
            return;
        }
        JoinTreeNode parent = (JoinTreeNode)this.treeRelations.getSelectionPath().getLastPathComponent();
        ProperVector existing = new ProperVector();
        Enumeration<TreeNode> enm = parent.children();
        while (enm.hasMoreElements()) {
            existing.add(enm.nextElement());
        }
        ProperVector possible = new ProperVector();
        RelationDiscoverer discoverer = new RelationDiscoverer(this.panelDB.getConnector());
        if (parent.isTable()) {
            discoverer.setTable(parent.getTable().getName());
        } else {
            discoverer.setTable(parent.getJoin().getLeftTable());
        }
        discoverer.setMaxDepth(1);
        discoverer.setExcludes(Strings.toCommalistVector(existing));
        discoverer.setUseForeignKeys(this.checkboxForeignKeys.isSelected());
        JoinTreeNode root = discoverer.discover();
        enm = root.children();
        while (enm.hasMoreElements()) {
            possible.add(enm.nextElement());
        }
        ListDialog list = new ListDialog(this.getParentFrame(), "Available Tables");
        list.setItems(possible);
        list.show();
        if (list.approved()) {
            this.treeRelations.addNodes((MutableTreeNode)parent, list.getSelectedItems());
            DefaultTreeModel model = (DefaultTreeModel)this.treeRelations.getModel();
            this.treeRelations.expandAll(new TreePath(model.getPathToRoot(parent)));
            this.showLeftOvers();
        }
    }

    private void addItemsManually() {
        if (this.treeRelations.getSelectionRows().length == 0) {
            return;
        }
        JoinTreeNode parent = (JoinTreeNode)this.treeRelations.getSelectionPath().getLastPathComponent();
        TableLister tables = new TableLister(this.getConnector());
        String newExcludes = parent.toString();
        if (this.excludes.length() != 0) {
            newExcludes = String.valueOf(newExcludes) + "," + this.excludes;
        }
        tables.setExcludes(newExcludes);
        tables.setSort(true);
        ListDialog list = new ListDialog(this.getParentFrame(), "Available Tables");
        list.setItems(tables.getList());
        list.show();
        if (!list.approved()) {
            return;
        }
        JoinBuilderDialog builder = new JoinBuilderDialog(this.getParentFrame());
        builder.setConnector(this.getConnector());
        builder.setLeftTable(parent.toString());
        builder.setRightTable(list.getSelectedValue().toString());
        builder.show();
        if (!builder.approved()) {
            return;
        }
        if (builder.getJoin() != null) {
            this.treeRelations.addNodes((MutableTreeNode)parent, new JoinTreeNode[]{new JoinTreeNode(builder.getJoin())});
            DefaultTreeModel model = (DefaultTreeModel)this.treeRelations.getModel();
            this.treeRelations.expandAll(new TreePath(model.getPathToRoot(parent)));
        }
    }

    private void deleteItems() {
        this.treeRelations.removeNodes(this.treeRelations.getSelectionRows());
    }

    private void deleteSubtrees() {
        TreePath[] paths = this.treeRelations.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            JoinTreeNode node = (JoinTreeNode)paths[i].getLastPathComponent();
            if (node.getChildCount() > 0) {
                MutableTreeNode[] children = new JoinTreeNode[node.getChildCount()];
                int n = 0;
                while (n < children.length) {
                    children[n] = (JoinTreeNode)node.getChildAt(n);
                    ++n;
                }
                this.treeRelations.removeNodes(children);
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_SHOW)) {
            this.showRelations();
        } else if (action.equals(ACTION_SEARCH)) {
            this.search();
        } else if (action.equals(ACTION_EXPAND)) {
            this.expandTree();
        } else if (action.equals(ACTION_COLLAPSE)) {
            this.collapseTree();
        } else if (action.equals(ACTION_TREE)) {
            this.treeToString();
        } else if (action.equals(ACTION_ADD)) {
            this.addItems();
        } else if (action.equals(ACTION_ADDMANUALLY)) {
            this.addItemsManually();
        } else if (action.equals(ACTION_DELETE)) {
            this.deleteItems();
        } else if (action.equals(ACTION_DELETESUB)) {
            this.deleteSubtrees();
        } else if (action.equals(ACTION_JOININFO)) {
            this.showJoinInfo();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JoinTreeNode node = (JoinTreeNode)e.getPath().getLastPathComponent();
        this.showJoins(node);
        this.showRecordCount(node);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.panelDB) {
            if (evt.getPropertyName().equals("database") || evt.getPropertyName().equals("table")) {
                this.createTitle();
            } else if (evt.getPropertyName().equals("connect") || evt.getPropertyName().equals("select_database")) {
                this.setEnabledState(evt.getPropertyName());
                if (evt.getPropertyName().equals("select_database")) {
                    this.showTree();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selRow;
        if (e.getSource() == this.treeRelations && (selRow = this.treeRelations.getRowForLocation(e.getX(), e.getY())) != -1) {
            TreePath selPath = this.treeRelations.getPathForRow(selRow);
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                e.consume();
                this.addItems();
            }
            if (e.getButton() == 3 && e.getClickCount() == 1) {
                e.consume();
                this.popupRelations.show(e.getComponent(), e.getX(), e.getY());
            }
            if (e.getButton() == 1) {
                e.consume();
                JoinTreeNode node = (JoinTreeNode)selPath.getLastPathComponent();
                this.showJoins(node);
                this.showRecordCount(node);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.treeRelations && this.treeRelations.getSelectionCount() > 0) {
            if (e.getKeyCode() == 10) {
                e.consume();
                this.addItems();
            }
            if (e.getKeyCode() == 127) {
                e.consume();
                if (e.getModifiers() == 0) {
                    this.deleteItems();
                } else if ((e.getModifiers() & 0x40) == 64) {
                    this.deleteSubtrees();
                }
            }
        }
    }
}

