/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import proper.gui.experiment.Builder;
import proper.gui.experiment.BuilderPanel;
import proper.gui.experiment.BuilderParameter;

public class BuilderSteps
extends BuilderPanel {
    private JPanel panelSteps;

    public BuilderSteps(Builder parent) {
        super(parent, "Steps");
    }

    @Override
    protected void createPanel() {
        super.createPanel();
        this.panelSteps = new JPanel(new FlowLayout(3));
        this.add((Component)this.panelSteps, "Center");
        this.setNote("Note: only the checked steps will be saved!");
    }

    public void addStep(String name, Vector substeps) {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), name));
        int i = 0;
        while (i < substeps.size()) {
            JCheckBox check = new JCheckBox(substeps.get(i).toString());
            check.addActionListener(this);
            panel.add(check);
            this.addParameter(new BuilderParameter(check, check.getText(), false, new JLabel(), true, "no", String.valueOf(name.toLowerCase()) + "/" + check.getText().toLowerCase()));
            ++i;
        }
        this.panelSteps.add(panel);
    }

    public boolean isChecked(String step) {
        boolean result = false;
        BuilderParameter param = this.getParameter(step = step.toLowerCase());
        if (param != null) {
            result = ((JCheckBox)param.getComponent()).isSelected();
        }
        return result;
    }

    public void setChecked(String step, boolean checked) {
        BuilderParameter param = this.getParameter(step);
        if (param != null) {
            ((JCheckBox)param.getComponent()).setSelected(checked);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.setChanged(true);
        }
    }
}

