/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JTabbedPane;
import proper.gui.experiment.Builder;
import proper.gui.experiment.BuilderPanel;
import proper.xml.Attribute;
import proper.xml.Element;

public class BuilderTabPanel
extends BuilderPanel {
    private JTabbedPane tabbedPane;

    public BuilderTabPanel(Builder parent, String name) {
        super(parent, name);
        this.locateTabbedPane();
    }

    @Override
    protected void createPanel() {
        super.createPanel();
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
    }

    private void locateTabbedPane() {
        this.tabbedPane = null;
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getComponent(i) instanceof JTabbedPane) {
                this.tabbedPane = (JTabbedPane)this.getComponent(i);
                break;
            }
            ++i;
        }
    }

    public boolean hasTabbedPane() {
        return this.getTabbedPane() != null;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public int getPanelCount() {
        if (!this.hasTabbedPane()) {
            return 0;
        }
        return this.getTabbedPane().getTabCount();
    }

    public int indexOfPanel(String name) {
        int result = -1;
        int i = 0;
        while (i < this.getPanelCount()) {
            if (this.getPanelAt(i).getName().equals(name)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public BuilderPanel getPanelAt(int index) {
        BuilderPanel result = null;
        if (!this.hasTabbedPane()) {
            return result;
        }
        if (this.getTabbedPane().getComponentAt(index) instanceof BuilderPanel) {
            result = (BuilderPanel)this.getTabbedPane().getComponentAt(index);
        }
        return result;
    }

    public void setSelectedPanel(int index) {
        if (!this.hasTabbedPane()) {
            return;
        }
        this.getTabbedPane().setSelectedIndex(index);
    }

    @Override
    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.getPanelCount()) {
            this.getPanelAt(i).clear();
            ++i;
        }
    }

    @Override
    public void setChanged(boolean changed) {
        super.setChanged(changed);
        int i = 0;
        while (i < this.getPanelCount()) {
            if (this.getPanelAt(i) != null) {
                this.getPanelAt(i).setChanged(changed);
            }
            ++i;
        }
    }

    @Override
    public boolean isChanged() {
        boolean changed = super.isChanged();
        if (!this.hasTabbedPane()) {
            return changed;
        }
        int i = 0;
        while (i < this.getPanelCount()) {
            if (changed) break;
            if (this.getPanelAt(i) != null) {
                changed = changed || this.getPanelAt(i).isChanged();
            }
            ++i;
        }
        return changed;
    }

    @Override
    public void fromXML(Element node) {
        int i = 0;
        while (i < node.getChildCount()) {
            BuilderPanel panel;
            Element subnode = (Element)node.getChildAt(i);
            Attribute att = subnode.getAttribute("name");
            if (att != null && (panel = this.getPanelAt(this.indexOfPanel(att.getValue()))) != null) {
                panel.fromXML(subnode);
            }
            ++i;
        }
    }

    @Override
    public Element toXML() {
        Element result = new Element(this.getName());
        int i = 0;
        while (i < this.getPanelCount()) {
            Element node = this.getPanelAt(i).toXML();
            Attribute att = node.getAttribute("name");
            if (this.getParentFrame().getSteps().isChecked(att.getValue())) {
                result.add(node);
            }
            ++i;
        }
        return result;
    }
}

