/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import org.apache.tools.ant.Task;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.dialog.ListDialog;
import proper.gui.core.dialog.MessageBox;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.io.SimpleFileFilter;
import proper.gui.core.list.List;
import proper.gui.core.text.JTextAreaPrintStream;
import proper.gui.experiment.ExperimentOptions;
import proper.gui.experiment.RunExecutor;
import proper.io.Ant;
import proper.io.AntTarget;
import proper.io.CommandLine;
import proper.io.TextFile;
import proper.util.ProperVector;
import proper.util.Strings;

public class Run
extends ChildFrame {
    private static final String ACTION_START = "start";
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_CLEAROUTPUT = "clear_output";
    private static final String ACTION_SAVEOUTPUT = "save_output";
    private static final String ACTION_ERRORS = "errors";
    private static final String ACTION_OPTIONS = "options";
    private static final String ACTION_RELOAD = "reload";
    private static final String ACTION_NEW = "new_run";
    private static final String ACTION_ADD = "add_files";
    private JTabbedPane tabbedPane;
    private JButton buttonStart;
    private JButton buttonStop;
    private JButton buttonExit;
    private JButton buttonClear;
    private JButton buttonSave;
    private JButton buttonErrors;
    private JButton buttonOptions;
    private JButton buttonReload;
    private JButton buttonNew;
    private JButton buttonAdd;
    private JTextArea areaOutput;
    private JScrollPane paneTargets;
    private JScrollPane paneOutput;
    private JPanel panelTargets;
    private JPanel panelOutput;
    protected JTextAreaPrintStream streamOutput;
    private FileChooser fileChooser;
    protected List listTargets;
    private RunExecutor exec;
    private HashSet files;
    protected Vector errorList;

    public Run(ApplicationFrame parent) {
        super(parent, "Run");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.exec = null;
        this.files = new HashSet();
        this.errorList = new ProperVector();
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonNew = new JButton("New", ImageLoader.getImageIcon("new.gif"));
        this.buttonNew.setActionCommand(ACTION_NEW);
        this.buttonNew.addActionListener(this);
        this.buttonNew.setMnemonic('N');
        this.buttonAdd = new JButton("Add", ImageLoader.getImageIcon("open.gif"));
        this.buttonAdd.setActionCommand(ACTION_ADD);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.setMnemonic('A');
        this.buttonOptions = new JButton("Options", ImageLoader.getImageIcon("properties.gif"));
        this.buttonOptions.setActionCommand(ACTION_OPTIONS);
        this.buttonOptions.addActionListener(this);
        this.buttonOptions.setMnemonic('p');
        this.buttonReload = new JButton("Reload", ImageLoader.getImageIcon("undo.gif"));
        this.buttonReload.setActionCommand(ACTION_RELOAD);
        this.buttonReload.addActionListener(this);
        this.buttonReload.setMnemonic('R');
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.buttonNew);
        panel.add(this.buttonAdd);
        panel.add(this.buttonOptions);
        panel.add(this.buttonReload);
        this.getContentPane().add((Component)panel, "North");
        this.panelTargets = new JPanel(new BorderLayout());
        this.panelOutput = new JPanel(new BorderLayout());
        this.listTargets = new List((ListModel)new DefaultListModel());
        this.listTargets.setPopupMenuEnabled(true);
        this.listTargets.setFont(Font.decode(this.getCustomFont()));
        this.listTargets.addMouseListener(this);
        this.areaOutput = new JTextArea();
        this.areaOutput.setFont(Font.decode(this.getCustomFont()));
        this.areaOutput.setLineWrap(true);
        this.paneTargets = new JScrollPane(this.listTargets);
        this.paneOutput = new JScrollPane(this.areaOutput);
        this.panelTargets.add((Component)this.paneTargets, "Center");
        this.panelOutput.add((Component)this.paneOutput, "Center");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Targets", ImageLoader.getImageIcon("objects.gif"), this.panelTargets);
        this.tabbedPane.addTab("Output", ImageLoader.getImageIcon("list.gif"), this.panelOutput);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.buttonStart = new JButton("Start", ImageLoader.getImageIcon("run.gif"));
        this.buttonStart.setActionCommand(ACTION_START);
        this.buttonStart.addActionListener(this);
        this.buttonStart.setMnemonic('S');
        this.buttonExit = new JButton("Exit", ImageLoader.getImageIcon("delete.gif"));
        this.buttonExit.setActionCommand("exit");
        this.buttonExit.addActionListener(this);
        this.buttonExit.setMnemonic('E');
        this.labelStatus.setHorizontalAlignment(0);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buttonStart, "West");
        panel.add((Component)this.labelStatus, "Center");
        panel.add((Component)this.buttonExit, "East");
        this.getContentPane().add((Component)panel, "South");
        this.buttonClear = new JButton("Clear", ImageLoader.getImageIcon("new.gif"));
        this.buttonClear.setActionCommand(ACTION_CLEAROUTPUT);
        this.buttonClear.addActionListener(this);
        this.buttonClear.setMnemonic('C');
        this.buttonStop = new JButton("Stop", ImageLoader.getImageIcon("stop2.gif"));
        this.buttonStop.setActionCommand(ACTION_STOP);
        this.buttonStop.addActionListener(this);
        this.buttonStop.setMnemonic('t');
        this.buttonSave = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonSave.setActionCommand(ACTION_SAVEOUTPUT);
        this.buttonSave.addActionListener(this);
        this.buttonSave.setMnemonic('a');
        this.buttonErrors = new JButton("Errors", ImageLoader.getImageIcon("hand.gif"));
        this.buttonErrors.setActionCommand(ACTION_ERRORS);
        this.buttonErrors.addActionListener(this);
        this.buttonErrors.setMnemonic('r');
        panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.buttonClear);
        panel.add(this.buttonStop);
        panel.add(this.buttonSave);
        panel.add(this.buttonErrors);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelOutput.add((Component)panel2, "East");
        this.streamOutput = new JTextAreaPrintStream(this.areaOutput);
        this.setOutput(this.streamOutput);
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setMultiSelectionEnabled(true);
    }

    @Override
    protected boolean afterCreate() {
        System.out.println(this.cl.getParameters());
        if (this.cl.hasValue("filename")) {
            String[] filenames = Strings.fromCommalist(this.cl.getValue("filename"));
            int i = 0;
            while (i < filenames.length) {
                this.loadFile(filenames[i]);
                ++i;
            }
        }
        if (this.cl.hasValue("autorun")) {
            this.setVisible(false);
            this.exec = new RunExecutor(this);
            this.exec.start();
        }
        return true;
    }

    @Override
    protected void setEnabledState(boolean enabled) {
        this.buttonNew.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonOptions.setEnabled(enabled);
        this.buttonReload.setEnabled(enabled);
        this.listTargets.setEnabled(enabled);
        this.buttonStart.setEnabled(enabled);
        this.buttonExit.setEnabled(enabled);
        this.buttonSave.setEnabled(enabled);
        this.buttonErrors.setEnabled(enabled);
        this.repaint();
    }

    private void loadFile(String filename) {
        int i;
        DefaultListModel model = (DefaultListModel)this.listTargets.getModel();
        if (this.files.contains(filename)) {
            i = 0;
            while (i < model.size()) {
                AntTarget target = (AntTarget)model.getElementAt(i);
                if (target.getFilename().equals(filename)) {
                    model.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        }
        this.files.add(filename);
        Ant ant = new Ant(filename);
        Vector targets = ant.getAntTargets();
        i = 0;
        while (i < targets.size()) {
            model.add(0, targets.get(i));
            ++i;
        }
    }

    private AntTarget getSelectedAntTarget() {
        AntTarget result = null;
        if (this.listTargets.getSelectedIndex() > -1) {
            result = (AntTarget)this.listTargets.getSelectedValue();
        }
        return result;
    }

    public void close() {
        this.windowClosing(null);
    }

    public CommandLine getParameters() {
        return this.cl;
    }

    private void start() {
        this.tabbedPane.setSelectedIndex(1);
        this.exec = new RunExecutor(this);
        this.exec.start();
    }

    private void stop() {
        if (this.exec != null) {
            this.exec.stopRunning();
        }
    }

    private void saveOutput() {
        this.fileChooser.setFileFilter(new SimpleFileFilter("log", "Log-Files"));
        int retVal = this.fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        ProperVector lines = new ProperVector();
        lines.add(String.valueOf(this.areaOutput.getText()) + "\n");
        TextFile.save(this.fileChooser.getSelectedFile().getAbsolutePath(), lines);
    }

    private void clearOutput() {
        this.areaOutput.setText("");
    }

    private void showOptions() {
        if (this.getSelectedAntTarget() == null) {
            return;
        }
        ExperimentOptions options = new ExperimentOptions((ProperFrame)this, this.getSelectedAntTarget().getAnt());
        options.show();
    }

    private void reload() {
        Iterator iter = this.files.iterator();
        while (iter.hasNext()) {
            this.loadFile(iter.next().toString());
        }
    }

    private void newRun() {
        this.errorList.clear();
        this.files.clear();
        this.listTargets.setModel(new DefaultListModel());
        this.clearOutput();
        this.tabbedPane.setSelectedIndex(0);
    }

    private void addFiles() {
        this.fileChooser.setFileFilter(new SimpleFileFilter("xml", "XML-Files"));
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        int i = 0;
        while (i < this.fileChooser.getSelectedFiles().length) {
            String filename = this.fileChooser.getSelectedFiles()[i].getAbsolutePath();
            this.loadFile(filename);
            ++i;
        }
    }

    protected void displayErrors() {
        if (this.errorList.size() == 0) {
            this.showMessageBox("Errors", "No errors to report at the moment!", MessageBox.BUTTONS_OK, "information.gif");
            return;
        }
        ProperVector list = new ProperVector();
        int i = 0;
        while (i < this.errorList.size()) {
            Task task = (Task)this.errorList.get(i);
            list.add(String.valueOf(task.getOwningTarget().getName()) + ": " + task.getTaskName());
            ++i;
        }
        if (!this.getParameters().hasValue("autorun")) {
            ListDialog dialog = new ListDialog(this, "Errors...");
            dialog.setItems(list);
            dialog.show();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("exit")) {
            this.close();
        } else if (action.equals(ACTION_START)) {
            this.start();
        } else if (action.equals(ACTION_STOP)) {
            this.stop();
        } else if (action.equals(ACTION_SAVEOUTPUT)) {
            this.saveOutput();
        } else if (action.equals(ACTION_CLEAROUTPUT)) {
            this.clearOutput();
        } else if (action.equals(ACTION_ERRORS)) {
            this.displayErrors();
        } else if (action.equals(ACTION_OPTIONS)) {
            this.showOptions();
        } else if (action.equals(ACTION_RELOAD)) {
            this.reload();
        } else if (action.equals(ACTION_NEW)) {
            this.newRun();
        } else if (action.equals(ACTION_ADD)) {
            this.addFiles();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.listTargets && this.listTargets.getSelectedIndex() > -1 && e.getButton() == 1 && e.getClickCount() == 2) {
            e.consume();
            this.start();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Executes any ANT file that was built for Proper, i.e. the predefined ones");
        System.out.println("or experiments that were built with the Builder.");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -filename <name[,name[,...]]>");
        System.out.println("  the name of the ANT file(s) to extract the experiments from");
    }

    public static void main(String[] args) throws Exception {
        Run frame = new Run(null);
        frame.run(args);
    }
}

