/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.dialog.MessageBox;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.text.JTextComponentHelper;
import proper.io.TextFile;
import proper.util.ProperVector;

public class Editor
extends ChildFrame
implements CaretListener {
    private static final String ACTION_NEW = "new";
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_SAVE = "save";
    private static final String ACTION_SEARCH = "search";
    private static final String ACTION_LINEWRAP = "line_wrap";
    private JButton buttonNew;
    private JButton buttonLoad;
    private JButton buttonSave;
    private JButton buttonSearch;
    private JButton buttonExit;
    private JTextArea areaFile;
    private JTextField textSearch;
    private JLabel labelCoordinates;
    private JLabel labelChanged;
    private JScrollPane paneFile;
    private JPanel panelCenter;
    private JPanel panelSouth;
    private JCheckBox checkLineWrap;
    private FileChooser fileChooser;
    private String filename;
    private boolean changed;

    public Editor(ApplicationFrame parent) {
        super(parent, "Editor");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.filename = "";
        this.changed = false;
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.panelCenter = new JPanel(new BorderLayout());
        this.panelSouth = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.panelCenter, "Center");
        this.getContentPane().add((Component)this.panelSouth, "South");
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.buttonNew = new JButton("New", ImageLoader.getImageIcon("new.gif"));
        this.buttonNew.setActionCommand(ACTION_NEW);
        this.buttonNew.addActionListener(this);
        this.buttonLoad = new JButton("Load", ImageLoader.getImageIcon("open.gif"));
        this.buttonLoad.setActionCommand(ACTION_LOAD);
        this.buttonLoad.addActionListener(this);
        this.buttonSave = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonSave.setActionCommand(ACTION_SAVE);
        this.buttonSave.addActionListener(this);
        this.buttonSearch = new JButton("Search", ImageLoader.getImageIcon("find.gif"));
        this.buttonSearch.setActionCommand(ACTION_SEARCH);
        this.buttonSearch.addActionListener(this);
        this.textSearch = new JTextField("", 10);
        this.checkLineWrap = new JCheckBox("wrap lines", true);
        this.checkLineWrap.setActionCommand(ACTION_LINEWRAP);
        this.checkLineWrap.addActionListener(this);
        JPanel panel = new JPanel(new GridLayout(6, 1));
        panel.add(this.buttonNew);
        panel.add(this.buttonLoad);
        panel.add(this.buttonSave);
        panel.add(this.textSearch);
        panel.add(this.buttonSearch);
        panel.add(this.checkLineWrap);
        JPanel panel2 = new JPanel(new BorderLayout());
        this.labelChanged = new JLabel();
        this.labelChanged.setHorizontalAlignment(0);
        panel2.add((Component)this.labelChanged, "South");
        panel2.add((Component)panel, "North");
        this.panelCenter.add((Component)panel2, "East");
        this.labelCoordinates = new JLabel();
        this.panelSouth.add((Component)this.labelCoordinates, "West");
        this.areaFile = new JTextArea();
        this.areaFile.setLineWrap(true);
        this.areaFile.getDocument().addDocumentListener(this);
        this.areaFile.addCaretListener(this);
        this.areaFile.setFont(Font.decode(this.getCustomFont()));
        this.paneFile = new JScrollPane(this.areaFile);
        this.panelCenter.add((Component)this.paneFile, "Center");
        this.buttonExit = new JButton("Exit", ImageLoader.getImageIcon("forward.gif"));
        this.buttonExit.setActionCommand("exit");
        this.buttonExit.addActionListener(this);
        this.panelSouth.add((Component)this.buttonExit, "East");
    }

    @Override
    protected void setFrameTitle() {
        if (this.filename.equals("")) {
            this.setTitle(this.frameTitle);
        } else {
            this.setTitle(String.valueOf(this.frameTitle) + " - " + this.filename);
        }
        super.setFrameTitle();
    }

    private void setConfirm() {
        this.setConfirmExit(this.changed);
        if (this.changed) {
            this.labelChanged.setText("Modified");
        } else {
            this.labelChanged.setText("");
        }
    }

    private void newFile() {
        int button;
        if (this.changed && (button = this.showMessageBox("Confirm", "The file '" + this.filename + "' is not saved! Do you want to continue?", MessageBox.BUTTONS_YESNO, "question.gif", 370, 100)) != 0) {
            return;
        }
        this.areaFile.setText("");
        this.filename = "";
        this.changed = false;
        this.setFrameTitle();
        this.setConfirm();
    }

    private void loadFile() {
        int retVal;
        if (!this.filename.equals("")) {
            try {
                this.fileChooser.setSelectedFile(new File(this.filename));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((retVal = this.fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        this.filename = this.fileChooser.getSelectedFile().getAbsolutePath();
        this.setFrameTitle();
        Vector lines = TextFile.load(this.filename);
        String tmp = "";
        int i = 0;
        while (i < lines.size()) {
            tmp = String.valueOf(tmp) + lines.get(i) + "\n";
            ++i;
        }
        this.areaFile.setText(tmp);
        try {
            this.areaFile.setCaretPosition(0);
        }
        catch (Exception e) {
            this.println(e);
        }
        this.changed = false;
        this.setConfirm();
    }

    private void saveFile() {
        int retVal;
        if (!this.filename.equals("")) {
            try {
                this.fileChooser.setSelectedFile(new File(this.filename));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((retVal = this.fileChooser.showSaveDialog(this)) != 0) {
            return;
        }
        this.filename = this.fileChooser.getSelectedFile().getAbsolutePath();
        this.setFrameTitle();
        ProperVector lines = new ProperVector();
        lines.add(String.valueOf(this.areaFile.getText()) + "\n");
        TextFile.save(this.filename, lines);
        this.changed = false;
        this.setConfirm();
    }

    private void search() {
        JTextComponentHelper.removeHighlights(this.areaFile);
        if (this.textSearch.getText().equals("")) {
            return;
        }
        JTextComponentHelper.highlight(this.areaFile, this.textSearch.getText());
    }

    private void close() {
        this.windowClosing(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_NEW)) {
            this.newFile();
        } else if (action.equals(ACTION_LOAD)) {
            this.loadFile();
        } else if (action.equals(ACTION_SAVE)) {
            this.saveFile();
        } else if (action.equals(ACTION_NEW)) {
            this.newFile();
        } else if (action.equals(ACTION_SEARCH)) {
            this.search();
        } else if (action.equals("exit")) {
            this.close();
        } else if (action.equals(ACTION_LINEWRAP)) {
            this.areaFile.setLineWrap(this.checkLineWrap.isSelected());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changed = true;
        this.setConfirm();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed = true;
        this.setConfirm();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed = true;
        this.setConfirm();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int col;
        int row;
        try {
            row = this.areaFile.getLineOfOffset(e.getDot());
            col = e.getDot() - this.areaFile.getLineStartOffset(row);
        }
        catch (Exception ex) {
            this.println(ex);
            col = 0;
            row = 0;
        }
        this.labelCoordinates.setText(String.valueOf(++col) + ":" + ++row + " (" + this.areaFile.getLineCount() + " Lines)");
    }

    @Override
    public void printDescription() {
        System.out.println("A little tool for handling logfiles.");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        Editor frame = new Editor(null);
        frame.run(args);
    }
}

