#!/bin/bash

# This script dumps all the databases or a specific one into SQL-files.
#
# $Revision: 1.3 $
# FracPete

#############
# Functions #
#############

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -o <output-dir> -H <hostname> -P <port> -u <user>"
   echo "       -p <password> [-c] [-h]"
   echo 
   echo "Performs a database dump of a MySQL database"
   echo
   echo " -h   this help"
   echo " -o   <output-dir>"
   echo "      the directory where to store the dump files"
   echo "      default: $DIR"
   echo " -H   <hostname>"
   echo "      the host where the databases reside"
   echo "      default: $HOST"
   echo " -P   <port>"
   echo "      the port the server listens on"
   echo "      default: $PORT"
   echo " -u   <user>"
   echo "      the name of the user"
   echo "      default: $USER"
   echo " -p   <password>"
   echo "      the password of the user"
   echo "      default: $PASSWORD"
   echo " -d   <database>"
   echo "      a specific database to dump (empty means all!)"
   echo "      default: $DATABASE"
   echo " -c   create CSV files instead of SQL-statements"
   echo
}

# returns the number of databases in TMP
function get_count()
{
   TMP=`echo "SHOW DATABASES;" | $MYSQL -h $HOST -P $PORT -u $USER -p$PASSWORD | grep -v "Database\|test\|mysql" | wc -l | sed s/" "*//g`
}

# returns the nth database name (n stored in TMP) in TMP
function get_database()
{
   TMP=`echo "SHOW DATABASES;" | $MYSQL -h $HOST -P $PORT -u $USER -p$PASSWORD | grep -v "Database\|test\|mysql" | head -n $TMP | tail -n 1`
}

##################
# Some variables #
##################

ROOT=`expr "$0" : '\(.*\)/'`
DIR=$ROOT/../tmp
HOST="localhost"
PORT="3306"
USER="peter"
PASSWORD="peter"
DATABASE=""
CSV="no"

# interprete parameters
while getopts ":hco:H:P:u:p:d:" flag
do
   case $flag in
      o) DIR=$OPTARG
         ;;
      H) HOST=$OPTARG
         ;;
      P) PORT=$OPTARG
         ;;
      u) USER=$OPTARG
         ;;
      p) PASSWORD=$OPTARG
         ;;
      d) DATABASE=$OPTARG
         ;;
      c) CSV="yes"
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

OUTPUT=$DIR/dump
MYSQL="mysql"
MYSQLDUMP="mysqldump --add-drop-table"

# create dir
if [ ! -d $OUTPUT ]
then
   echo "creating $OUTPUT"
   mkdir $OUTPUT
fi

# dump databases
if [ "$DATABASE" = "" ]
then
   echo "Dumping databases:"
   get_count;COUNT=$TMP
   for ((i = 1; i <= $COUNT; i++))
   do
      TMP=$i;get_database;DB=$TMP
      
      # info
      echo "$i. $DB"
      if [ "$CSV" = "" ]
      then
         $MYSQLDUMP -h $HOST -P $PORT -u $USER -p$PASSWORD $CSV $DB > $OUTPUT/$DB.sql
      else
         mkdir $OUTPUT/$DB
         $MYSQLDUMP -h $HOST -P $PORT -u $USER -p$PASSWORD -T $OUTPUT/$DB $DB
      fi
   done
else
   echo "Dumping database $DATABASE"
   DB=$DATABASE
   if [ "$CSV" = "" ]
   then
      $MYSQLDUMP -h $HOST -P $PORT -u $USER -p$PASSWORD $CSV $DB > $OUTPUT/$DB.sql
   else
      mkdir $OUTPUT/$DB
      $MYSQLDUMP -h $HOST -P $PORT -u $USER -p$PASSWORD -T $OUTPUT/$DB $DB
   fi
fi
