#!/bin/bash
#
# This shell script prepares the data, s.t. Proper can handle it better
#
# use -help to see options
#
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <input-dir> -o <output-dir> [-h]"
   echo 
   echo "changes the predicates 'positive' and 'negative' to 'position'"
   echo "and ':-position'"
   echo
   echo " -h   this help"
   echo " -i   <input-dir>"
   echo "      the directory where the Prolog file is located"
   echo "      default: $SRC"
   echo " -o   <output-dir>"
   echo "      where to put the processed file"
   echo "      default: $DEST"
   echo
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
SRC="$ROOT/original"
DEST="$ROOT"

# interprete parameters
while getopts ":hi:o:" flag
do
   case $flag in
      i) SRC=$OPTARG
         ;;
      o) DEST=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# change the predicates
echo "changing predicates..."
cat $SRC/test.pl | sed s/"positive"/"position"/g | sed s/"negative"/":-position"/g > $DEST/krk.pl

