# Python Relational Data Mining #

[![Documentation Status](https://readthedocs.org/projects/rdm/badge/?version=latest)](http://rdm.readthedocs.io/en/latest/?badge=latest)

This python project was created to enable easier use of several inductive logic programming (ILP) and relational data mining (RDM)
algorithm implementations. One important aim of the project is to offer a common bridge between a RDBMS and the ILP&RDM implementations, since many of approaches accept databases in their own format.

This project also includes the UI components (widgets) for the [ClowdFlows](https://github.com/janezkranjc/clowdflows/) data mining platform.

<!-- TODO: add citations, licenses --> 
Currently, the project offers support for MySQL and PostgreSQL databases and the following algorithms: Aleph, RSD, Wordification, TreeLiker, Relaggs, Quantiles, Cardinalization, 1BC, 1BC2, and Tertius.

## Installation, documentation ##

Please find installation instructions, examples and API reference on [Read the Docs](http://rdm.readthedocs.org/en/latest/).

## Note ##

Please note that this is a research project and that drastic changes can be (and are) made pretty regularly. Changes are documented in the [CHANGELOG](CHANGELOG.md).

Pull requests and issues are welcome.

## Contributors ##

Anže Vavpetič (@anzev), Alain Shakour (@alshak), Matic Perovšek (@mperice)

* [Knowldge Technologies Department](http://kt.ijs.si), Jožef Stefan Institute, Ljubljana
* [Engineering, Computer and Imaging Sciences Laboratory](http://icube-bfo.unistra.fr/en/index.php/Home), University of Strasbourg, France
