/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import proper.util.ProperVector;
import proper.xml.Attribute;
import proper.xml.Node;
import proper.xml.Transformer;

public class Element
extends Node {
    private String name;
    private Vector atts;
    private Vector elements;
    private String content;

    public Element(String name) {
        this(null, name, null);
    }

    public Element(String name, String content) {
        this(null, name, content);
    }

    public Element(Node parent, String name) {
        this(parent, name, null);
    }

    public Element(Node parent, String name, String content) {
        super(parent);
        this.name = name;
        this.setContent(content);
        this.atts = new ProperVector();
        this.elements = new ProperVector();
    }

    public Enumeration attributes() {
        return this.atts.elements();
    }

    @Override
    public Enumeration children() {
        return this.elements.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.elements.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.elements.size();
    }

    public Attribute getAttributeAt(int attIndex) {
        return (Attribute)this.atts.get(attIndex);
    }

    public Attribute getAttribute(String name) {
        Attribute result = null;
        int i = 0;
        while (i < this.getAttributeCount()) {
            if (this.getAttributeAt(i).getName().equals(name)) {
                result = this.getAttributeAt(i);
                break;
            }
            ++i;
        }
        return result;
    }

    public int getAttributeCount() {
        return this.atts.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.elements.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.elements.size() == 0;
    }

    public void add(MutableTreeNode child) {
        this.insert(child, this.getChildCount());
    }

    public void addAttribute(Attribute attr) {
        this.atts.add(attr);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        ((Node)child).setParent(this);
        this.elements.insertElementAt(child, index);
    }

    public void insertAttribute(Attribute attr, int index) {
        this.atts.insertElementAt(attr, index);
    }

    @Override
    public void remove(int index) {
        if (index > -1 && index < this.elements.size()) {
            this.elements.remove(index);
        }
    }

    public void removeAttribute(int index) {
        if (index > -1 && index < this.atts.size()) {
            this.atts.remove(index);
        }
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.remove(this.elements.indexOf(node));
    }

    public void removeAttribute(Attribute attr) {
        this.removeAttribute(this.atts.indexOf(attr));
    }

    public void removeAll() {
        while (this.getChildCount() > 0) {
            this.remove(0);
        }
    }

    public void removeAllAttributes() {
        while (this.getAttributeCount() > 0) {
            this.removeAttribute(0);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setContent(String content) {
        this.content = Transformer.toXML(content);
    }

    public String getContent() {
        return Transformer.fromXML(this.content);
    }

    public boolean isEmpty() {
        return this.content == null;
    }

    public String toString() {
        boolean emptyTag = this.isEmpty() && this.getChildCount() == 0;
        StringBuffer result = new StringBuffer(String.valueOf(this.getIndentionString()) + "<" + this.getName());
        int i = 0;
        while (i < this.atts.size()) {
            result.append(" " + this.atts.get(i).toString());
            ++i;
        }
        if (emptyTag) {
            result.append("/");
        }
        result.append(">");
        if (!this.isEmpty() && this.getChildCount() == 0) {
            result.append(this.content);
        }
        if (this.getChildCount() > 0) {
            i = 0;
            while (i < this.getChildCount()) {
                result.append("\n" + this.getChildAt(i).toString());
                ++i;
            }
            result.append("\n" + this.getIndentionString());
        }
        if (!emptyTag) {
            result.append("</" + this.getName() + ">");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        Element node = new Element("root");
        System.out.println("\n" + node);
        node.setContent("bla");
        System.out.println("\n" + node);
        node.add(new Element("blab"));
        System.out.println("\n" + node);
        node.add(new Element("alskjda"));
        Element child = (Element)node.getChildAt(node.getChildCount() - 1);
        child.setContent("asdljdljqdjqwjd,nssndf aqldkwd;k");
        System.out.println("\n" + node);
        child = (Element)node.getChildAt(node.getChildCount() - 1);
        child.add(new Element("alskjda", "<asdlkad>"));
        System.out.println("\n" + node);
        node.addAttribute(new Attribute("att1", null));
        node.addAttribute(new Attribute("att2"));
        node.addAttribute(new Attribute("att3", "blabal"));
        System.out.println("\n" + node);
        node.setContent(null);
        System.out.println("\n" + node);
        node.remove(0);
        System.out.println("\n" + node);
        node.removeAttribute(1);
        System.out.println("\n" + node);
    }
}

