/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Constant;
import ida.ilp.basic.Function;
import ida.ilp.basic.ParserUtils;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.utils.UniqueIDs;
import ida.utils.collections.FakeMap;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Literal {
    private Term[] terms;
    private String predicate;
    private int id;
    private int hashCode = -1;
    private int nameHashCode;
    private boolean changePermitted = true;
    private static Map<String, Variable> fakeMapVar = new FakeMap<String, Variable>();
    private static Map<String, Constant> fakeMapConst = new FakeMap<String, Constant>();

    private Literal() {
    }

    public Literal(String name, int arity) {
        this.id = (int)UniqueIDs.getUniqueName();
        this.terms = new Term[arity];
        this.predicate = name.intern();
        this.nameHashCode = name.hashCode();
    }

    public Literal(String name, Term ... terms) {
        this(name, terms.length);
        this.set(terms);
    }

    public Literal(String name, List<Term> terms) {
        this.id = (int)UniqueIDs.getUniqueName();
        this.terms = new Term[terms.size()];
        System.arraycopy(terms.toArray(), 0, this.terms, 0, terms.size());
        this.predicate = name.intern();
        this.nameHashCode = name.hashCode();
    }

    public Term get(int index) {
        return this.terms[index];
    }

    public void allowModifications(boolean allow) {
        this.changePermitted = allow;
    }

    public void set(Term term, int index) {
        if (!this.changePermitted) {
            throw new IllegalStateException("This particular literal has been locked for changes. Create new instance and change it.");
        }
        this.hashCode = -1;
        this.terms[index] = term;
    }

    public void set(Term ... terms) {
        for (int i = 0; i < terms.length; ++i) {
            this.set(terms[i], i);
        }
    }

    public int arity() {
        return this.terms.length;
    }

    public int countConstants() {
        int count = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            if (!(this.terms[i] instanceof Constant)) continue;
            ++count;
        }
        return count;
    }

    public String predicate() {
        return this.predicate;
    }

    public static Literal parseLiteral(String str) {
        return Literal.parseLiteral(str, fakeMapVar, fakeMapConst);
    }

    public static Literal parseLiteral(String str, Map<String, Variable> variables, Map<String, Constant> constants) {
        char[] c = str.toCharArray();
        StringBuilder predicateName = new StringBuilder();
        ArrayList arguments = new ArrayList(5);
        int index = 0;
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        boolean ignoreNext = false;
        while (true) {
            if (c[index] == '\\' && !ignoreNext) {
                ignoreNext = true;
            } else {
                if (!(inQuotes || inDoubleQuotes || c[index] != '\'' || ignoreNext)) {
                    predicateName.append(c[index]);
                    inQuotes = true;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '\"' || ignoreNext)) {
                    predicateName.append(c[index]);
                    inDoubleQuotes = true;
                } else if (inQuotes && c[index] == '\'' && !ignoreNext) {
                    predicateName.append(c[index]);
                    inQuotes = false;
                } else if (inDoubleQuotes && c[index] == '\"' && !ignoreNext) {
                    predicateName.append(c[index]);
                    inDoubleQuotes = false;
                } else {
                    if (!inQuotes && !inDoubleQuotes && c[index] == '(') break;
                    predicateName.append(c[index]);
                }
                ignoreNext = false;
            }
            ++index;
        }
        inQuotes = false;
        ignoreNext = false;
        while (index < c.length && c[index] != ')') {
            if (c[index] != '(' && c[index] != ' ') {
                Pair<Term, Integer> pair = ParserUtils.parseTerm(c, index, ')', variables, constants);
                arguments.add(pair.r);
                index = (Integer)pair.s;
            }
            ++index;
        }
        Literal retVal = new Literal(predicateName.toString().trim(), arguments.size());
        for (int i = 0; i < retVal.arity(); ++i) {
            retVal.set((Term)arguments.get(i), i);
        }
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.predicate).append("(");
        for (Term t : this.terms) {
            sb.append(t).append(", ");
        }
        if (sb.charAt(sb.length() - 2) == ',') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)o;
        if (other.terms.length != this.terms.length) {
            return false;
        }
        if (!other.predicate.equals(this.predicate)) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].equals(other.terms[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        int hash = this.nameHashCode;
        for (int i = 0; i < this.terms.length; ++i) {
            hash = (int)((long)this.terms[i].hashCode() * (long)hash);
        }
        this.hashCode = hash;
        return this.hashCode;
    }

    public int id() {
        return this.id;
    }

    public boolean containsVariable() {
        for (Term t : this.terms) {
            if (!(t instanceof Variable)) continue;
            return true;
        }
        return false;
    }

    public boolean containsConstant() {
        for (Term t : this.terms) {
            if (!(t instanceof Constant)) continue;
            return true;
        }
        return false;
    }

    public Set<Term> terms() {
        HashSet<Term> set = new HashSet<Term>();
        for (Term t : this.terms) {
            set.add(t);
        }
        return set;
    }

    public Function toFunction() {
        Function f = new Function(this.predicate, this.arity());
        for (int i = 0; i < f.arity(); ++i) {
            f.set(this.get(i), i);
        }
        return f;
    }

    public Literal copy() {
        Literal p = new Literal();
        p.predicate = this.predicate;
        p.terms = new Term[this.terms.length];
        p.id = this.id;
        p.hashCode = this.hashCode;
        p.nameHashCode = this.nameHashCode;
        for (int i = 0; i < this.terms.length; ++i) {
            p.terms[i] = this.terms[i];
        }
        return p;
    }
}

