/*
 * Decompiled with CFR 0.152.
 */
package ida.utils;

public class StringUtils {
    public static boolean isNumeric(String str) {
        return StringUtils.isInteger(str) || StringUtils.isDouble(str);
    }

    public static boolean isInteger(String str) {
        if ((str = str.trim()).length() == 0) {
            return false;
        }
        if (str == null) {
            return false;
        }
        int index = 0;
        for (char c : str.toCharArray()) {
            if (!(c == '-' && index == 0 && str.length() > 1 || Character.isDigit(c))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDouble(String str) {
        if ((str = str.trim()).length() == 0) {
            return false;
        }
        int countDigits = 0;
        int countDots = 0;
        boolean countEs = false;
        int indexOfE = 0;
        int index = 0;
        for (char c : str.toCharArray()) {
            if (c == '.') {
                if (countDots != 0) return false;
                ++countDots;
            } else if (c == 'e' || c == 'E') {
                if (countEs || countDigits <= 0) return false;
                indexOfE = index;
            } else if (!(c == '-' && index == 0 && str.length() > 1 || c == '-' && index == indexOfE + 1 || Character.isDigit(c))) {
                return false;
            }
            if (Character.isDigit(c)) {
                ++countDigits;
            }
            ++index;
        }
        return countDigits != 0;
    }

    public static String capitalize(String s) {
        if (s.length() > 1) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s.toUpperCase();
    }

    public static String unquote(String s) {
        if (s.contains("'")) {
            return s.substring(s.indexOf("'") + 1, s.lastIndexOf("'"));
        }
        return s;
    }
}

