/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.OptionalDouble;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import util.Mutable;

public class Max
extends AggregateFunction<Mutable<OptionalDouble>> {
    public Max() {
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Numeric();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "max";
        this.resApplied = new Value(Double.NEGATIVE_INFINITY);
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        Double res = -1.7976931348623157E308;
        for (Value val : s) {
            Double curr = val.getNumericValue();
            if (!(curr > res)) continue;
            res = curr;
        }
        return new Value(res);
    }

    @Override
    public Supplier<Mutable<OptionalDouble>> supplier() {
        return () -> new Mutable<OptionalDouble>(OptionalDouble.empty());
    }

    @Override
    public BiConsumer<Mutable<OptionalDouble>, Value> accumulator() {
        return (accum, val) -> {
            if (!((OptionalDouble)accum.get()).isPresent()) {
                accum.set(OptionalDouble.of(-1.7976931348623157E308));
            }
            if (val.getNumericValue() > ((OptionalDouble)accum.get()).getAsDouble()) {
                accum.set(OptionalDouble.of(val.getNumericValue()));
            }
        };
    }

    @Override
    public BinaryOperator<Mutable<OptionalDouble>> combiner() {
        return (a, b) -> {
            if (!((OptionalDouble)a.get()).isPresent() && !((OptionalDouble)b.get()).isPresent()) {
                a.set(OptionalDouble.empty());
            } else {
                a.set(OptionalDouble.of(Math.max(((OptionalDouble)a.get()).orElse(-1.7976931348623157E308), ((OptionalDouble)b.get()).orElse(-1.7976931348623157E308))));
            }
            return a;
        };
    }

    @Override
    public Function<Mutable<OptionalDouble>, Value> finisher() {
        return a -> {
            if (((OptionalDouble)a.get()).isPresent()) {
                return new Value(((OptionalDouble)a.get()).getAsDouble());
            }
            return new Value(null);
        };
    }
}

