/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.catalog.Catalog;
import data.condition.Condition;
import data.condition.FilterFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import model.inference.ConditionApplication;
import org.jdom2.Content;
import org.jdom2.Element;

public class NodeSplit {
    private FilterFeature splitCondition;
    private double score;
    private Instances allInstances;
    private Instances left;
    private Instances right;
    private Instances noValue;

    public NodeSplit(Instances l, Instances r, Instances n, FilterFeature ff, double s) {
        this.left = l;
        this.right = r;
        this.noValue = n;
        this.allInstances = new Instances(this.left);
        this.allInstances.addAll(this.right);
        this.allInstances.addAll(this.noValue);
        this.score = s;
        this.splitCondition = ff;
    }

    public NodeSplit(Element splEl, Catalog cat) {
        this(new Instances(), new Instances(), new Instances(), (FilterFeature)Condition.fromXML(splEl.getChild("condition"), cat), Double.NaN);
    }

    public String toString() {
        String repartition = new String();
        repartition = "Left-Right-NoValue : " + this.left.size() + "-" + this.right.size() + "-" + this.noValue.size();
        return String.valueOf(this.splitCondition.toString()) + "\n" + repartition + "\n" + "Score : " + this.score;
    }

    public ConditionApplication apply(Instance id, Catalog cat) {
        return this.splitCondition.apply(id, cat);
    }

    public Instances getLeft() {
        return this.left;
    }

    public Instances getRight() {
        return this.right;
    }

    public Instances getNoValue() {
        return this.noValue;
    }

    public Instances getAllInstances() {
        return this.allInstances;
    }

    public double getScore() {
        return this.score;
    }

    public FilterFeature getSplitCondition() {
        return this.splitCondition;
    }

    public Element toXMLElement() {
        Element el = new Element("split");
        el.addContent((Content)this.splitCondition.toXMLElement());
        return el;
    }

    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        this.splitCondition.initShifts(vals, cat);
    }

    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        this.splitCondition.deployShifts(vals, cat);
    }
}

