/*
 * Decompiled with CFR 0.152.
 */
package model.tree;

import data.catalog.Catalog;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import model.distribution.Distribution;
import model.inference.hc.AggregateBase;
import model.tree.AggregatePrototype;
import model.tree.InternalNode;
import model.tree.Leaf;
import org.jdom2.Element;
import util.Couple;

public abstract class Node {
    protected Distribution distribution;
    private Node parent;
    protected int depth;

    public abstract Value classify(Instance var1, Catalog var2);

    public Value predict() {
        if (this.distribution.canPredict()) {
            return this.distribution.predict();
        }
        return this.parent.predict();
    }

    protected void setParent(InternalNode par) {
        this.parent = par;
    }

    public String toString() {
        return this.toStringRec(0);
    }

    protected abstract String toStringRec(int var1);

    public abstract HashSet<Value> classifyMajority(Instance var1, Catalog var2);

    protected HashSet<Value> predictMajority() {
        if (this.distribution.canPredict()) {
            return this.distribution.predictMajority();
        }
        return this.parent.predictMajority();
    }

    public abstract HashMap<Value, Double> classifyProbabilities(Instance var1, Catalog var2);

    protected HashMap<Value, Double> predictProbabilities(HashSet<Value> classes) {
        if (this.distribution.canPredict()) {
            return this.distribution.probabilities(classes);
        }
        return this.parent.predictProbabilities(classes);
    }

    public HashMap<NumericShiftFunction, double[]> getShifts(Instances insts, Catalog cat) {
        return new HashMap<NumericShiftFunction, double[]>();
    }

    public HashMap<AggregatePrototype, ArrayList<Double>> getAllFeatures(ArrayList<SimpleFeature> sfs) {
        return new HashMap<AggregatePrototype, ArrayList<Double>>();
    }

    public HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>> getBias() {
        return new HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>>();
    }

    public HashMap<AggregateBase, HashSet<SimpleFeature>> getComplexAggregates() {
        return new HashMap<AggregateBase, HashSet<SimpleFeature>>();
    }

    public HashSet<SimpleFeature> getMainFeatures() {
        return new HashSet<SimpleFeature>();
    }

    public abstract Element toXMLElement();

    public static Node fromXML(Element rootEl, Catalog cat, int d) {
        if (rootEl.getName().equals("inode")) {
            return new InternalNode(rootEl, cat, d);
        }
        if (rootEl.getName().equals("leaf")) {
            return new Leaf(rootEl, d);
        }
        return null;
    }

    public void initShifts(Instances insts, Catalog cat) {
    }

    public HashSet<NumericShiftFunction> getShifts() {
        return new HashSet<NumericShiftFunction>();
    }

    public void deployShifts(Instances insts, Catalog cat) {
    }
}

