/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.DatabaseLister;
import proper.database.TableLister;
import proper.gui.core.event.ConnectorChangeEvent;
import proper.gui.core.event.ConnectorChangeListener;
import proper.gui.core.event.SizeChangeEvent;
import proper.gui.core.event.SizeChangeListener;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.panel.ProperPanel;
import proper.util.ProperVector;

public class DatabasePanel
extends ProperPanel {
    public static final String ACTION_CONNECT = "connect";
    public static final String ACTION_SELECTDATABASE = "select_database";
    public static final String ACTION_SELECTTABLE = "select_table";
    public static final String PROPERTY_DATABASE = "database";
    public static final String PROPERTY_TABLE = "table";
    public static final String PROPERTY_COLUMN = "column";
    private JButton buttonConnect;
    private JButton buttonSelectDatabase;
    private JButton buttonSelectTable;
    private JLabel labelDriver;
    private JLabel labelUrl;
    private JLabel labelUser;
    private JLabel labelPassword;
    private JLabel labelDatabases;
    private JLabel labelTables;
    private JLabel labelExcludes;
    private JLabel labelColumns;
    private JTextField textDriver;
    private JTextField textUrl;
    private JTextField textUser;
    private JTextField textPassword;
    private JTextField textExcludes;
    private JComboBox comboDatabases;
    private JComboBox comboTables;
    private JComboBox comboColumns;
    private JPanel panelDriver;
    private JPanel panelConnect;
    private JPanel panelDatabases;
    private JPanel panelTables;
    private JPanel panelColumns;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String excludes;
    private Connector conn;
    private boolean showDriver;
    private boolean showConnect;
    private boolean showTables;
    private boolean showColumns;
    private String database;
    private String table;
    private String column;
    private String preferredDatabase;
    private String preferredTable;
    private String preferredColumn;
    private HashSet sizeListeners;
    private HashSet connectorListeners;

    public DatabasePanel() {
        this.initialize();
        this.createPanel();
    }

    @Override
    protected void initialize() {
        this.showDriver = true;
        this.showConnect = true;
        this.showTables = false;
        this.showColumns = false;
        this.driver = "org.gjt.mm.mysql.Driver";
        this.url = "jdbc:mysql://localhost:3306/";
        this.user = "nobody";
        this.password = "";
        this.excludes = "_keys,_file*,_identifier_";
        this.password = "";
        this.preferredDatabase = "";
        this.preferredTable = "";
        this.preferredColumn = "";
        this.database = "";
        this.table = "";
        this.column = "";
        this.sizeListeners = new HashSet();
        this.connectorListeners = new HashSet();
        try {
            this.conn = new Connector();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.conn = null;
        }
    }

    @Override
    protected void createPanel() {
        this.setLayout(new GridLayout(0, 1));
        this.labelDriver = new JLabel("Driver");
        this.textDriver = new JTextField(20);
        this.panelDriver = new JPanel(new FlowLayout(3));
        this.panelDriver.add(this.labelDriver);
        this.panelDriver.add(this.textDriver);
        this.add(this.panelDriver);
        this.labelUrl = new JLabel("URL");
        this.textUrl = new JTextField(20);
        this.labelUser = new JLabel("User");
        this.textUser = new JTextField(10);
        this.labelPassword = new JLabel("Password");
        this.textPassword = new JTextField(10);
        this.buttonConnect = new JButton("Connect", ImageLoader.getImageIcon("network.gif"));
        this.buttonConnect.setActionCommand(ACTION_CONNECT);
        this.panelConnect = new JPanel(new FlowLayout(3));
        this.panelConnect.add(this.labelUrl);
        this.panelConnect.add(this.textUrl);
        this.panelConnect.add(this.labelUser);
        this.panelConnect.add(this.textUser);
        this.panelConnect.add(this.labelPassword);
        this.panelConnect.add(this.textPassword);
        this.panelConnect.add(this.buttonConnect);
        this.add(this.panelConnect);
        this.labelDatabases = new JLabel("Databases");
        this.comboDatabases = new JComboBox();
        this.comboDatabases.addItemListener(this);
        this.buttonSelectDatabase = new JButton("Select", ImageLoader.getImageIcon("open.gif"));
        this.buttonSelectDatabase.setActionCommand(ACTION_SELECTDATABASE);
        this.labelTables = new JLabel("Tables");
        this.comboTables = new JComboBox();
        this.comboTables.addItemListener(this);
        this.labelExcludes = new JLabel("Exclude Pattern");
        this.textExcludes = new JTextField(10);
        this.buttonSelectTable = new JButton("Select", ImageLoader.getImageIcon("open.gif"));
        this.buttonSelectTable.setActionCommand(ACTION_SELECTTABLE);
        this.labelColumns = new JLabel("Columns");
        this.comboColumns = new JComboBox();
        this.comboColumns.addItemListener(this);
        this.panelDatabases = new JPanel(new FlowLayout(3));
        this.panelDatabases.add(this.labelDatabases);
        this.panelDatabases.add(this.comboDatabases);
        this.panelDatabases.add(this.buttonSelectDatabase);
        this.add(this.panelDatabases);
        this.panelTables = new JPanel(new FlowLayout(3));
        this.panelTables.add(this.labelExcludes);
        this.panelTables.add(this.textExcludes);
        this.panelTables.add(this.labelTables);
        this.panelTables.add(this.comboTables);
        this.panelTables.add(this.buttonSelectTable);
        this.add(this.panelTables);
        this.panelColumns = new JPanel(new FlowLayout(3));
        this.panelColumns.add(this.labelColumns);
        this.panelColumns.add(this.comboColumns);
        this.add(this.panelColumns);
        this.addActionListener(this);
        this.setEnabledState("");
        this.setValues();
    }

    @Override
    public void invalidate() {
        int rows = 1;
        if (this.getShowDriver()) {
            ++rows;
        }
        if (this.getShowConnect()) {
            ++rows;
        }
        if (this.getShowTables()) {
            ++rows;
        }
        if (this.getShowColumns()) {
            ++rows;
        }
        ((GridLayout)this.getLayout()).setRows(rows);
        super.invalidate();
    }

    public void setConnector(Connector conn) {
        this.conn = conn;
        if (conn != null) {
            this.driver = conn.getDriver();
            this.url = conn.getUrl();
            this.database = conn.getDatabase();
            this.user = conn.getUser();
            this.password = conn.getPassword();
            try {
                if (conn.isConnected()) {
                    this.setShowConnect(false);
                    this.comboDatabases.setEnabled(true);
                    this.buttonSelectDatabase.setEnabled(true);
                    this.setValues();
                    this.listDatabases();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.driver = "";
            this.url = "";
            this.database = "";
            this.user = "";
            this.password = "";
            this.setShowConnect(true);
            this.setEnabledState("");
        }
    }

    public Connector getConnector() {
        return this.conn;
    }

    public void setDriver(String driver) {
        this.textDriver.setText(driver);
    }

    public String getDriver() {
        return this.textDriver.getText();
    }

    public void setUrl(String url) {
        this.textUrl.setText(url);
    }

    public String getUrl() {
        return this.textUrl.getText();
    }

    public void setUser(String user) {
        this.textUser.setText(user);
    }

    public String getUser() {
        return this.textUser.getText();
    }

    public void setPassword(String password) {
        this.textPassword.setText(password);
    }

    public String getPassword() {
        return this.textPassword.getText();
    }

    public void setExcludes(String excludes) {
        this.textExcludes.setText(excludes);
    }

    public String getExcludes() {
        return this.textExcludes.getText();
    }

    public void setShowDriver(boolean show) {
        this.showDriver = show;
        this.remove(this.panelDriver);
        if (this.showDriver) {
            this.add((Component)this.panelDriver, 0);
        }
        this.invalidate();
    }

    public boolean getShowDriver() {
        return this.showDriver;
    }

    public void setShowConnect(boolean show) {
        this.showConnect = show;
        this.remove(this.panelConnect);
        if (this.showConnect) {
            if (this.getShowDriver()) {
                this.add((Component)this.panelConnect, 1);
            } else {
                this.add((Component)this.panelConnect, 0);
            }
        }
        this.invalidate();
    }

    public boolean getShowConnect() {
        return this.showConnect;
    }

    public void setShowTables(boolean show) {
        this.showTables = show;
        this.remove(this.panelTables);
        this.remove(this.panelColumns);
        if (this.showTables) {
            this.add(this.panelTables);
        }
        this.buttonSelectDatabase.setVisible(this.showTables);
        this.invalidate();
    }

    public boolean getShowTables() {
        return this.showTables;
    }

    public void setShowColumns(boolean show) {
        this.showColumns = show;
        this.remove(this.panelColumns);
        if (this.showColumns) {
            this.add(this.panelColumns);
        }
        this.buttonSelectTable.setVisible(this.showColumns);
        this.invalidate();
    }

    public boolean getShowColumns() {
        return this.showColumns;
    }

    public void setDatabase(String database) {
        this.database = database;
        this.setSelectedItem(this.comboDatabases, database);
    }

    public String getDatabase() {
        return this.database;
    }

    public void setPreferredDatabase(String preferredDatabase) {
        this.preferredDatabase = preferredDatabase;
    }

    public String getPreferredDatabase() {
        return this.preferredDatabase;
    }

    public Vector getDatabases() {
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < this.comboDatabases.getItemCount()) {
            result.add(this.comboDatabases.getItemAt(i));
            ++i;
        }
        return result;
    }

    public void setTable(String table) {
        this.table = table;
        this.setSelectedItem(this.comboTables, table);
    }

    public String getTable() {
        return this.table;
    }

    public void setPreferredTable(String preferredTable) {
        this.preferredTable = preferredTable;
    }

    public String getPreferredTable() {
        return this.preferredTable;
    }

    public Vector getTables() {
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < this.comboTables.getItemCount()) {
            result.add(this.comboTables.getItemAt(i));
            ++i;
        }
        return result;
    }

    public void setColumn(String column) {
        this.column = column;
        this.setSelectedItem(this.comboColumns, column);
    }

    public String getColumn() {
        return this.column;
    }

    public void setPreferredColumn(String preferredColumn) {
        this.preferredColumn = preferredColumn;
    }

    public String getPreferredColumn() {
        return this.preferredColumn;
    }

    protected void setValues() {
        this.setShowDriver(this.showDriver);
        this.setShowTables(this.showTables);
        this.setShowColumns(this.showColumns);
        this.textDriver.setText(this.driver);
        this.textUrl.setText(this.url);
        this.textUser.setText(this.user);
        this.textPassword.setText(this.password);
        this.textExcludes.setText(this.excludes);
        if (this.database != null && !this.database.equals("")) {
            this.setSelectedItem(this.comboDatabases, this.database);
        } else if (!this.preferredDatabase.equals("")) {
            this.setSelectedItem(this.comboDatabases, this.preferredDatabase);
        }
        if (!this.table.equals("")) {
            this.setSelectedItem(this.comboTables, this.table);
        } else if (!this.preferredTable.equals("")) {
            this.setSelectedItem(this.comboTables, this.preferredTable);
        }
        if (!this.column.equals("")) {
            this.setSelectedItem(this.comboColumns, this.column);
        } else if (!this.preferredColumn.equals("")) {
            this.setSelectedItem(this.comboColumns, this.preferredColumn);
        }
    }

    @Override
    protected void setEnabledState(String action) {
        if (action.equals("")) {
            this.comboDatabases.setEnabled(false);
            this.buttonSelectDatabase.setEnabled(false);
            this.textExcludes.setEnabled(false);
            this.comboTables.setEnabled(false);
            this.comboColumns.setEnabled(false);
        } else if (action.equals(ACTION_CONNECT)) {
            this.comboDatabases.setEnabled(true);
            this.buttonSelectDatabase.setEnabled(true);
            this.textExcludes.setEnabled(true);
            this.comboTables.setEnabled(false);
            this.comboColumns.setEnabled(false);
        } else if (action.equals(ACTION_SELECTDATABASE)) {
            this.comboDatabases.setEnabled(true);
            this.buttonSelectDatabase.setEnabled(true);
            this.textExcludes.setEnabled(true);
            this.comboTables.setEnabled(true);
            this.comboColumns.setEnabled(false);
        } else if (action.equals(ACTION_SELECTTABLE)) {
            this.comboDatabases.setEnabled(true);
            this.buttonSelectDatabase.setEnabled(true);
            this.textExcludes.setEnabled(true);
            this.comboTables.setEnabled(true);
            this.comboColumns.setEnabled(true);
        }
    }

    private void listDatabases() {
        this.comboDatabases.removeAllItems();
        if (this.getUrl().startsWith("jdbc:odbc:")) {
            return;
        }
        if (this.conn != null) {
            try {
                DatabaseLister lister = new DatabaseLister(this.conn);
                Vector list = lister.getList();
                this.preferredDatabase = this.database;
                int i = 0;
                while (i < list.size()) {
                    this.comboDatabases.addItem(list.get(i).toString());
                    ++i;
                }
                this.database = this.preferredDatabase;
                this.comboDatabases.setSelectedItem(this.database);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void listTables() {
        this.comboTables.removeAllItems();
        if (this.conn != null) {
            try {
                TableLister lister = new TableLister(this.conn);
                lister.setExcludes(this.textExcludes.getText());
                lister.setSort(true);
                Vector list = lister.getList();
                int i = 0;
                while (i < list.size()) {
                    this.comboTables.addItem(list.get(i).toString());
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void listColumns() {
        this.comboColumns.removeAllItems();
        if (this.conn != null) {
            try {
                ColumnLister lister = new ColumnLister(this.conn);
                lister.setTable(this.getTable());
                lister.setSort(true);
                Vector list = lister.getList();
                int i = 0;
                while (i < list.size()) {
                    this.comboColumns.addItem(list.get(i).toString());
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void connect() {
        this.comboDatabases.removeAllItems();
        this.comboTables.removeAllItems();
        this.comboColumns.removeAllItems();
        try {
            if (this.conn == null) {
                this.conn = new Connector();
            }
            this.conn.connect(this.textDriver.getText(), this.textUrl.getText(), "", this.textUser.getText(), this.textPassword.getText());
            this.listDatabases();
            this.setEnabledState(ACTION_CONNECT);
            this.setSelectedItem(this.comboDatabases, this.getPreferredDatabase());
            this.notifySizeListeners();
            this.notifyConnectorListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectDatabase() {
        this.comboTables.removeAllItems();
        this.comboColumns.removeAllItems();
        try {
            if (this.conn == null) {
                this.conn = new Connector();
            }
            this.conn.connect(this.textDriver.getText(), this.textUrl.getText(), this.getDatabase(), this.textUser.getText(), this.textPassword.getText());
            this.listTables();
            this.setEnabledState(ACTION_SELECTDATABASE);
            this.setSelectedItem(this.comboTables, this.getPreferredTable());
            this.notifySizeListeners();
            this.notifyConnectorListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectTable() {
        this.comboColumns.removeAllItems();
        try {
            this.listColumns();
            this.setEnabledState(ACTION_SELECTTABLE);
            this.setSelectedItem(this.comboColumns, this.getPreferredColumn());
            this.notifySizeListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_CONNECT)) {
            this.connect();
            this.firePropertyChange(action, "", "true");
        } else if (action.equals(ACTION_SELECTDATABASE)) {
            this.selectDatabase();
            this.firePropertyChange(action, "", "true");
        } else if (action.equals(ACTION_SELECTTABLE)) {
            this.selectTable();
            this.firePropertyChange(action, "", "true");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.comboDatabases) {
            if (this.comboDatabases.getSelectedIndex() > -1) {
                String tmp = this.database;
                this.database = this.comboDatabases.getSelectedItem().toString();
                this.firePropertyChange(PROPERTY_DATABASE, tmp, this.database);
            }
        } else if (e.getSource() == this.comboTables) {
            if (this.comboTables.getSelectedIndex() > -1) {
                String tmp = this.table;
                this.table = this.comboTables.getSelectedItem().toString();
                this.firePropertyChange(PROPERTY_TABLE, tmp, this.table);
            }
        } else if (e.getSource() == this.comboColumns && this.comboColumns.getSelectedIndex() > -1) {
            String tmp = this.column;
            this.column = this.comboColumns.getSelectedItem().toString();
            this.firePropertyChange(PROPERTY_COLUMN, tmp, this.column);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.buttonConnect.removeActionListener(listener);
        this.buttonSelectDatabase.removeActionListener(listener);
        this.buttonSelectTable.removeActionListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.removeActionListener(listener);
        this.buttonConnect.addActionListener(listener);
        this.buttonSelectDatabase.addActionListener(listener);
        this.buttonSelectTable.addActionListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.textDriver.removeKeyListener(listener);
        this.textUrl.removeKeyListener(listener);
        this.textUser.removeKeyListener(listener);
        this.textPassword.removeKeyListener(listener);
        this.textExcludes.removeKeyListener(listener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.removeKeyListener(listener);
        this.textDriver.addKeyListener(listener);
        this.textUrl.addKeyListener(listener);
        this.textUser.addKeyListener(listener);
        this.textPassword.addKeyListener(listener);
        this.textExcludes.addKeyListener(listener);
    }

    private void notifySizeListeners() {
        Dimension size = new Dimension(this.getPreferredSize());
        SizeChangeEvent event = new SizeChangeEvent(this, size);
        Iterator iter = this.sizeListeners.iterator();
        while (iter.hasNext()) {
            ((SizeChangeListener)iter.next()).sizeChanged(event);
        }
    }

    public void removeSizeChangeListener(SizeChangeListener listener) {
        this.sizeListeners.remove(listener);
    }

    public void addSizeChangeListener(SizeChangeListener listener) {
        this.sizeListeners.add(listener);
    }

    private void notifyConnectorListeners() {
        ConnectorChangeEvent event = new ConnectorChangeEvent(this, this.conn);
        Iterator iter = this.connectorListeners.iterator();
        while (iter.hasNext()) {
            ((ConnectorChangeListener)iter.next()).connectorChanged(event);
        }
    }

    public void removeConnectorChangeListener(ConnectorChangeListener listener) {
        this.connectorListeners.remove(listener);
    }

    public void addConnectorChangeListener(ConnectorChangeListener listener) {
        this.connectorListeners.add(listener);
    }
}

