/*
 * Decompiled with CFR 0.152.
 */
package eval;

import data.catalog.Catalog;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import eval.Evaluation;
import eval.EvaluationStats;
import eval.GroupedClassificationStats;
import eval.GroupedEvaluationStats;
import eval.GroupedRegressionStats;
import eval.SimpleEvaluation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import model.Model;
import util.FileWrite;
import util.Logging;

public class CrossValidation
extends Evaluation {
    protected int n;
    protected Random rt;
    protected ArrayList<SimpleEvaluation> localEvals;
    protected GroupedEvaluationStats groupStats;

    public CrossValidation(String m, int folds, Random r) {
        super(m);
        this.n = folds;
        this.rt = r;
        this.localEvals = new ArrayList(this.n);
        if (this.mode.equals("classification")) {
            this.groupStats = new GroupedClassificationStats();
        } else if (this.mode.equals("regression")) {
            this.groupStats = new GroupedRegressionStats();
        }
    }

    @Override
    public void evaluateModel(Model model, Instances insts, Catalog cat, boolean print) {
        FileWrite.clearFile("bins");
        Collections.shuffle(insts, this.rt);
        int k = 0;
        while (k < this.n) {
            Logging.main.info((Object)("Cross validation " + (k + 1) + " / " + this.n + " starts."));
            Instances train = this.trainCV(insts, this.n, k);
            Instances test = this.testCV(insts, this.n, k);
            for (Instance inst : test) {
                FileWrite.writeToFile("bins", inst.getId() + ",");
            }
            FileWrite.writeToFile("bins");
            Model mod = model.clone();
            mod.addToName("_cv" + (k + 1));
            long t1 = System.currentTimeMillis();
            mod.build(train, cat);
            long t2 = System.currentTimeMillis();
            FileWrite.writeToFile(String.valueOf(model.name()) + "_cv_runtime", String.valueOf(mod.name()) + " training : " + (t2 - t1) + "\n");
            SimpleEvaluation simpleEval = new SimpleEvaluation(this.mode);
            simpleEval.evaluateModel(mod, test, cat, print);
            this.predictions.putAll(simpleEval.getPredictions());
            this.localEvals.add(simpleEval);
            Logging.main.info((Object)("Cross validation " + (k + 1) + " / " + this.n + " finishes."));
            ++k;
        }
        this.stats.computeStats(this.predictions);
        this.groupStats.computeStats(new ArrayList<EvaluationStats>(this.localEvals.stream().map(eval -> eval.getStatistics()).collect(Collectors.toList())));
        if (print) {
            FileWrite.writeToFile(String.valueOf(model.name()) + "_cv_eval", this.stats.toString());
            FileWrite.writeToFile(String.valueOf(model.name()) + "_cv_predictions", "Id;Weight;Actual;Predicted\n");
            for (Map.Entry<Instance, Value> ent : this.getPredictions().entrySet()) {
                FileWrite.writeToFile(String.valueOf(model.name()) + "_cv_predictions", ent.getKey().getId() + ";" + ent.getKey().getWeight() + ";" + ent.getKey().getLabel() + ";" + ent.getValue() + "\n");
            }
        }
    }

    public Instances trainCV(Instances insts, int n, int k) {
        Instances res = new Instances();
        int i = 0;
        while (i < insts.size()) {
            if (n * (i + 1) <= k * insts.size() || n * (i + 1) > (k + 1) * insts.size()) {
                res.add((Instance)insts.get(i));
            }
            ++i;
        }
        return res;
    }

    public Instances testCV(Instances insts, int n, int k) {
        Instances res = new Instances();
        int i = 0;
        while (i < insts.size()) {
            if (n * (i + 1) > k * insts.size() && n * (i + 1) <= (k + 1) * insts.size()) {
                res.add((Instance)insts.get(i));
            }
            ++i;
        }
        return res;
    }
}

