/*
 * Decompiled with CFR 0.152.
 */
package main;

import data.catalog.CatalogFile;
import data.instance.Instance;
import data.instance.Instances;
import eval.Evaluation;
import eval.SimpleEvaluation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import model.Model;
import model.ModelOptions;
import model.tree.DecisionTree;
import model.tree.RandomForest;
import util.FileWrite;
import util.GlobalRandom;

public class FlowLaunch {
    public static void main(String[] args) throws Exception {
        GlobalRandom.init(0L);
        String sourceDirectory = String.valueOf(new File(".").getAbsolutePath()) + "/";
        String fileName = new String();
        fileName = args[0].charAt(0) == '/' ? args[0] : String.valueOf(sourceDirectory) + args[0];
        FileWrite.setFileWrite(fileName);
        FileWrite.clearLog();
        ModelOptions opt = ModelOptions.getOptions(fileName);
        CatalogFile cat = new CatalogFile();
        cat.fillCatalog(String.valueOf(fileName) + ".prd", String.valueOf(fileName) + ".fct");
        cat.setClassInstances(opt.classPredicate);
        cat.setFunctions(opt.aggFunctions);
        Model mod = null;
        mod = opt.treesInForest > 1 ? new RandomForest(opt) : new DecisionTree(opt);
        Instances train = new Instances();
        Instances test = new Instances();
        BufferedReader brMain = new BufferedReader(new FileReader("/Users/ccharnay/Documents/these/aggregates/flowcap/HVTNTraining.csv"));
        String line = brMain.readLine();
        while ((line = brMain.readLine()) != null) {
            String[] tokens = line.split(",");
            if (!tokens[0].equals("ENV-1-PTEG") && !tokens[0].equals("GAG-1-PTEG")) continue;
            int mainId = Integer.parseInt(tokens[5].split("\\.")[0]);
            for (Instance inst : cat.getClassInstances()) {
                if (!inst.getId().getStringValue().equals(String.valueOf(mainId))) continue;
                train.add(inst);
            }
        }
        for (Instance inst : cat.getClassInstances()) {
            if (train.contains(inst)) continue;
            test.add(inst);
        }
        brMain.close();
        SimpleEvaluation eval = new SimpleEvaluation("classification");
        mod.build(train, cat);
        ((Evaluation)eval).evaluateModel(mod, test, cat, true);
    }
}

