/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.engine.BagArffer;
import proper.engine.Engine;

public class Bagger
extends DatabaseApplication {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("verbose", "switches on the verbose for writing the instances from the database to the\nARFF-file", true, "Writer", true);
        this.addDefinition("table", "the table that stores the multi-instance data", true, "<name>", false);
        this.addDefinition("bag", "the field to use as bag identifier, default is the index in the flattened", true, "<name>", true);
        this.addDefinition("field", "the field to use as class", true, "<name>", false);
        this.addDefinition("exclude_fields", "fields you want to exclude from exporting to the classifier (e.g. if they\ncontain some implicit information); separate the filed with comma", true, "name[,name...]", true);
        this.addDefinition("order", "whether to order fields (default is 'yes')", true, "yes | no", true);
        this.addDefinition("output", "the name of the ARFF-File (used for outputing instances)", true, "<name>", true);
        this.addDefinition("type", "whether to output only classified instances or only unclassified ones", true, "classified | unclassified", true);
        this.addDefinition("percentage", "a value between 0 and 100 that represents the percentage of instances to be\nexported (uniformly distributed, i.e. every class is exported with the same\npercentage. 0 or 100 means that all instances are exported.", true, "<double>", true);
        this.addDefinition("filter", "the complete name of a WEKA filter", true, "<name>", true);
        this.addDefinition("filter_additional", "additional parameters for the filter", true, "<args>", true);
        this.addDefinition("missing_binary_to_zero", "if nominal attributes were postprocessed with the NominalToBinary-Filter\nthen the missing values can be set to '0' with this option.", false, "", true);
        this.addDefinition("ignore_empty_nominal", "whether to ignore nominal attributes that have no values (default is to include them with a dummy value)", false, "", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Creates a Multi-Instance ARFF-File from a table, which can be used with MILK.");
        System.out.println();
    }

    private String buildExcludeFields() {
        String result = this.cl.getValue("exclude_fields");
        if (!result.equals("")) {
            result = String.valueOf(result) + ",";
        }
        result = String.valueOf(result) + "*_" + this.cl.getValue("field");
        return result;
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nBagging\n=======\n");
        BagArffer engine = new BagArffer();
        this.initEngine(engine);
        engine.setParameter("table", this.cl.getValue("table"));
        engine.setParameter("bag", this.cl.getValue("bag"));
        engine.setParameter("field", this.cl.getValue("field"));
        engine.setParameter("output", this.cl.getValue("output"));
        engine.setParameter("exclude_fields", this.buildExcludeFields());
        if (this.cl.hasValue("type")) {
            engine.setParameter("type", this.cl.getValue("type"));
        }
        if (this.cl.exists("order")) {
            engine.setParameter("order", this.cl.getValue("order"));
        }
        if (this.cl.hasValue("percentage")) {
            engine.setParameter("percentage", this.cl.getValue("percentage"));
        }
        if (this.cl.hasValue("filter")) {
            engine.setParameter("filter", this.cl.getValue("filter"));
        }
        if (this.cl.hasValue("filter_additional")) {
            engine.setParameter("filter_additional", this.fixAdditionalArg(this.cl.getValue("filter_additional")));
        }
        if (this.cl.exists("missing_binary_to_zero")) {
            engine.setParameter("missing_binary_to_zero", this.cl.getValue("missing_binary_to_zero"));
        }
        if (this.cl.exists("ignore_empty_nominal")) {
            engine.setParameter("ignore_empty_nominal", "yes");
        }
        return ((Engine)engine).execute();
    }

    public static void main(String[] args) throws Exception {
        Bagger app = new Bagger();
        app.run(args);
    }
}

