/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.util.StringTokenizer;
import proper.app.DatabaseApplication;
import proper.database.Creator;

public class Databases
extends DatabaseApplication {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("initial_database", "the initial database to connect to, PostgreSQL e.g. does not allow to\nconnect to the host alone.", true, "<name>", true);
        this.addDefinition("sql_createdatabase", "SQL statement that creates a database, e.g. 'CREATE DATABASE %NAME%'", true, "<sql>", true);
        this.addNote("-database:\n the database(s) to create on the host (comma separated list)");
    }

    @Override
    public void printDescription() {
        System.out.println("Creates a Database on the Database server.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nDatabase\n========\n");
        boolean result = true;
        Creator creator = new Creator(this.cl.getValue("driver"), String.valueOf(this.cl.getValue("url")) + this.cl.getValue("initial_database"), this.cl.getValue("user"), this.cl.getValue("password"));
        this.addListener(creator);
        if (this.cl.exists("sql_createdatabase")) {
            creator.setCreateStatement(this.cl.getValue("sql_createdatabase"));
        }
        StringTokenizer tok = new StringTokenizer(this.cl.getValue("database"), ",");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            if (creator.exists(name)) {
                this.println("Found " + name + "...");
                continue;
            }
            this.print("Creating " + name + "... ");
            if (creator.create(name)) {
                this.println("OK!");
                continue;
            }
            this.println("FAILED!");
            this.println("Statement:\n" + creator.getLastStatement());
            this.println("Exception:\n" + creator.getLastException());
            result = false;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Databases app = new Databases();
        app.run(args);
    }
}

