/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.engine.Importer;

public class Import
extends DatabaseApplication {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("verbose", "switches on the verbose for parsing the file(s)", true, String.valueOf(this.getClass().getName()) + ":1", true);
        this.addDefinition("verbose", "switches on the verbose for parsing and the INSERT statements (lots of\ninformation!)", true, String.valueOf(this.getClass().getName()) + ":2", true);
        this.addDefinition("rel_database", "the prolog database to import (no explicit IDs, but relational model)", true, "<name, [name, ...]>", true);
        this.addDefinition("background", "the prolog background knowledge (explicit IDs)", true, "<name, [name, ...]>", true);
        this.addDefinition("add_pos_class", "adds a positive class label to background knowledge adds a positive\nclass label to background knowledge considered being positive examples)", false, "", true);
        this.addDefinition("add_neg_class", "automatically adds negative examples for missing keys, i.e. if the\nbackground knowledge covers only some ids then the others are added with\nthe negative class label", false, "", true);
        this.addDefinition("positive", "the prolog file with positive examples (explicit IDs, no class label)", true, "<name, [name, ...]>", true);
        this.addDefinition("negative", "the prolog file with negative examples (explicit IDs, no class label)", true, "<name, [name, ...]>", true);
        this.addDefinition("pos_neg", "the prolog file with positive and negative examples (explicit IDs, negative\nexamples with leading ':- ')", true, "<name, [name, ...]>", true);
        this.addDefinition("unclassified", "the prolog file with unclassified examples", true, "<name, [name, ...]>", true);
        this.addDefinition("id_index", "here you can specify whether a certain argument contains the ID\nyou can specify more than one index (separated by comma), e.g. 'first,last'\nif you want to specify it only for a specific predicate, then put it in\nfront of the index, separated by a colon, e.g. 'great:last'\nif you want to override a general index for a specific predicate you can do\nthis by a preceding '!', e.g. '!bond:first'\nIf there is more than one index in one predicate, each instance is split\ninto two (the relation between them is via a 'split_id'). If it is not a\nsymmetric relationship, you can define this with the 'asymmetric' parameter.", true, "first | second | third | last | <int>", true);
        this.addDefinition("asymmetric", "defines which predicates that have more than one index hava an asymmetric\nrelationship between the indices.", true, "<predicate[,predicate[,...]]>", true);
        this.addDefinition("shuffle", "randomizes the order of the predicates (to prevent implicit information from\ngenerated keys)", false, "", true);
        this.addDefinition("reduce_lists", "whether to reduce lists to regular arguments if they all have the same size", false, "", true);
        this.addDefinition("list_positions", "with this flag the positions of the lists added to the table", false, "", true);
        this.addDefinition("foreign_keys", "the syntax for 'predicate1' and 'predicate2' is like in '-id_index',\nwhere the predicate1 is the predicate which has a reference to predicate2.\nE.g. a(1,pos). and b(1,blabla). where the first argument in 'a' is a\nreference to 'b', could be written like this:\n   a:first=b:first", true, "<predicate1>=<predicate2>[, ...]", true);
        this.addDefinition("use_foreign_keys", "creates tables with foreign key relations, used for determining the\nrelations later on.", false, "", true);
        this.addDefinition("parser", "the type of parser to used (generic = Prolog). the 'csv' parser has the\nadditional parameters:\n  -no_identifiers\n  -separator <separator>\n  -qualifier <qualifier>", true, "generic | csv", true);
        this.addDefinition("no_identifiers", "CSV: if the file contains no identifiers", false, "", true);
        this.addDefinition("separator", "CSV: the separator for the fields, default is ','", true, "<separator>", true);
        this.addDefinition("qualifier", "CSV: the qualifier for strings, default is '\"'", true, "<qualifier", true);
        this.addNote("the following combinations of arguments for input files are allowed:\n 1. rel_database [, unclassified]\n 2. pos_neg [, unclassified]\n 3. background, positive, negative [, unclassified]\n 4. background, pos_neg [, unclassified]");
    }

    @Override
    public void checkCommandLine() {
        boolean combination;
        super.checkCommandLine();
        boolean bl = combination = this.cl.exists("rel_database") && !this.cl.exists("background") && !this.cl.exists("positive") && !this.cl.exists("negative") && !this.cl.exists("pos_neg") || this.cl.exists("pos_neg") && !this.cl.exists("positive") && !this.cl.exists("negative") || this.cl.exists("background") && this.cl.exists("positive") && this.cl.exists("negative") && !this.cl.exists("pos_neg") || this.cl.exists("background") && !this.cl.exists("positive") && !this.cl.exists("negative") && this.cl.exists("pos_neg");
        if (!combination) {
            System.out.println("Wrong combination of parameters!\n");
            this.printUsage();
            System.exit(2);
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Used for importing Prolog Databases (or derivates of it) and CSV files");
        System.out.println("into a relational database.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nImport\n======\n");
        Importer engine = new Importer();
        this.initEngine(engine);
        engine.setParameter("rel_database", this.cl.getValue("rel_database"));
        engine.setParameter("background", this.cl.getValue("background"));
        if (this.cl.exists("add_pos_class")) {
            engine.setParameter("add_pos_class", "yes");
        }
        if (this.cl.exists("add_neg_class")) {
            engine.setParameter("add_neg_class", "yes");
        }
        engine.setParameter("positive", this.cl.getValue("positive"));
        engine.setParameter("negative", this.cl.getValue("negative"));
        engine.setParameter("pos_neg", this.cl.getValue("pos_neg"));
        engine.setParameter("unclassified", this.cl.getValue("unclassified"));
        engine.setParameter("id_index", this.cl.getValue("id_index"));
        engine.setParameter("asymmetric", this.cl.getValue("asymmetric"));
        engine.setParameter("shuffle", this.cl.getValue("shuffle"));
        engine.setParameter("parser", this.cl.getValue("parser"));
        engine.setParameter("separator", this.cl.getValue("separator"));
        engine.setParameter("qualifier", this.cl.getValue("qualifier"));
        engine.setParameter("foreign_keys", this.cl.getValue("foreign_keys"));
        if (this.cl.exists("no_identifiers")) {
            engine.setParameter("no_identifiers", "yes");
        }
        if (this.cl.exists("reduce_lists")) {
            engine.setParameter("reduce_lists", "yes");
        }
        if (this.cl.exists("list_positions")) {
            engine.setParameter("list_positions", "yes");
        }
        if (this.cl.exists("use_foreign_keys")) {
            engine.setParameter("use_foreign_keys", "yes");
        }
        return engine.execute();
    }

    public static void main(String[] args) throws Exception {
        Import app = new Import();
        app.run(args);
    }
}

