/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.ExecutorObject;
import proper.database.Join;
import proper.util.ID;
import proper.util.ProperVector;
import proper.util.Set;
import proper.util.Strings;

public class Joiner
extends ExecutorObject {
    public static final int NATURAL_JOIN = 0;
    public static final int LEFTOUTER_JOIN = 1;
    public static final int RIGHTOUTER_JOIN = 2;
    public static final int BESTOUTER_JOIN = 3;
    public static final String JOIN_PREFIX = "m";
    private ColumnLister col;
    private int joinType;
    private String insteadOfNull;
    private boolean useForeignKeys;
    private ID id;
    private int currentID;
    private boolean requestNewID;

    public Joiner(Connector conn) {
        super(conn);
        this.col = new ColumnLister(conn);
        this.joinType = 0;
        this.insteadOfNull = "";
        this.id = new ID();
        this.currentID = 0;
        this.requestNewID = true;
        this.useForeignKeys = false;
    }

    private int getCurrentID() {
        if (this.requestNewID) {
            this.requestNewID = false;
            this.currentID = this.id.next();
        }
        return this.currentID;
    }

    public static String typeToString(int joinType) {
        String result = "";
        switch (joinType) {
            case 0: {
                result = "natural join";
                break;
            }
            case 1: {
                result = "left outer join";
                break;
            }
            case 2: {
                result = "right outer join";
                break;
            }
            case 3: {
                result = "best outer join";
                break;
            }
            default: {
                result = "unknown Join type!";
            }
        }
        return result;
    }

    public static int parseType(String type) {
        int result = (type = type.toLowerCase()).equals("natural join") || type.equals("natural") ? 0 : (type.equals("left outer join") || type.equals("leftouter") ? 1 : (type.equals("right outer join") || type.equals("rightouter") ? 2 : 3));
        return result;
    }

    public void setJoinType(int joinType) {
        if (joinType >= 0 && joinType <= 3) {
            this.joinType = joinType;
        }
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setInsteadOfNull(String insteadOfNull) {
        this.insteadOfNull = insteadOfNull;
    }

    public String getInsteadOfNull() {
        return this.insteadOfNull;
    }

    public void setUseForeignKeys(boolean useForeignKeys) {
        this.useForeignKeys = useForeignKeys;
    }

    public boolean getUseForeignKeys() {
        return this.useForeignKeys;
    }

    public HashSet ambigiousColumns(String table1, String table2, Vector joinColumns) {
        if (this.getVerbose()) {
            this.println("Determining ambigious tables...");
        }
        HashSet<String> result = new HashSet<String>();
        ProperVector tables = new ProperVector();
        tables.add(table1);
        tables.add(table2);
        this.col.clear();
        int[] count = new int[joinColumns.size()];
        int i = 0;
        while (i < tables.size()) {
            this.col.setTable((String)tables.get(i));
            this.col.setOnlyIndexes(false);
            Vector cols = this.col.getList();
            ProperVector tmpCols = new ProperVector();
            int n = 0;
            while (n < cols.size()) {
                tmpCols.add(((Column)cols.get(n)).getName());
                ++n;
            }
            n = 0;
            while (n < joinColumns.size()) {
                if (tmpCols.contains(joinColumns.get(n).toString())) {
                    int n2 = n;
                    count[n2] = count[n2] + 1;
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < count.length) {
            if (count[i] > 1) {
                result.add(joinColumns.get(i).toString());
            }
            ++i;
        }
        return result;
    }

    public String createJoin(String table1, String table2, Vector joinColumns, int type) {
        return this.createJoin(table1, "", table2, "", joinColumns, type);
    }

    public String createJoin(String table1, String prefix1, String table2, String prefix2, Vector joinColumns, int type) {
        this.col.clear();
        this.col.setTable(table1);
        this.col.setOnlyIndexes(false);
        this.col.setOnlySimpleTypes(true);
        this.col.setAddTable(true);
        Vector cols1 = this.col.getList();
        this.col.clear();
        this.col.setTable(table2);
        this.col.setOnlyIndexes(false);
        this.col.setOnlySimpleTypes(true);
        this.col.setAddTable(true);
        Vector cols2 = this.col.getList();
        return this.createJoin(table1, prefix1, cols1, table2, prefix2, cols2, joinColumns, type);
    }

    public String createJoin(String table1, String prefix1, Vector cols1, String table2, String prefix2, Vector cols2, Vector joinColumns, int type) {
        StringBuffer sql = new StringBuffer();
        boolean explicitPrefixes = true;
        if (prefix1.equals("") || prefix2.equals("")) {
            prefix1 = "";
            prefix2 = "";
            explicitPrefixes = false;
        }
        if (joinColumns.size() > 0) {
            Join relation;
            int i;
            HashSet ambig;
            Vector fields = (Vector)cols1.clone();
            fields = Set.join(fields, (Vector)cols2.clone());
            if (explicitPrefixes) {
                ambig = new HashSet();
            } else {
                ProperVector tmpCols = new ProperVector();
                i = 0;
                while (i < cols1.size()) {
                    tmpCols.add(((Column)cols1.get(i)).getName());
                    ++i;
                }
                Vector colNames = (Vector)tmpCols.clone();
                tmpCols = new ProperVector();
                i = 0;
                while (i < cols2.size()) {
                    tmpCols.add(((Column)cols2.get(i)).getName());
                    ++i;
                }
                colNames = Set.join(colNames, tmpCols);
                ambig = type == 1 ? this.ambigiousColumns(table1, table2, colNames) : this.ambigiousColumns(table2, table1, colNames);
            }
            if (this.getVerbose()) {
                this.println("ambigiuos columns for '" + table1 + "' and '" + table2 + "' via " + Joiner.typeToString(type) + ":\n" + ambig);
            }
            sql.append("SELECT ");
            boolean firstColumn = true;
            i = 0;
            while (i < fields.size()) {
                Column field = (Column)fields.get(i);
                int joinColumn = 0;
                int n = 0;
                while (n < joinColumns.size()) {
                    relation = (Join)joinColumns.get(n);
                    if (relation.getLeftObject().equals(field) || relation.getRightObject().equals(field)) {
                        if (cols1.contains(field)) {
                            joinColumn = 1;
                            break;
                        }
                        joinColumn = 2;
                        break;
                    }
                    ++n;
                }
                if (joinColumn != 2) {
                    if (!firstColumn) {
                        sql.append(", ");
                    }
                    if (explicitPrefixes) {
                        if (cols1.contains(field)) {
                            sql.append(String.valueOf(table1) + "." + field.getName());
                            sql.append(" AS " + prefix1 + field.getName());
                        } else {
                            sql.append(String.valueOf(table2) + "." + field.getName());
                            sql.append(" AS " + prefix2 + field.getName());
                        }
                    } else {
                        boolean ambigious = ambig.contains(field.getName());
                        if (cols2.contains(field)) {
                            sql.append(String.valueOf(table2) + "." + field.getName());
                            if (ambigious) {
                                sql.append(" AS m" + this.getCurrentID() + "_" + field.getName());
                            } else {
                                sql.append(" AS " + field.getName());
                            }
                        } else {
                            sql.append(String.valueOf(table1) + "." + field.getName());
                            sql.append(" AS " + field.getName());
                        }
                    }
                    firstColumn = false;
                }
                ++i;
            }
            sql.append(" FROM " + table1);
            if (type == 1) {
                sql.append(" LEFT OUTER JOIN ");
            } else if (type == 2) {
                sql.append(" RIGHT OUTER JOIN ");
            } else {
                sql.append(", ");
            }
            sql.append(table2);
            if (type == 1 || type == 2) {
                sql.append(" ON ");
            } else {
                sql.append(" WHERE ");
            }
            i = 0;
            while (i < joinColumns.size()) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                relation = (Join)joinColumns.get(i);
                sql.append(relation.toStringJoin());
                ++i;
            }
        }
        return sql.toString();
    }

    public String getTableCreateFromSelect(String table, String sql) throws Exception {
        ResultSet rs = this.exec.select(String.valueOf(sql) + " " + this.getConnector().getLimit(1));
        if (rs == null) {
            throw new Exception("Error executing:\n" + sql + "\n" + this.exec.getLastException());
        }
        ResultSetMetaData meta = rs.getMetaData();
        String result = "CREATE TABLE " + table + " (";
        int i = 1;
        while (i <= meta.getColumnCount()) {
            int typeSize = meta.getColumnDisplaySize(i) > 0 ? meta.getColumnDisplaySize(i) : 25;
            Column col = new Column(meta.getColumnName(i), meta.getColumnType(i), meta.getColumnTypeName(i), typeSize);
            if (i > 1) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + col.getName() + " " + col.typeToString();
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public boolean join(String table1, String table2, String resultTable) {
        return this.join(table1, table2, this.determineColumns(table1, false, table2, false), resultTable);
    }

    public boolean join(String table1, String table2, Vector joinColumns, String resultTable) {
        return this.join(table1, table2, joinColumns, resultTable, "");
    }

    public boolean join(String table1, String prefix1, String table2, String prefix2, Vector joinColumns, String resultTable) {
        return this.join(table1, prefix1, table2, prefix2, joinColumns, resultTable, "");
    }

    public boolean join(String table1, String table2, Vector joinColumns, String resultTable, String classField) {
        return this.join(table1, "", table2, "", joinColumns, resultTable, classField);
    }

    public boolean join(String table1, String prefix1, String table2, String prefix2, Vector joinColumns, String resultTable, String classField) {
        this.col.clear();
        this.col.setTable(table1);
        this.col.setOnlyIndexes(false);
        this.col.setAddTable(true);
        Vector cols1 = this.col.getList();
        this.col.clear();
        this.col.setTable(table2);
        this.col.setOnlyIndexes(false);
        this.col.setAddTable(true);
        Vector cols2 = this.col.getList();
        return this.join(table1, prefix1, cols1, table2, prefix2, cols2, joinColumns, resultTable, classField);
    }

    public boolean join(String table1, String prefix1, Vector cols1, String table2, String prefix2, Vector cols2, Vector joinColumns, String resultTable, String classField) {
        int type;
        boolean result = false;
        if (prefix1.equals("") || prefix2.equals("")) {
            prefix1 = "";
            prefix2 = "";
        }
        if ((type = this.getJoinType()) == 3) {
            type = this.determineBestJoin(table1, table2, joinColumns, classField);
        }
        if (this.getVerbose()) {
            this.println("Join is done over " + joinColumns);
        }
        if (joinColumns.size() > 0) {
            try {
                String sql = this.getTableCreateFromSelect(resultTable, this.createJoin(table1, prefix1, cols1, table2, prefix2, cols2, joinColumns, type));
                result = this.exec.update(sql);
                if (result) {
                    sql = "INSERT INTO " + resultTable + " " + this.createJoin(table1, prefix1, cols1, table2, prefix2, cols2, joinColumns, type);
                    result = this.exec.update(sql);
                }
                if (this.getVerbose()) {
                    this.println("Join: " + sql + " = " + result);
                }
                if (!result) {
                    this.println("Error executing:\n" + sql + "\n" + this.exec.getLastException());
                }
                if (result) {
                    this.col.clear();
                    this.col.setTable(table1);
                    this.col.setOnlyIndexes(true);
                    Vector columns = this.col.getList();
                    ProperVector joinCols = new ProperVector();
                    int i = 0;
                    while (i < joinColumns.size()) {
                        joinCols.add(new Column(((Join)joinColumns.get(i)).getLeftColumn()));
                        ++i;
                    }
                    i = 0;
                    while (i < columns.size()) {
                        sql = "CREATE INDEX " + resultTable + "_";
                        if (!prefix1.equals("")) {
                            sql = type == 2 ? String.valueOf(sql) + prefix2 : String.valueOf(sql) + prefix1;
                        }
                        sql = String.valueOf(sql) + columns.get(i) + " ON " + resultTable + " (";
                        if (!prefix1.equals("")) {
                            sql = type == 2 ? String.valueOf(sql) + prefix2 : String.valueOf(sql) + prefix1;
                        }
                        sql = String.valueOf(sql) + columns.get(i) + ")";
                        result = this.exec.update(sql);
                        if (this.getVerbose()) {
                            this.println("Index: " + sql + " = " + result);
                        }
                        if (!result) {
                            this.println(this.exec.getLastException() + "\n" + this.exec.getLastStatement());
                        }
                        if (!result) break;
                        ++i;
                    }
                }
                this.requestNewID = true;
            }
            catch (Exception e) {
                this.println(e);
                result = false;
            }
        }
        if (result && (type == 1 || type == 2) && !this.getInsteadOfNull().equals("")) {
            result = this.replaceNulls(type, table1, table2, resultTable);
        }
        if (this.getVerbose()) {
            this.println("Join Result: " + result + "\n");
        }
        return result;
    }

    private boolean replaceNulls(int joinType, String table1, String table2, String resultTable) {
        boolean result = true;
        if (joinType != 1 && joinType != 2) {
            this.println("The join joinType '" + joinType + "' is not supported for replacing NULLs, only LEFT and RIGHT OUTER JOIN!");
            return false;
        }
        Hashtable<String, String> values = new Hashtable<String, String>();
        String[] tmpList = Strings.fromCommalist(this.getInsteadOfNull());
        int i = 0;
        while (i < tmpList.length) {
            if (Strings.breakUp(tmpList[i], "=").length == 2) {
                values.put(Strings.breakUp(tmpList[i], "=")[0], Strings.breakUp(tmpList[i], "=")[1]);
            }
            ++i;
        }
        this.col.clear();
        if (joinType == 1) {
            this.col.setTable(table2);
        } else {
            this.col.setTable(table1);
        }
        Vector nullCols = this.col.getList();
        i = 0;
        while (i < nullCols.size()) {
            Column column = (Column)nullCols.get(i);
            if (values.containsKey(column.getName())) {
                if (this.getVerbose()) {
                    this.println("Replacing NULLs for '" + resultTable + "." + column + "' with '" + values.get(column.getName()) + "'");
                }
                String val = column.isNominal() ? "'" + values.get(column.getName()) + "'" : (String)values.get(column.getName());
                String sql = "UPDATE " + resultTable + " SET " + column + " = " + val + " WHERE " + column + " IS NULL";
                result = this.exec.update(sql);
                if (!result) {
                    this.println("Error executing: " + this.exec.getLastStatement());
                }
            }
            ++i;
        }
        return result;
    }

    public int determineBestJoin(String table1, String table2, Vector joinColumns) {
        return this.determineBestJoin(table1, table2, joinColumns, "");
    }

    public int getClassCount(String table1, String table2, Vector joinColumns, String classField, int joinType) {
        int result = 0;
        String sql = "";
        try {
            if (classField.equals("")) {
                result = 0;
            } else {
                this.col.clear();
                this.col.setTable(table1);
                boolean classContained1 = this.col.getList().contains(new Column(classField));
                this.col.setTable(table2);
                boolean classContained2 = this.col.getList().contains(new Column(classField));
                if (classContained1 || classContained2) {
                    sql = this.createJoin(table1, table2, joinColumns, joinType);
                    sql = classContained1 && classContained2 ? sql.replaceAll("SELECT .* FROM ", "SELECT COUNT(DISTINCT " + table1 + "." + classField + ") FROM ") : sql.replaceAll("SELECT .* FROM ", "SELECT COUNT(DISTINCT " + classField + ") FROM ");
                    ResultSet rs = this.exec.select(sql);
                    rs.first();
                    result = rs.getInt(1);
                    rs.close();
                } else {
                    result = 0;
                }
            }
        }
        catch (Exception e) {
            this.println(e);
            this.println("caused by: " + sql);
            result = 0;
        }
        if (this.getVerboseLevel() >= 2) {
            this.println(String.valueOf(sql) + " = " + result);
        }
        return result;
    }

    public int getRowsWithClassCount(String table1, String table2, Vector joinColumns, String classField, int joinType) {
        int result = 0;
        String sql = "";
        try {
            if (classField.equals("")) {
                result = 0;
            } else {
                this.col.clear();
                this.col.setTable(table1);
                boolean classContained1 = this.col.getList().contains(classField);
                this.col.setTable(table2);
                boolean classContained2 = this.col.getList().contains(classField);
                if (classContained1 || classContained2) {
                    sql = String.valueOf(this.createJoin(table1, table2, joinColumns, joinType)) + " WHERE ";
                    if (classContained1 && classContained2) {
                        sql = String.valueOf(sql) + table1 + ".";
                    }
                    sql = String.valueOf(sql) + classField + " IS NOT NULL";
                } else {
                    sql = this.createJoin(table1, table2, joinColumns, joinType);
                }
                sql = sql.replaceAll("SELECT .* FROM ", "SELECT COUNT(*) FROM ");
                ResultSet rs = this.exec.select(sql);
                rs.first();
                result = rs.getInt(1);
                rs.close();
            }
        }
        catch (Exception e) {
            this.println(e);
            this.println("caused by: " + sql);
            result = 0;
        }
        if (this.getVerboseLevel() >= 2) {
            this.println(String.valueOf(sql) + " = " + result);
        }
        return result;
    }

    public int determineBestJoin(String table1, String table2, Vector joinColumns, String classField) {
        int classes2;
        int result = 0;
        int count1 = this.exec.getDistinctCount(table1, joinColumns);
        int count2 = this.exec.getDistinctCount(table2, joinColumns);
        int classCount1 = this.getRowsWithClassCount(table1, table2, joinColumns, classField, 1);
        int classCount2 = this.getRowsWithClassCount(table1, table2, joinColumns, classField, 2);
        int classes1 = this.getClassCount(table1, table2, joinColumns, classField, 1);
        result = classes1 == (classes2 = this.getClassCount(table1, table2, joinColumns, classField, 2)) ? (classCount1 == classCount2 ? (count1 < count2 ? 2 : (count1 == count2 ? 0 : 1)) : (classCount1 < classCount2 ? 2 : 1)) : (classes1 < classes2 ? 2 : 1);
        if (this.getVerbose()) {
            this.println("Best join for '" + table1 + "' (classrows=" + classCount1 + "/row=" + count1 + "/classes=" + classes1 + ") " + "and '" + table2 + "' (classrows=" + classCount2 + "/row=" + count2 + "/classes=" + classes2 + ") " + "over class '" + classField + "'" + ": " + Joiner.typeToString(result) + " (" + result + ")");
        }
        return result;
    }

    public Vector determineColumns(String table1, String table2) {
        return this.determineColumns(table1, false, table2, false);
    }

    public Vector determineColumns(String table1, boolean onlyIndexes1, String table2, boolean onlyIndexes2) {
        ProperVector result = new ProperVector();
        this.col.setTable(table1);
        if (this.getUseForeignKeys()) {
            this.col.setOnlyExportedKeys(true);
        } else {
            this.col.setOnlyIndexes(onlyIndexes1);
        }
        Vector col1 = this.col.getList();
        this.col.setTable(table2);
        if (this.getUseForeignKeys()) {
            this.col.setOnlyImportedKeys(true);
        } else {
            this.col.setOnlyIndexes(onlyIndexes2);
        }
        Vector col2 = this.col.getList();
        Vector common = Set.intersect(col1, col2);
        int i = 0;
        while (i < common.size()) {
            try {
                if (this.getUseForeignKeys()) {
                    result.add(new Join(table1, common.get(i).toString(), table2, this.col.getColumnNamesForImportedKey(common.get(i).toString()).get(0).toString()));
                } else {
                    result.add(new Join(table1, common.get(i).toString(), table2, common.get(i).toString()));
                }
            }
            catch (Exception e) {
                this.println("Error with table1=" + table1 + ", table2=" + table2 + " and column=" + common.get(i).toString() + ":");
                this.println(e);
            }
            ++i;
        }
        if (this.getVerbose()) {
            this.println("Common columns for '" + table1 + "' and '" + table2 + "': " + result);
        }
        return result;
    }
}

