/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.ExecutorObject;
import proper.database.Sparser;
import proper.util.Excluder;
import proper.util.ProperVector;
import proper.util.Strings;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class Reader
extends ExecutorObject {
    public static final boolean INCLUDE_DATE = true;
    public static final boolean USE_DUMMY = true;
    public static final String NOMINAL_DUMMY = "_only_nulls";
    private String table;
    private String field;
    private Instances instances;
    private boolean sort;
    private Excluder excluder;
    private boolean classified;
    private Vector fieldList;
    private String orderBy;
    private String relation;
    private Vector nominals;
    private Vector noNulls;
    private double percentage;
    private Sparser sparser;
    private Iterator sparseIterator;
    private ResultSet rsInstances;
    private int toRetrieve;
    private Object currentKey;
    private FastVector atts;
    private boolean ignoreEmptyNominal;

    public Reader(Connector conn) {
        this(conn, "", "");
    }

    public Reader(Connector conn, String table, String field) {
        super(conn);
        this.table = table;
        this.field = field;
        this.sparser = new Sparser(conn);
        this.sort = false;
        this.classified = true;
        this.excluder = new Excluder("");
        this.fieldList = new ProperVector();
        this.orderBy = "";
        this.relation = "";
        this.nominals = new ProperVector();
        this.noNulls = new ProperVector();
        this.atts = null;
        this.percentage = 0.0;
        this.currentKey = null;
        this.toRetrieve = 0;
        this.ignoreEmptyNominal = false;
    }

    public void setRelationName(String relation) {
        this.relation = relation;
    }

    public String getRelationName() {
        return this.relation;
    }

    public void setTable(String table) {
        this.table = table;
        this.instances = null;
    }

    public String getTable() {
        return this.table;
    }

    public void setField(String field) {
        this.field = field;
        this.instances = null;
    }

    public String getField() {
        return this.field;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        this.instances = null;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
        this.instances = null;
    }

    public boolean getSort() {
        return this.sort;
    }

    public void setClassified(boolean classified) {
        this.classified = classified;
    }

    public boolean getClassified() {
        return this.classified;
    }

    public void setFieldList(String fields) {
        this.fieldList = Strings.fromCommalistVector(fields);
    }

    public String getFieldList() {
        return Strings.toCommalistVector(this.fieldList);
    }

    public void setNominalList(String fields) {
        this.nominals = Strings.fromCommalistVector(fields);
    }

    public String getNominalList() {
        return Strings.toCommalistVector(this.nominals);
    }

    public void setNoNullsList(String fields) {
        this.noNulls = Strings.fromCommalistVector(fields);
    }

    public String getNoNullsList() {
        return Strings.toCommalistVector(this.noNulls);
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setIgnoreEmptyNominal(boolean ignoreEmptyNominal) {
        this.ignoreEmptyNominal = ignoreEmptyNominal;
    }

    public boolean getIgnoreEmptyNominal() {
        return this.ignoreEmptyNominal;
    }

    private boolean useSparser() {
        return this.getPercentage() > 0.0 && this.getPercentage() < 100.0;
    }

    public Instances getInstances() {
        if (this.instances == null) {
            this.read();
        }
        return this.instances;
    }

    public void setExcludes(Vector excludes) {
        this.excluder = new Excluder(excludes);
    }

    public void setExcludes(String excludes) {
        this.excluder = new Excluder(excludes);
    }

    private int count() {
        int result = !this.useSparser() ? this.exec.getRecordCount(this.getTable(), this.getField(), this.getClassified()) : this.sparser.size();
        return result;
    }

    private boolean retrieveField(String field) {
        boolean result;
        boolean bl = result = !this.excluder.contains(field);
        if (this.fieldList.size() > 0) {
            result = this.fieldList.contains(field);
        }
        boolean bl2 = result = result || field.equals(this.getField());
        if (this.getVerbose()) {
            this.println("Retrieve Field: " + field + " = " + result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private Hashtable getNominalValues() {
        this.println("Retrieving ranges of nominal attributes...");
        result = new Hashtable<String, String>();
        try {
            col = new ColumnLister(this.conn);
            col.setTable(this.getTable());
            col.setOnlyNominal(true);
            fields = col.getList();
            fields.addAll(this.nominals);
            i = 0;
            while (i < fields.size()) {
                name = fields.get(i).toString();
                if (this.retrieveField(name)) {
                    result.put(name, name);
                }
                ++i;
            }
            enm = result.keys();
            while (enm.hasMoreElements()) {
                name = (String)enm.nextElement();
                sql = "SELECT DISTINCT(" + name + ") FROM " + this.getTable();
                sql = String.valueOf(sql) + " ORDER BY " + name;
                if (this.getVerbose()) {
                    this.println("Nominal Value: " + sql);
                }
                rs = this.exec.select(sql);
                atts = new FastVector();
                result.put(name, (String)atts);
                if (rs != null) ** GOTO lbl35
                this.println(this.exec.getLastException());
                throw new Exception("Error executing SQL Statement: " + sql);
lbl-1000:
                // 1 sources

                {
                    value = rs.getString(1);
                    if (rs.wasNull()) continue;
                    atts.addElement((Object)value);
lbl35:
                    // 3 sources

                    ** while (rs.next())
                }
lbl36:
                // 1 sources

                if (atts.size() == 0 && !this.getIgnoreEmptyNominal()) {
                    atts.addElement((Object)"_only_nulls");
                    if (this.getVerbose()) {
                        this.print(" after adding dummy");
                    }
                }
                if (this.getVerbose()) {
                    this.println(" = " + atts.size());
                }
                rs.close();
            }
        }
        catch (Exception e) {
            this.println(e);
        }
        this.println(" " + result.size() + " found.");
        return result;
    }

    private FastVector getAttributes() {
        Hashtable values = this.getNominalValues();
        FastVector result = new FastVector();
        Attribute cls = null;
        this.println("Retrieving attributes...");
        try {
            String sql = "SELECT ";
            sql = this.fieldList.size() == 0 ? String.valueOf(sql) + "*" : String.valueOf(sql) + new ProperVector((Collection)this.fieldList).toCommaList();
            sql = String.valueOf(sql) + " FROM " + this.getTable();
            if (!this.getOrderBy().equals("")) {
                sql = String.valueOf(sql) + " ORDER BY " + this.getOrderBy();
            }
            sql = String.valueOf(sql) + " " + this.conn.getLimit(1);
            if (this.getVerbose()) {
                this.println("Attributes: " + sql);
            }
            ResultSet rs = this.exec.select(sql);
            ResultSetMetaData meta = rs.getMetaData();
            ProperVector names = new ProperVector();
            int i = 1;
            while (i <= meta.getColumnCount()) {
                boolean retrieve = this.retrieveField(meta.getColumnName(i));
                if (retrieve) {
                    FastVector v = (FastVector)values.get(meta.getColumnName(i));
                    if (v != null) {
                        boolean bl = retrieve = v.size() > 0;
                    }
                    if (!retrieve) {
                        this.println(String.valueOf(meta.getColumnName(i)) + " ignored, since no values!");
                    }
                }
                if (retrieve) {
                    names.add(meta.getColumnName(i));
                }
                ++i;
            }
            if (this.fieldList.size() == 0 && this.getSort()) {
                Collections.sort(names);
            }
            int n = 0;
            while (n < names.size()) {
                Attribute att;
                Column column;
                i = 1;
                while (i <= meta.getColumnCount()) {
                    if (meta.getColumnName(i).equals(names.get(n))) break;
                    ++i;
                }
                int type = meta.getColumnType(i);
                if (this.nominals.contains(names.get(n))) {
                    type = 12;
                }
                if ((column = new Column(meta.getColumnName(i), type)).isInteger()) {
                    att = new Attribute(meta.getColumnName(i));
                } else if (column.isDecimal()) {
                    att = new Attribute(meta.getColumnName(i));
                } else if (column.isDate()) {
                    att = column.getType() == 93 ? new Attribute(meta.getColumnName(i), "yyyyMMddHHmmss") : new Attribute(meta.getColumnName(i), "yyyy-MM-dd");
                } else if (column.isNominal() || column.isBoolean()) {
                    att = new Attribute(meta.getColumnName(i), (FastVector)values.get(meta.getColumnName(i)));
                } else {
                    att = null;
                    this.println(String.valueOf(meta.getColumnName(i)) + " ignored, since " + meta.getColumnTypeName(i) + " not supported!");
                }
                if (n > 0 && n % 100 == 0) {
                    this.println(String.valueOf(n + 1) + "/" + names.size());
                }
                if (this.getVerbose()) {
                    this.println(names.get(n) + " (" + type + "): " + att);
                }
                if (meta.getColumnName(i).equals(this.getField())) {
                    cls = att;
                } else if (att != null) {
                    result.addElement((Object)att);
                }
                ++n;
            }
            this.println(String.valueOf(names.size()) + " Attributes overall");
            result.addElement(cls);
            rs.close();
        }
        catch (Exception e) {
            this.println(e);
        }
        this.println(String.valueOf(result.size()) + " Attributes found.");
        System.gc();
        return result;
    }

    private String buildInstanceStatement() {
        String sql = "SELECT ";
        int i = 0;
        while (i < this.atts.size()) {
            Attribute att = (Attribute)this.atts.elementAt(i);
            if (i > 0) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + att.name();
            ++i;
        }
        sql = String.valueOf(sql) + " FROM " + this.getTable();
        sql = this.getClassified() ? String.valueOf(sql) + " WHERE " + this.getField() + " IS NOT NULL" : String.valueOf(sql) + " WHERE " + this.getField() + " IS NULL";
        if (this.noNulls.size() > 0) {
            sql = sql.indexOf(" WHERE ") == -1 ? String.valueOf(sql) + " WHERE " : String.valueOf(sql) + " AND ";
            i = 0;
            while (i < this.noNulls.size()) {
                if (i > 0) {
                    sql = String.valueOf(sql) + " AND ";
                }
                sql = String.valueOf(sql) + this.noNulls.get(i).toString() + " IS NOT NULL";
                ++i;
            }
        }
        if (!this.getOrderBy().equals("")) {
            sql = String.valueOf(sql) + " ORDER BY " + this.getOrderBy();
        }
        return sql;
    }

    private String addToStatement(String sql, Object id) {
        Column col = new Column(this.sparser.getIndex(), this.sparser.getIndexType());
        String tmp = String.valueOf(this.sparser.getIndex()) + " = ";
        tmp = col.isNominal() || col.isBoolean() ? String.valueOf(tmp) + "'" + id.toString() + "'" : String.valueOf(tmp) + id.toString();
        sql = sql.indexOf(" WHERE ") > -1 ? sql.replaceAll(" WHERE ", " WHERE " + tmp + " AND ") : String.valueOf(sql) + " WHERE " + tmp;
        return sql;
    }

    /*
     * Exception decompiling
     */
    private ResultSet nextInstance() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void read() {
        if (this.getVerbose()) {
            this.printMemory();
        }
        if (this.useSparser()) {
            this.sparser.setTable(this.getTable());
            this.sparser.setClassField(this.getField());
            this.sparser.setOnlyClassified(this.getClassified());
            this.sparser.setPercentage(this.getPercentage());
        }
        int cnt = this.count();
        this.atts = this.getAttributes();
        this.instances = new Instances(this.getTable(), this.atts, cnt);
        if (this.getRelationName().equals("")) {
            this.instances.setRelationName(String.valueOf(this.conn.getDatabase()) + "-" + this.getTable());
        } else {
            this.instances.setRelationName(this.getRelationName());
        }
        this.instances.setRelationName(String.valueOf(this.getRelationName()) + "-" + "Proper_0.2.1");
        boolean first = true;
        int counter = 0;
        this.println("Retrieving instances...");
        if (this.getVerbose()) {
            this.printMemory();
        }
        this.rsInstances = null;
        this.sparseIterator = null;
        try {
            ResultSet rs;
            while ((rs = this.nextInstance()) != null && rs.getRow() != 0) {
                double[] values = new double[this.atts.size()];
                int i = 0;
                while (i < this.atts.size()) {
                    Attribute att = (Attribute)this.atts.elementAt(i);
                    if (first && att.name().equals(this.getField())) {
                        this.instances.setClassIndex(i);
                        first = false;
                    }
                    switch (att.type()) {
                        case 0: {
                            values[i] = rs.getDouble(i + 1);
                            break;
                        }
                        case 1: 
                        case 2: {
                            String value = rs.getString(i + 1);
                            if (rs.wasNull()) {
                                value = "?";
                            }
                            values[i] = att.indexOfValue(value);
                            if (values[i] != -1.0) break;
                            values[i] = Instance.missingValue();
                            break;
                        }
                        case 3: {
                            String value;
                            try {
                                value = rs.getString(i + 1);
                                if (rs.wasNull()) {
                                    values[i] = Instance.missingValue();
                                    break;
                                }
                                values[i] = att.parseDate(value);
                                break;
                            }
                            catch (Exception e) {
                                values[i] = Instance.missingValue();
                            }
                        }
                    }
                    if (rs.wasNull()) {
                        values[i] = Instance.missingValue();
                    }
                    ++i;
                }
                this.instances.add(new Instance(1.0, values));
                if (++counter <= 0 || counter % 1000 != 0) continue;
                this.println(String.valueOf(counter) + " Records");
                if (!this.getVerbose()) continue;
                this.printMemory();
            }
            this.println(String.valueOf(counter) + " Records overall.");
        }
        catch (Exception e) {
            this.println(e);
        }
    }
}

