/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import proper.core.ProperObject;

public abstract class Engine
extends ProperObject {
    private Hashtable params = new Hashtable();
    protected boolean initialized = false;

    public void clear() {
        this.params.clear();
        this.initialized = false;
    }

    protected boolean initialize() {
        this.initialized = true;
        return true;
    }

    public void setParameters(Engine engine) {
        this.clear();
        Enumeration params = engine.getParameters();
        while (params.hasMoreElements()) {
            String param = params.nextElement().toString();
            this.setParameter(param, engine.getParameter(param));
        }
        this.initialize();
    }

    public Enumeration getParameters() {
        return this.params.keys();
    }

    public boolean exists(String name) {
        return this.params.containsKey(name);
    }

    public void setParameter(String name, Object arg) {
        this.params.put(name, arg);
    }

    public void copyParameter(String name, Engine engine) {
        this.setParameter(name, engine.getParameter(name));
    }

    public Object getParameter(String name) {
        if (this.exists(name)) {
            return this.params.get(name);
        }
        return null;
    }

    public String getStringParameter(String name) {
        Object o = this.getParameter(name);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public boolean valueEquals(String name, Object value) {
        boolean result = this.exists(name);
        if (result) {
            result = this.getParameter(name).equals(value);
        }
        return result;
    }

    public boolean execute() {
        if (this.getVerbose()) {
            this.println("\n" + this + "\n");
        }
        if (this.initialized) {
            return true;
        }
        return this.initialize();
    }

    @Override
    public String toString() {
        String result = "";
        Object[] keys = new String[this.params.size()];
        int i = 0;
        Enumeration enm = this.params.keys();
        while (enm.hasMoreElements()) {
            keys[i] = (String)enm.nextElement();
            ++i;
        }
        Arrays.sort(keys);
        i = 0;
        while (i < keys.length) {
            result = String.valueOf(result) + (String)keys[i] + ": " + this.params.get(keys[i]).toString() + "\n";
            ++i;
        }
        return result;
    }
}

