/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.io.File;
import proper.database.Reader;
import proper.database.Writer;
import proper.engine.DatabaseEngine;
import proper.relaggs.RelaggsConfig;
import proper.util.Includer;
import proper.util.MilkHelper;
import proper.util.WekaHelper;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.Filter;

public class Instancer
extends DatabaseEngine {
    private Instances instances = null;
    private Includer includer = new Includer("");

    public Instancer() {
        this.setParameter("database", "relaggs");
        this.setParameter("table", "relaggs");
        this.setParameter("field", "status");
        this.setParameter("field_list", "");
        this.setParameter("nominal_list", "");
        this.setParameter("instances", "");
        this.setParameter("exclude_fields", "");
        this.setParameter("type", "classified");
        this.setParameter("order", "yes");
        this.setParameter("orderby", "");
        this.setParameter("no_nulls", "");
        this.setParameter("percentage", "0");
        this.setParameter("bag", "");
        this.setParameter("ignore_empty_nominal", "no");
    }

    private Instances applyFilter(Instances instances) throws Exception {
        Filter filter;
        String filterName = this.getStringParameter("filter");
        String filterOptions = this.getStringParameter("filter_additional");
        if (filterName.startsWith("weka.")) {
            filter = WekaHelper.getFilterInstance(filterName);
            WekaHelper.setOptions((Object)filter, filterOptions);
        } else {
            filter = MilkHelper.getFilterInstance(filterName);
            MilkHelper.setOptions((Object)filter, filterOptions);
        }
        filter.setInputFormat(instances);
        instances = Filter.useFilter((Instances)instances, (Filter)filter);
        return instances;
    }

    private void initProcessBinaryAttributes(Instances instances) {
        if (instances.classIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
        }
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNominal() && !instances.attribute(i).name().equals(this.getStringParameter("bag")) && i != instances.classIndex() && instances.attribute(i).numValues() > RelaggsConfig.max_aggr_values) {
                if (this.getVerbose()) {
                    this.println("deleting attribute '" + instances.attribute(i).name() + "'");
                }
                instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
        String tmp = "";
        i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNominal()) {
                if (!tmp.equals("")) {
                    tmp = String.valueOf(tmp) + ",";
                }
                tmp = String.valueOf(tmp) + instances.attribute(i).name() + "*";
            }
            ++i;
        }
        if (this.getVerbose()) {
            this.println("Nominal attributes: " + tmp);
        }
        this.includer = new Includer(tmp, true);
    }

    private Instances processBinaryAttributes(Instances instances) {
        int i = 0;
        while (i < instances.numAttributes()) {
            Attribute att = instances.attribute(i);
            if (att.isNumeric() && this.includer.contains(att.name())) {
                if (this.getVerbose()) {
                    this.println("replace missing in binarized Attribute '" + att.name() + "'");
                }
                if (this.getVerbose()) {
                    this.print(att.name());
                }
                int n = 0;
                while (n < instances.numInstances()) {
                    if (instances.instance(n).isMissing(i)) {
                        instances.instance(n).setValue(i, 0.0);
                    }
                    ++n;
                }
            }
            if (i == 0) {
                this.println("Processing binary attributes...");
            } else if (i % 100 == 0) {
                this.println(String.valueOf(i) + "/" + instances.numAttributes());
            }
            ++i;
        }
        return instances;
    }

    @Override
    public boolean execute() {
        super.execute();
        try {
            Reader reader = new Reader(this.conn, this.getStringParameter("table"), this.getStringParameter("field"));
            reader.setSort(this.valueEquals("order", "yes"));
            reader.setExcludes(this.getStringParameter("exclude_fields"));
            reader.setFieldList(this.getStringParameter("field_list"));
            reader.setNominalList(this.getStringParameter("nominal_list"));
            reader.setClassified(this.valueEquals("type", "classified"));
            reader.setOrderBy(this.getStringParameter("orderby"));
            reader.setNoNullsList(this.getStringParameter("no_nulls"));
            reader.setPercentage(Double.parseDouble(this.getStringParameter("percentage")));
            reader.setIgnoreEmptyNominal(this.valueEquals("ignore_empty_nominal", "yes"));
            String output = this.getStringParameter("output");
            if (output != null && !output.equals("")) {
                File file = new File(output);
                reader.setRelationName(file.getName().replaceAll("\\..*", ""));
            }
            if (!reader.getVerbose()) {
                reader.setVerbose(this.getVerbose());
            }
            this.instances = reader.getInstances();
            if (this.exists("missing_binary_to_zero")) {
                this.initProcessBinaryAttributes(this.instances);
            }
            if (this.exists("filter")) {
                this.instances = this.applyFilter(this.instances);
            }
            if (this.exists("missing_binary_to_zero")) {
                this.instances = this.processBinaryAttributes(this.instances);
            }
            if (output != null) {
                Writer writer = new Writer(this.conn, this.getStringParameter("table"), this.getStringParameter("field"));
                writer.setSort(this.valueEquals("order", "yes"));
                writer.setFilename(output);
                if (!writer.getVerbose()) {
                    writer.setVerbose(this.getVerbose());
                }
                writer.write(this.instances);
                this.println("Instances written to " + writer.getFilename());
            } else {
                this.setParameter("instances", this.instances);
            }
            return this.instances != null;
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
    }

    @Override
    public String toString() {
        if (this.instances == null) {
            return super.toString();
        }
        return this.instances.toString();
    }
}

