/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.frame.DummyFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.panel.OkCancelPanel;
import proper.util.ProperVector;

public class ListDialog
extends ProperDialog {
    private JList listItems;
    private JScrollPane paneItems;
    private OkCancelPanel panelOkCancel;

    public ListDialog() {
        this(new DummyFrame(), "Select");
    }

    public ListDialog(ProperFrame parent) {
        this(parent, "Select");
    }

    public ListDialog(String title) {
        this(new DummyFrame());
    }

    public ListDialog(ProperFrame parent, String title) {
        super(parent, title);
        this.initialize();
        this.createDialog();
        this.setMultiSelect(true);
    }

    @Override
    protected void createDialog() {
        super.createDialog();
        this.setSize(600, 300);
        this.setCenteredLocation();
        this.getContentPane().setLayout(new BorderLayout());
        this.listItems = new JList();
        this.listItems.setFont(Font.decode(this.getCustomFont()));
        this.listItems.addKeyListener(this);
        this.listItems.addMouseListener(this);
        this.paneItems = new JScrollPane(this.listItems);
        this.getContentPane().add((Component)this.paneItems, "Center");
        this.panelOkCancel = new OkCancelPanel(false);
        this.panelOkCancel.addActionListener(this);
        this.panelOkCancel.addKeyListener(this);
        this.getContentPane().add((Component)this.panelOkCancel, "East");
        this.getRootPane().setDefaultButton(this.panelOkCancel.buttonOK);
    }

    public void setItems(Object[] items) {
        this.listItems.setListData(items);
    }

    public void setItems(Vector items) {
        this.listItems.setListData(items);
    }

    public int getSelectedIndex() {
        return this.listItems.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.listItems.setSelectedIndex(index);
    }

    public int[] getSelectedIndices() {
        return this.listItems.getSelectedIndices();
    }

    public void setSelectedIndices(int[] indices) {
        this.listItems.setSelectedIndices(indices);
    }

    public Object getSelectedValue() {
        return this.listItems.getSelectedValue();
    }

    public void setSelectedValue(Object value) {
        this.listItems.setSelectedValue(value, true);
    }

    public Object[] getSelectedValues() {
        return this.listItems.getSelectedValues();
    }

    public Vector getSelectedItems() {
        ProperVector result = new ProperVector();
        Object[] items = this.getSelectedValues();
        int i = 0;
        while (i < items.length) {
            result.add(items[i]);
            ++i;
        }
        return result;
    }

    public void setMultiSelect(boolean value) {
        if (value) {
            this.listItems.setSelectionMode(2);
        } else {
            this.listItems.setSelectionMode(0);
        }
    }

    public boolean isMultiSelect() {
        return this.listItems.getSelectionMode() == 2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ok")) {
            this.approved = true;
            this.close();
        } else if (action.equals("cancel")) {
            this.close();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.listItems.getSelectedIndex() != -1 && e.getSource() == this.listItems && e.getButton() == 1 && e.getClickCount() == 2) {
            e.consume();
            this.approved = true;
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.close();
        }
    }
}

