/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.io.SimpleFileFilter;
import proper.io.TextFile;
import proper.util.ProperVector;
import proper.util.Strings;
import proper.xml.XSL;

public class XSLer
extends ChildFrame {
    private static final String ACTION_XML_LOAD = "xml_load";
    private static final String ACTION_XML_RELOAD = "xml_reload";
    private static final String ACTION_XML_SAVE = "xml_save";
    private static final String ACTION_XML_SAVEAS = "xml_save_as";
    private static final String ACTION_XSL_LOAD = "xsl_load";
    private static final String ACTION_XSL_RELOAD = "xsl_reload";
    private static final String ACTION_XSL_SAVE = "xsl_save";
    private static final String ACTION_XSL_SAVEAS = "xsl_save_as";
    private static final String ACTION_OUTPUT_GENERATE = "output_generate";
    private static final String ACTION_OUTPUT_SAVE = "output_save";
    private static final String ACTION_OUTPUT_SAVEAS = "output_save_as";
    private static final String ACTION_JAVA_GENERATE = "java_generate";
    private static final String TAB_XML = "XML";
    private static final String TAB_XSL = "XSL";
    private static final String TAB_OUTPUT = "Output";
    private static final String TAB_JAVA = "Java";
    private static final String COMBOBOX_XML = "XML";
    private static final String COMBOBOX_XSL = "XSL";
    private static final String COMBOBOX_OUTPUT = "Output";
    private JTabbedPane tabbedPane;
    private JPanel panelXML;
    private JPanel panelXSL;
    private JPanel panelOutput;
    private JPanel panelJava;
    private JScrollPane paneXML;
    private JScrollPane paneXSL;
    private JScrollPane paneOutput;
    private JScrollPane paneJava;
    private JTextArea areaXML;
    private JTextArea areaXSL;
    private JTextArea areaOutput;
    private JTextArea areaJava;
    private JLabel labelXMLFilename;
    private JLabel labelXSLFilename;
    private JLabel labelOutputFilename;
    private JLabel labelJavaVariable;
    private JTextField textXMLFilename;
    private JTextField textXSLFilename;
    private JTextField textOutputFilename;
    private JTextField textJavaVariable;
    private JButton buttonXMLLoad;
    private JButton buttonXMLReload;
    private JButton buttonXMLSave;
    private JButton buttonXMLSaveAs;
    private JButton buttonXSLLoad;
    private JButton buttonXSLReload;
    private JButton buttonXSLSave;
    private JButton buttonXSLSaveAs;
    private JButton buttonOutputGenerate;
    private JButton buttonOutputSave;
    private JButton buttonOutputSaveAs;
    private JButton buttonJavaGenerate;
    private JComboBox comboJava;
    private FileChooser fileChooser;
    private SimpleFileFilter filter;
    private boolean isXMLChanged;
    private boolean isXSLChanged;
    private boolean isOutputChanged;
    private boolean isJavaChanged;

    public XSLer(ApplicationFrame parent) {
        super(parent, "XSLer");
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.panelXML = new JPanel(new BorderLayout());
        this.panelXSL = new JPanel(new BorderLayout());
        this.panelOutput = new JPanel(new BorderLayout());
        this.panelJava = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("XML", ImageLoader.getImageIcon("xml.gif"), this.panelXML);
        this.tabbedPane.addTab("XSL", ImageLoader.getImageIcon("xsl.gif"), this.panelXSL);
        this.tabbedPane.addTab("Output", ImageLoader.getImageIcon("list.gif"), this.panelOutput);
        this.tabbedPane.addTab(TAB_JAVA, ImageLoader.getImageIcon("objects.gif"), this.panelJava);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.labelXMLFilename = new JLabel("Filename");
        this.textXMLFilename = new JTextField("", 20);
        this.textXMLFilename.setEnabled(false);
        this.buttonXMLLoad = new JButton("Load", ImageLoader.getImageIcon("open.gif"));
        this.buttonXMLLoad.setActionCommand(ACTION_XML_LOAD);
        this.buttonXMLLoad.addActionListener(this);
        this.buttonXMLReload = new JButton("Reload", ImageLoader.getImageIcon("undo.gif"));
        this.buttonXMLReload.setActionCommand(ACTION_XML_RELOAD);
        this.buttonXMLReload.addActionListener(this);
        this.buttonXMLSave = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonXMLSave.setActionCommand(ACTION_XML_SAVE);
        this.buttonXMLSave.addActionListener(this);
        this.buttonXMLSaveAs = new JButton("Save As...");
        this.buttonXMLSaveAs.setActionCommand(ACTION_XML_SAVEAS);
        this.buttonXMLSaveAs.addActionListener(this);
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.labelXMLFilename);
        panel.add(this.textXMLFilename);
        panel.add(this.buttonXMLLoad);
        panel.add(this.buttonXMLReload);
        panel.add(this.buttonXMLSave);
        panel.add(this.buttonXMLSaveAs);
        this.panelXML.add((Component)panel, "North");
        this.areaXML = new JTextArea();
        this.areaXML.setFont(Font.decode(this.getCustomFont()));
        this.areaXML.getDocument().addDocumentListener(this);
        this.paneXML = new JScrollPane(this.areaXML);
        this.panelXML.add((Component)this.paneXML, "Center");
        this.labelXSLFilename = new JLabel("Filename");
        this.textXSLFilename = new JTextField("", 20);
        this.textXSLFilename.setEnabled(false);
        this.buttonXSLLoad = new JButton("Load", ImageLoader.getImageIcon("open.gif"));
        this.buttonXSLLoad.setActionCommand(ACTION_XSL_LOAD);
        this.buttonXSLLoad.addActionListener(this);
        this.buttonXSLReload = new JButton("Reload", ImageLoader.getImageIcon("undo.gif"));
        this.buttonXSLReload.setActionCommand(ACTION_XSL_RELOAD);
        this.buttonXSLReload.addActionListener(this);
        this.buttonXSLSave = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonXSLSave.setActionCommand(ACTION_XSL_SAVE);
        this.buttonXSLSave.addActionListener(this);
        this.buttonXSLSaveAs = new JButton("Save As...");
        this.buttonXSLSaveAs.setActionCommand(ACTION_XSL_SAVEAS);
        this.buttonXSLSaveAs.addActionListener(this);
        panel = new JPanel(new FlowLayout());
        panel.add(this.labelXSLFilename);
        panel.add(this.textXSLFilename);
        panel.add(this.buttonXSLLoad);
        panel.add(this.buttonXSLReload);
        panel.add(this.buttonXSLSave);
        panel.add(this.buttonXSLSaveAs);
        this.panelXSL.add((Component)panel, "North");
        this.areaXSL = new JTextArea();
        this.areaXSL.setFont(Font.decode(this.font));
        this.areaXSL.getDocument().addDocumentListener(this);
        this.paneXSL = new JScrollPane(this.areaXSL);
        this.panelXSL.add((Component)this.paneXSL, "Center");
        this.labelOutputFilename = new JLabel("Filename");
        this.textOutputFilename = new JTextField("", 20);
        this.textOutputFilename.setEnabled(false);
        this.buttonOutputGenerate = new JButton("Generate", ImageLoader.getImageIcon("run.gif"));
        this.buttonOutputGenerate.setActionCommand(ACTION_OUTPUT_GENERATE);
        this.buttonOutputGenerate.addActionListener(this);
        this.buttonOutputSave = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonOutputSave.setActionCommand(ACTION_OUTPUT_SAVE);
        this.buttonOutputSave.addActionListener(this);
        this.buttonOutputSaveAs = new JButton("Save As...");
        this.buttonOutputSaveAs.setActionCommand(ACTION_OUTPUT_SAVEAS);
        this.buttonOutputSaveAs.addActionListener(this);
        panel = new JPanel(new FlowLayout());
        panel.add(this.labelOutputFilename);
        panel.add(this.textOutputFilename);
        panel.add(this.buttonOutputGenerate);
        panel.add(this.buttonOutputSave);
        panel.add(this.buttonOutputSaveAs);
        this.panelOutput.add((Component)panel, "North");
        this.areaOutput = new JTextArea();
        this.areaOutput.setFont(Font.decode(this.font));
        this.areaOutput.getDocument().addDocumentListener(this);
        this.paneOutput = new JScrollPane(this.areaOutput);
        this.panelOutput.add((Component)this.paneOutput, "Center");
        this.labelJavaVariable = new JLabel("Variable");
        this.textJavaVariable = new JTextField("", 20);
        this.buttonJavaGenerate = new JButton("Generate", ImageLoader.getImageIcon("run.gif"));
        this.buttonJavaGenerate.setActionCommand(ACTION_JAVA_GENERATE);
        this.buttonJavaGenerate.addActionListener(this);
        this.comboJava = new JComboBox<String>(new String[]{"XML", "XSL", "Output"});
        panel = new JPanel(new FlowLayout());
        panel.add(this.labelJavaVariable);
        panel.add(this.textJavaVariable);
        panel.add(this.comboJava);
        panel.add(this.buttonJavaGenerate);
        this.panelJava.add((Component)panel, "North");
        this.areaJava = new JTextArea();
        this.areaJava.setFont(Font.decode(this.font));
        this.areaJava.getDocument().addDocumentListener(this);
        this.paneJava = new JScrollPane(this.areaJava);
        this.panelJava.add((Component)this.paneJava, "Center");
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.isXMLChanged = false;
        this.isXSLChanged = false;
        this.isOutputChanged = false;
        this.isJavaChanged = false;
        this.setConfirm();
    }

    private void setTabTitle(int index, String title, boolean changed) {
        String titleNow = this.tabbedPane.getTitleAt(index);
        if (changed && titleNow.equals(title)) {
            this.tabbedPane.setTitleAt(index, String.valueOf(title) + " *");
        } else if (!changed && !titleNow.equals(title)) {
            this.tabbedPane.setTitleAt(index, title);
        }
    }

    private void setConfirm() {
        this.setConfirmExit(this.isXMLChanged || this.isXSLChanged || this.isOutputChanged || this.isJavaChanged);
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            String title = this.tabbedPane.getTitleAt(i);
            if (title.startsWith("XML")) {
                this.setTabTitle(i, "XML", this.isXMLChanged);
            } else if (title.startsWith("XSL")) {
                this.setTabTitle(i, "XSL", this.isXSLChanged);
            } else if (title.startsWith("Output")) {
                this.setTabTitle(i, "Output", this.isOutputChanged);
            } else if (title.startsWith(TAB_JAVA)) {
                this.setTabTitle(i, TAB_JAVA, this.isJavaChanged);
            }
            ++i;
        }
    }

    private void loadFile(JTextField filename, JTextArea area) {
        this.loadFile(filename, area, true);
    }

    private void loadFile(JTextField filename, JTextArea area, boolean showDialog) {
        if (showDialog) {
            int retVal;
            if (!filename.getText().equals("")) {
                try {
                    this.fileChooser.setSelectedFile(new File(filename.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((retVal = this.fileChooser.showOpenDialog(this)) != 0) {
                return;
            }
            filename.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        } else if (filename.getText().equals("")) {
            return;
        }
        area.setText("");
        Vector lines = TextFile.load(filename.getText());
        String tmp = "";
        int i = 0;
        while (i < lines.size()) {
            tmp = String.valueOf(tmp) + (String)lines.get(i) + "\n";
            ++i;
        }
        area.setText(tmp);
        area.setSelectionStart(0);
        area.setSelectionEnd(0);
        this.refresh();
        if (area == this.areaXML) {
            this.isXMLChanged = false;
        } else if (area == this.areaXSL) {
            this.isXSLChanged = false;
        } else if (area == this.areaOutput) {
            this.isOutputChanged = false;
        } else if (area == this.areaJava) {
            this.isJavaChanged = false;
        }
        this.setConfirm();
    }

    private void saveFile(JTextArea area, JTextField filename) {
        this.saveFile(area, filename, true);
    }

    private void saveFile(JTextArea area, JTextField filename, boolean showDialog) {
        if (showDialog) {
            int retVal;
            if (!filename.equals("")) {
                try {
                    this.fileChooser.setSelectedFile(new File(filename.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((retVal = this.fileChooser.showSaveDialog(this)) != 0) {
                return;
            }
            filename.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        } else if (filename.getText().equals("")) {
            return;
        }
        ProperVector lines = new ProperVector();
        lines.add(String.valueOf(area.getText()) + "\n");
        TextFile.save(filename.getText(), lines);
        if (area == this.areaXML) {
            this.isXMLChanged = false;
        } else if (area == this.areaXSL) {
            this.isXSLChanged = false;
        } else if (area == this.areaOutput) {
            this.isOutputChanged = false;
        } else if (area == this.areaJava) {
            this.isJavaChanged = false;
        }
        this.setConfirm();
    }

    private void generateOutput() {
        if (this.areaXML.getText().equals("") || this.areaXSL.getText().equals("")) {
            return;
        }
        try {
            StringReader xml = new StringReader(this.areaXML.getText());
            StringReader xsl = new StringReader(this.areaXSL.getText());
            this.areaOutput.setText(XSL.transform(xml, xsl));
            this.areaOutput.setSelectionStart(0);
            this.areaOutput.setSelectionEnd(0);
        }
        catch (Exception e) {
            this.println(e);
        }
    }

    private void generateJava() {
        JTextArea area;
        if (this.comboJava.getSelectedItem().toString().equals("XML")) {
            area = this.areaXML;
        } else if (this.comboJava.getSelectedItem().toString().equals("XSL")) {
            area = this.areaXSL;
        } else if (this.comboJava.getSelectedItem().toString().equals("Output")) {
            area = this.areaOutput;
        } else {
            return;
        }
        String[] lines = Strings.breakUp(area.getText(), "\n");
        String tmp = "";
        int i = 0;
        while (i < lines.length) {
            tmp = i == 0 ? String.valueOf(tmp) + this.textJavaVariable.getText() + " = \"" : String.valueOf(tmp) + " + \"";
            tmp = String.valueOf(tmp) + Strings.escape(lines[i]) + "\"";
            if (i == lines.length - 1) {
                tmp = String.valueOf(tmp) + ";";
            }
            tmp = String.valueOf(tmp) + "\n";
            ++i;
        }
        this.areaJava.setText(tmp);
        this.areaJava.setSelectionStart(0);
        this.areaJava.setSelectionEnd(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_XML_LOAD)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("XML Files");
            this.filter.addExtension("xml");
            this.fileChooser.setFileFilter(this.filter);
            this.loadFile(this.textXMLFilename, this.areaXML);
        } else if (action.equals(ACTION_XML_RELOAD)) {
            this.loadFile(this.textXMLFilename, this.areaXML, false);
        } else if (action.equals(ACTION_XML_SAVE)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("XML Files");
            this.filter.addExtension("xml");
            this.fileChooser.setFileFilter(this.filter);
            this.saveFile(this.areaXML, this.textXMLFilename, false);
        } else if (action.equals(ACTION_XML_SAVEAS)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("XML Files");
            this.filter.addExtension("xml");
            this.fileChooser.setFileFilter(this.filter);
            this.saveFile(this.areaXML, this.textXMLFilename);
        } else if (action.equals(ACTION_XSL_LOAD)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("XSL Files");
            this.filter.addExtension("xsl");
            this.fileChooser.setFileFilter(this.filter);
            this.loadFile(this.textXSLFilename, this.areaXSL);
        } else if (action.equals(ACTION_XSL_RELOAD)) {
            this.loadFile(this.textXSLFilename, this.areaXSL, false);
        } else if (action.equals(ACTION_XSL_SAVE)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("XSL Files");
            this.filter.addExtension("xsl");
            this.fileChooser.setFileFilter(this.filter);
            this.saveFile(this.areaXSL, this.textXSLFilename, false);
        } else if (action.equals(ACTION_XSL_SAVEAS)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("XSL Files");
            this.filter.addExtension("xsl");
            this.fileChooser.setFileFilter(this.filter);
            this.saveFile(this.areaXSL, this.textXSLFilename);
        } else if (action.equals(ACTION_OUTPUT_SAVE)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("Text Files");
            this.filter.addExtension("txt");
            this.fileChooser.setFileFilter(this.filter);
            this.saveFile(this.areaOutput, this.textOutputFilename, false);
        } else if (action.equals(ACTION_OUTPUT_SAVEAS)) {
            this.filter = new SimpleFileFilter();
            this.filter.setDescription("Text Files");
            this.filter.addExtension("txt");
            this.fileChooser.setFileFilter(this.filter);
            this.saveFile(this.areaOutput, this.textOutputFilename);
        } else if (action.equals(ACTION_OUTPUT_GENERATE)) {
            this.generateOutput();
        } else if (action.equals(ACTION_JAVA_GENERATE)) {
            this.generateJava();
        }
    }

    private void setChangedStatus(DocumentEvent e) {
        if (e.getDocument() == this.areaXML.getDocument()) {
            this.isXMLChanged = true;
        } else if (e.getDocument() == this.areaXSL.getDocument()) {
            this.isXSLChanged = true;
        } else if (e.getDocument() == this.areaOutput.getDocument()) {
            this.isOutputChanged = true;
        } else if (e.getDocument() == this.areaJava.getDocument()) {
            this.isJavaChanged = true;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setChangedStatus(e);
        this.setConfirm();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setChangedStatus(e);
        this.setConfirm();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setChangedStatus(e);
        this.setConfirm();
    }

    @Override
    public void printDescription() {
        System.out.println("A little tool for testing XSL scripts. Can also be used for creating Java-");
        System.out.println("Code from the generated output.");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        XSLer frame = new XSLer(null);
        frame.run(args);
    }
}

