/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.util.Vector;
import proper.util.ProperVector;

public abstract class Data
implements Cloneable {
    protected static final boolean VERBOSE = false;
    private int id;
    private Vector data = new ProperVector();
    private Data parent = null;

    protected Data() {
        this(0);
    }

    public Data(int id) {
        this.id = id;
    }

    public Object clone() throws CloneNotSupportedException {
        Data result = null;
        try {
            result = (Data)this.getClass().newInstance();
            result.initWith(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void initWith(Data d) {
        this.id = d.id;
        this.parent = d.parent;
        this.data = (Vector)d.data.clone();
    }

    public abstract String getName();

    protected abstract void setName(String var1);

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setParent(Data parent) {
        this.parent = parent;
    }

    public Data getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void add(Object o) {
        if (o instanceof Data) {
            ((Data)o).setParent(this);
        }
        this.data.add(o);
    }

    public void add(int index, Object o) {
        if (o instanceof Data) {
            ((Data)o).setParent(this);
        }
        this.data.add(index, o);
    }

    public Object get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.getData().get(index);
        }
        return null;
    }

    public Object remove(int index) {
        return this.getData().remove(index);
    }

    public Vector getData() {
        return this.data;
    }

    public int size() {
        return this.getData().size();
    }

    public int getIndex(Data d) {
        int result = this.getData().indexOf(d);
        return result;
    }

    public int getParentIndex() {
        int result = -1;
        if (this.hasParent()) {
            result = this.getParent().getIndex(this);
        }
        return result;
    }

    public boolean isNull(int index) {
        if (index >= 0 && index < this.size()) {
            return Data.isNull(this.get(index).toString());
        }
        return false;
    }

    public static boolean isNull(String str) {
        boolean result = str.equals("n/a") || str.equals("'n/a'") || str.equals("?") || str.equals("_") || str.equals("NULL");
        return result;
    }

    public abstract String toString();
}

