/*
 * Decompiled with CFR 0.152.
 */
package main;

import data.catalog.CatalogFile;
import data.instance.Instances;
import eval.SimpleEvaluation;
import java.io.FileWriter;
import java.util.Collections;
import model.ModelOptions;
import model.reframe.RRS;
import model.reframe.RSHC;
import model.tree.DecisionTree;
import util.FileWrite;
import util.GlobalRandom;

public class ReframingTest {
    public static void main(String[] args) throws Exception {
        String baseDir = "/Users/ccharnay/Documents/these/aggregates/reframe/";
        String[] contexts = new String[]{"city1", "city2", "city3", "city4"};
        FileWriter fw = new FileWriter(String.valueOf(baseDir) + "results-contexts.csv", false);
        fw.write("Train;Deploy;Examples;ID;Base;Retrain;RSHC;RRS\n");
        fw.close();
        int i = 0;
        while (i < contexts.length) {
            String train = String.valueOf(baseDir) + contexts[i];
            FileWrite.setFileWrite(train);
            FileWrite.clearLog();
            ModelOptions optTrain = ModelOptions.getOptions(train);
            GlobalRandom.init(optTrain.seed);
            CatalogFile cat = new CatalogFile();
            cat.fillCatalog(String.valueOf(train) + ".prd", String.valueOf(train) + ".fct");
            cat.setClassInstances(optTrain.classPredicate);
            cat.setFunctions(optTrain.aggFunctions);
            optTrain.name = "tree";
            DecisionTree mod = new DecisionTree(optTrain);
            mod.build(cat.getClassInstances(), cat);
            int d = 0;
            while (d < contexts.length) {
                if (i != d) {
                    String reframefile = String.valueOf(baseDir) + contexts[d] + "-reframe";
                    CatalogFile catRefr = new CatalogFile();
                    catRefr.fillCatalog(String.valueOf(reframefile) + ".prd", String.valueOf(reframefile) + ".fct");
                    catRefr.setClassInstances(optTrain.classPredicate);
                    catRefr.setFunctions(optTrain.aggFunctions);
                    Instances reframeAll = new Instances(catRefr.getClassInstances());
                    String testfile = String.valueOf(baseDir) + contexts[d];
                    CatalogFile catTest = new CatalogFile();
                    catTest.fillCatalog(String.valueOf(testfile) + ".prd", String.valueOf(testfile) + ".fct");
                    catTest.setClassInstances(optTrain.classPredicate);
                    catTest.setFunctions(optTrain.aggFunctions);
                    Instances test = new Instances(catTest.getClassInstances());
                    SimpleEvaluation evalBase = new SimpleEvaluation(optTrain.mode);
                    evalBase.evaluateModel(mod, test, catTest, true);
                    double accBase = (Double)evalBase.getStatistics().getStat("accuracy");
                    int nr = 4;
                    while (nr <= 30) {
                        int k = 0;
                        while (k < 30) {
                            Collections.shuffle(reframeAll, GlobalRandom.instance());
                            Instances reframe = new Instances(reframeAll.subList(0, nr));
                            DecisionTree retrain = new DecisionTree(optTrain);
                            retrain.build(reframe, catRefr);
                            SimpleEvaluation evalRetrain = new SimpleEvaluation(optTrain.mode);
                            evalRetrain.evaluateModel(retrain, test, catTest, true);
                            double accRetrain = (Double)evalRetrain.getStatistics().getStat("accuracy");
                            RSHC rshc = new RSHC(mod, optTrain);
                            rshc.reframe(reframe, catRefr);
                            SimpleEvaluation evalRshc = new SimpleEvaluation(optTrain.mode);
                            evalRshc.evaluateModel(mod, test, catTest, false);
                            double accRshc = (Double)evalRshc.getStatistics().getStat("accuracy");
                            mod.rebootShifts();
                            RRS rrs = new RRS(mod, optTrain);
                            rrs.reframe(reframe, catRefr);
                            SimpleEvaluation evalRrs = new SimpleEvaluation(optTrain.mode);
                            evalRrs.evaluateModel(mod, test, catTest, false);
                            double accRrs = (Double)evalRrs.getStatistics().getStat("accuracy");
                            mod.rebootShifts();
                            FileWriter fw2 = new FileWriter(String.valueOf(baseDir) + "results-contexts.csv", true);
                            fw2.write(String.valueOf(contexts[i]) + ";" + contexts[d] + ";" + nr + ";" + k + ";" + accBase + ";" + accRetrain + ";" + accRshc + ";" + accRrs + "\n");
                            fw2.close();
                            ++k;
                        }
                        nr += 2;
                    }
                }
                ++d;
            }
            ++i;
        }
    }
}

