/*
 * Decompiled with CFR 0.152.
 */
package model.reframe;

import data.catalog.Catalog;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import eval.SimpleEvaluation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import model.Model;
import model.ModelOptions;

public abstract class Reframer {
    protected Model cls;
    protected HashSet<NumericShiftFunction> shifts;
    protected ModelOptions opts;
    protected boolean input;
    protected boolean output;
    protected double p = 0.2;

    public Reframer(Model baseCls, ModelOptions opt) {
        this(baseCls, opt, true, true);
    }

    public Reframer(Model baseCls, ModelOptions opt, boolean in, boolean out) {
        this.cls = baseCls;
        this.opts = opt;
        this.input = in;
        this.output = out;
        this.shifts = new HashSet();
    }

    public Model clone() {
        return null;
    }

    public Model getBaseClassifier() {
        return this.cls;
    }

    public void setBaseClassifier(Model mod) {
        this.cls = mod;
    }

    public abstract void reframe(Instances var1, Catalog var2) throws Exception;

    protected double evaluatePerformance(Instances deploy, Catalog cat) throws Exception {
        SimpleEvaluation eval = new SimpleEvaluation(this.opts.mode);
        eval.evaluateModel(this.cls, deploy, cat, false);
        double res = this.opts.mode.equals("classification") ? (Double)eval.getStatistics().getStat("accuracy") : -((Double)eval.getStatistics().getStat("rmse")).doubleValue();
        return res;
    }

    protected void applyShifts(HashMap<NumericShiftFunction, double[]> currentParams) {
        for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
            ent.getKey().setParameters(ent.getValue());
        }
    }
}

