#!/bin/bash

# this scripts changes the hostname, port, user and password in the ant files
#
# $Revision: 1.4 $
# FracPete

# prints the usage of this script
function usage()
{
echo
echo "usage: ${0##*/} -H <hostname> -P <port> -u <user> -p <password> -d <dbname> -b [-h]"
echo
echo "changes the hostname, port, user and password for MySQL in the ANT files"
echo
echo " -h   this help"
echo " -H   the hostname where the MySQL server resides"
echo "      default: $HOST"
echo " -P   the port on which the MySQL server listens"
echo "      default: $PORT"
echo " -u   the user with which to connect to the DB"
echo "      default: $USER"
echo " -p   the password of the user"
echo "      default: $PASSWORD"
echo " -d   the name of the database"
echo "      default: $DBNAME"
echo " -b   backup the files"
echo
}

function change_property
{
"$SCRIPT" -p "driver"   -v "org.gjt.mm.mysql.Driver"      -d "$DIRNAME" $BAK
"$SCRIPT" -p "url"      -v "jdbc:mysql:\/\/$HOST:$PORT\/" -d "$DIRNAME" $BAK
"$SCRIPT" -p "user"     -v "$USER"                        -d "$DIRNAME" $BAK
"$SCRIPT" -p "password" -v "$PASSWORD"                    -d "$DIRNAME" $BAK
"$SCRIPT" -p "project-name" -v "$DBNAME"                  -d "$DIRNAME" $BAK
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
XMLDIR="$ROOT/../xml"
XMLDIR2="$ROOT/../src/proper/gui/experiment"
PORT=3306
HOST=localhost
USER=peter
PASSWORD=peter
DBNAME=wekaproperdb
BACKUP=no
SCRIPT="$ROOT/change_property.sh"

# interprete parameters
while getopts ":hbH:P:u:p:d:" flag
do
case $flag in
h) usage
exit 0
;;
H) HOST="$OPTARG"
;;
P) PORT="$OPTARG"
;;
u) USER="$OPTARG"
;;
p) PASSWORD="$OPTARG"
;;
b) BACKUP=yes
;;
d) DBNAME="$OPTARG"
;;
*) usage
exit 1
;;
esac
done

if [ "$BACKUP" = "yes" ]
then
BAK="-b"
else
BAK=""
fi

DIRNAME="$ROOT/../"
change_property
DIRNAME="$XMLDIR"
change_property
DIRNAME="$XMLDIR2"
change_property

