/*
 * Decompiled with CFR 0.152.
 */
package data.parameter;

import data.feature.SingleValueFeature;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.Arrays;
import org.jdom2.Element;

public class AffineShift
extends NumericShiftFunction {
    private double alpha;
    private double beta;

    public AffineShift() {
        this.alpha = 1.0;
        this.beta = 0.0;
    }

    public AffineShift(SingleValueFeature svf) {
        this.alpha = 1.0;
        this.beta = 0.0;
        this.feature = svf;
    }

    public AffineShift(double a, double b) {
        this.alpha = a;
        this.beta = b;
    }

    public AffineShift(double a, double b, SingleValueFeature svf) {
        this.alpha = a;
        this.beta = b;
        this.feature = svf;
    }

    public AffineShift(Element shiftEl) {
        this(new Double(shiftEl.getAttributeValue("slope")), new Double(shiftEl.getAttributeValue("intercept")));
        this.setParamsOrig(new double[]{new Double(shiftEl.getAttributeValue("minOrig")), new Double(shiftEl.getAttributeValue("maxOrig"))});
    }

    @Override
    public Value apply(Value in) {
        return new Value(this.alpha * in.getNumericValue() + this.beta);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    @Override
    public AffineShift clone() {
        AffineShift res = new AffineShift(this.alpha, this.beta);
        res.setParamsOrig(Arrays.copyOf(this.paramsOrig, this.paramsOrig.length));
        res.setParamsDeploy(Arrays.copyOf(this.paramsDeploy, this.paramsDeploy.length));
        return res;
    }

    @Override
    public void setParameters(double[] params) {
        this.alpha = params[0];
        this.beta = params[1];
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("affine");
        el.setAttribute("slope", String.valueOf(this.alpha));
        el.setAttribute("intercept", String.valueOf(this.beta));
        el.setAttribute("minOrig", String.valueOf(this.paramsOrig[0]));
        el.setAttribute("maxOrig", String.valueOf(this.paramsOrig[1]));
        return el;
    }

    @Override
    public String toString() {
        return String.valueOf(Arrays.toString(this.paramsOrig)) + " " + Arrays.toString(this.paramsDeploy) + " " + this.alpha + "*x+" + this.beta;
    }

    @Override
    public double[] getParameters() {
        return new double[]{this.alpha, this.beta};
    }

    @Override
    public void rebootParams() {
        this.alpha = 1.0;
        this.beta = 0.0;
    }
}

