/*
 * Decompiled with CFR 0.152.
 */
package proper.relaggs;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import proper.relaggs.RelaggsAttribute;

public class RelaggsTable
implements Comparable {
    public static final String SHORT_NAME_PREFIX = "t";
    public static final String SHORT_NAME_PREFIX_TMP = "rl";
    private String name;
    private String short_name;
    private Hashtable attributes;
    private int row_number;
    private Hashtable primary_keys;
    private Hashtable foreign_keys;
    private int maxColumns;
    private HashSet columns;

    public RelaggsTable(String table_name) {
        this.name = table_name;
        this.attributes = new Hashtable();
        this.primary_keys = new Hashtable();
        this.foreign_keys = new Hashtable();
        this.row_number = 0;
        this.maxColumns = -1;
        this.columns = new HashSet();
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public HashSet getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + this.short_name + "]";
    }

    public void setRowNumber(int value) {
        this.row_number = value;
    }

    public int getRowNumber() {
        return this.row_number;
    }

    public void setShortName(String short_name) {
        this.short_name = short_name;
    }

    public void setShortName(int number) {
        this.short_name = SHORT_NAME_PREFIX + number;
    }

    public void setShortName(int number, boolean is_tmp) {
        this.short_name = is_tmp ? SHORT_NAME_PREFIX_TMP + number : SHORT_NAME_PREFIX + number;
    }

    public String getShortName() {
        return this.short_name;
    }

    public boolean hasForeignKey(RelaggsTable ref_table) {
        Enumeration enm = ref_table.getPrimaryKeys();
        while (enm.hasMoreElements()) {
            RelaggsAttribute prim_key = (RelaggsAttribute)enm.nextElement();
            if (this.attributes.get(prim_key.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public Enumeration getPrimaryKeys() {
        return this.primary_keys.elements();
    }

    public boolean addAttribute(RelaggsAttribute attribute) {
        if (this.attributes.get(attribute.getName()) == null) {
            this.attributes.put(attribute.getName(), attribute);
            return true;
        }
        return false;
    }

    public boolean addPrimaryKey(String prim_key) {
        if (this.attributes.get(prim_key) == null && this.primary_keys.get(prim_key) != null) {
            return false;
        }
        if (this.attributes.get(prim_key) != null) {
            this.primary_keys.put(prim_key, this.attributes.get(prim_key));
            return true;
        }
        return false;
    }

    public void addForeignKey(RelaggsTable ref_table) {
        Enumeration enm = ref_table.getPrimaryKeys();
        while (enm.hasMoreElements()) {
            RelaggsAttribute prim_key = (RelaggsAttribute)enm.nextElement();
            if (this.attributes.get(prim_key.getName()) == null) continue;
            this.foreign_keys.put(prim_key.getName(), this.attributes.get(prim_key.getName()));
        }
    }

    public void addForeignKey2(String aggr_column, String this_column) {
        this.foreign_keys.put(aggr_column, this_column);
    }

    public Object clone() {
        RelaggsTable t = new RelaggsTable(this.name);
        t.setShortName(this.short_name);
        t.attributes = (Hashtable)this.attributes.clone();
        t.primary_keys = (Hashtable)this.primary_keys.clone();
        t.foreign_keys = (Hashtable)this.foreign_keys.clone();
        t.columns = (HashSet)this.columns.clone();
        t.maxColumns = this.maxColumns;
        return t;
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public Iterator getAttributesOrdered() {
        Collection coll_attributes = this.attributes.values();
        Vector vec_attributes = new Vector(coll_attributes);
        Collections.sort(vec_attributes);
        return vec_attributes.iterator();
    }

    public RelaggsAttribute getAttribute(String name) {
        return (RelaggsAttribute)this.attributes.get(name);
    }

    public String getName() {
        return this.name;
    }

    public int getNumberAttributes() {
        return this.attributes.size();
    }

    public int getNumForeignKeys() {
        return this.foreign_keys.size();
    }

    public boolean isPrimaryKey(String attribute_name) {
        return this.primary_keys.get(attribute_name) != null;
    }

    public boolean isForeignKey(String attribute_name) {
        return this.foreign_keys.get(attribute_name) != null;
    }

    public boolean isAttribute(String attribute_name) {
        return this.attributes.get(attribute_name) != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelaggsTable) {
            RelaggsTable cmp_obj = (RelaggsTable)obj;
            return this.name.equals(cmp_obj.getName());
        }
        return super.equals(obj);
    }

    public int compareTo(Object o) {
        if (o instanceof RelaggsTable) {
            return this.name.compareTo(((RelaggsTable)o).getName());
        }
        throw new ClassCastException();
    }
}

