/*
 * Decompiled with CFR 0.152.
 */
package proper.remote.messages;

import java.io.Reader;
import java.util.Vector;
import proper.remote.Job;
import proper.remote.messages.Message;
import proper.xml.Element;

public class JobMessage
extends Message {
    public static final String JOB = "job";
    public static final String STATUS = "status";
    public static final String RUN = "run";
    public static final String ADDITIONAL = "additional";
    public static final String STATUS_READY = "ready";
    public static final String STATUS_FINISHED = "finished";
    public static final String STATUS_FAILED = "failed";

    public JobMessage() {
    }

    public JobMessage(Reader reader) {
        super(reader);
    }

    public JobMessage(Message msg) {
        super(msg);
    }

    public JobMessage(String job) {
        this();
        this.setJobData(job);
    }

    @Override
    public boolean isOtherMessage(Message msg) {
        return this.getJob() == null;
    }

    @Override
    public void clearBody() {
        super.clearBody();
        Element node = this.getBody();
        node.add(new Element(JOB));
        node = this.getJob();
        node.add(new Element(STATUS));
        node.add(new Element(RUN));
        node.add(new Element(ADDITIONAL));
    }

    public void setJobData(String job) {
        this.clearBody();
        Job j = new Job(job);
        this.setStatus(STATUS_READY);
        String tmp = j.getClassName();
        int i = 0;
        while (i < j.getParameter().length) {
            tmp = String.valueOf(tmp) + " " + j.getParameter()[i];
            ++i;
        }
        this.setRun(tmp);
        Element node = this.getAdditional();
        if (j.getAdditional() != null) {
            i = 0;
            while (i < j.getAdditional().length) {
                node.add(new Element(RUN, j.getAdditional()[i]));
                ++i;
            }
        }
    }

    public String getJobData() {
        String result = this.getRun();
        Vector lines = this.getAdditionalLines();
        int i = 0;
        while (i < lines.size()) {
            result = String.valueOf(result) + ";" + lines.get(i);
            ++i;
        }
        return result;
    }

    public Element getJob() {
        return this.getNode(this.getBody(), JOB);
    }

    public Element getAdditional() {
        return this.getNode(this.getJob(), ADDITIONAL);
    }

    public Vector getAdditionalLines() {
        return this.getContent(this.getAdditional(), ".//run");
    }

    public String getAdditionalLine(int index) {
        Vector lines = this.getAdditionalLines();
        if (index >= 0 && index < lines.size()) {
            return (String)lines.get(index);
        }
        return "";
    }

    public String getStatus() {
        return this.getContent(this.getNode(this.getJob(), STATUS), true);
    }

    public void setStatus(String status) {
        this.setContent(this.getNode(this.getJob(), STATUS), status);
    }

    public String getRun() {
        return this.getContent(this.getNode(this.getJob(), RUN), true);
    }

    public void setRun(String run) {
        this.setContent(this.getNode(this.getJob(), RUN), run);
    }

    public static void main(String[] args) {
        JobMessage job = new JobMessage();
        String tmp = "proper.app.Import -database blabla -user dork";
        job.setJobData(tmp);
        System.out.println("This job:\n" + tmp + "\n\n" + "becomes to this:\n" + job + "\n\n" + "and back to this:\n" + job.getJobData());
        job = new JobMessage();
        tmp = "proper.app.Import -database blabla -user dork;get_file something";
        job.setJobData(tmp);
        System.out.println("This job:\n" + tmp + "\n\n" + "becomes to this:\n" + job + "\n\n" + "and back to this:\n" + job.getJobData());
    }
}

