/*
 * Decompiled with CFR 0.152.
 */
package proper.util;

public class TemporaryName {
    private String prefix;
    private String current;
    private boolean alphaNumeric;

    public TemporaryName(String prefix) {
        this(prefix, true);
    }

    public TemporaryName(String prefix, boolean alphanum) {
        this.prefix = prefix;
        this.current = prefix;
        this.alphaNumeric = alphanum;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean getAlphaNumeric() {
        return this.alphaNumeric;
    }

    public String getCurrent() {
        return this.current;
    }

    public String next() {
        String result = this.current;
        if (result.equals(this.prefix)) {
            result = String.valueOf(result) + "0";
        } else {
            char suffix = result.charAt(result.length() - 1);
            if (suffix == '9') {
                result = this.alphaNumeric ? String.valueOf(result.substring(0, result.length() - 1)) + "a" : String.valueOf(result) + "0";
            } else if (suffix == 'z') {
                result = String.valueOf(result) + "0";
            } else {
                result = result.substring(0, result.length() - 1);
                suffix = (char)(suffix + '\u0001');
                result = String.valueOf(result) + suffix;
            }
        }
        this.current = result;
        return result;
    }
}

