/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.util.List;
import java.util.Vector;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.ConnectorObject;
import proper.database.Join;
import proper.database.JoinTreeNode;
import proper.database.Table;
import proper.database.TableLister;
import proper.util.Excluder;
import proper.util.ProperVector;
import proper.util.Set;

public class RelationDiscoverer
extends ConnectorObject {
    private TableLister lister;
    private String table;
    private Excluder excluder = new Excluder("");
    private Vector allTables;
    private int maxDepth = -1;
    private boolean useForeignKeys;
    private List<String> associatedTables = null;

    public RelationDiscoverer(Connector conn) {
        super(conn);
        this.lister = new TableLister(conn);
        this.useForeignKeys = false;
    }

    public void setAssociatedTables(List<String> stringParameter) {
        this.associatedTables = stringParameter;
    }

    public List<String> getAssociatedTables() {
        return this.associatedTables;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public void setExcludes(Vector excludes) {
        this.excluder = new Excluder(excludes);
    }

    public void setExcludes(String excludes) {
        this.excluder = new Excluder(excludes);
    }

    public Vector getExcludes() {
        return this.excluder.getList();
    }

    public void setMaxDepth(int maxDepth) {
        if (maxDepth == -1 | maxDepth > 0) {
            this.maxDepth = maxDepth;
        }
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setUseForeignKeys(boolean useForeignKeys) {
        this.useForeignKeys = useForeignKeys;
    }

    public boolean getUseForeignKeys() {
        return this.useForeignKeys;
    }

    private Vector removeTable(Vector tables, String table) {
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < tables.size()) {
            if (!tables.get(i).toString().equals(table)) {
                result.add(tables.get(i));
            }
            ++i;
        }
        return result;
    }

    private void discoverByName(JoinTreeNode parent, Vector tables, boolean removeAttached) {
        ColumnLister col = new ColumnLister(this.conn);
        col.setSort(true);
        col.setOnlyIndexes(true);
        col.setAddTable(false);
        String tableParent = parent.isJoin() ? parent.getJoin().getLeftTable() : parent.getTable().getName();
        col.setTable(tableParent);
        Vector parentList = col.getList();
        if (parentList.size() == 0) {
            return;
        }
        int i = 0;
        while (i < tables.size()) {
            boolean found = false;
            String tableName = tables.get(i).toString();
            col.setTable(tableName);
            col.setOnlyIndexes(false);
            Vector tableList = col.getList();
            int n = 0;
            while (n < parentList.size()) {
                String colName = parentList.get(n).toString();
                if (tableList.contains(new Column(colName))) {
                    found = true;
                    int size = col.getExecutor().getRecordCount(tables.get(i).toString());
                    int colType = ((Column)parentList.get(n)).getType();
                    JoinTreeNode child = new JoinTreeNode(new Join(tables.get(i).toString(), colName, size, tableParent, colName, colType));
                    parent.add(child);
                    if (this.getVerbose()) {
                        this.println(parent + " -> " + tableName + " = " + colName + ":");
                        this.println(((JoinTreeNode)child.getRoot()).toString());
                    }
                    tables = this.removeTable(tables, tableName);
                    break;
                }
                ++n;
            }
            if (found) continue;
            ++i;
        }
    }

    private void discoverByRelation(JoinTreeNode parent, Vector tables, boolean removeAttached) {
        JoinTreeNode child;
        int size;
        Column ccolumn;
        int n;
        Vector columns;
        Column column;
        ColumnLister col = new ColumnLister(this.conn);
        col.setSort(true);
        col.setOnlyImportedKeys(true);
        if (parent.isJoin()) {
            col.setTable(parent.getJoin().getLeftTable());
        } else {
            col.setTable(parent.getTable().getName());
        }
        col.setAddTable(true);
        Vector list = col.getList();
        int i = 0;
        while (i < list.size()) {
            column = (Column)list.get(i);
            if (tables.contains(new Table(column.getTable()))) {
                columns = col.getColumnNamesForImportedKey(column.getName());
                n = 0;
                while (n < columns.size()) {
                    ccolumn = (Column)columns.get(n);
                    size = col.getExecutor().getRecordCount(tables.get(i).toString());
                    child = new JoinTreeNode(new Join(column.getTable(), column.getName(), size, ccolumn.getTable(), ccolumn.getName(), ccolumn.getType()));
                    parent.add(child);
                    ++n;
                }
            }
            ++i;
        }
        col.setOnlyExportedKeys(true);
        if (parent.isJoin()) {
            col.setTable(parent.getJoin().getLeftTable());
        } else {
            col.setTable(parent.getTable().getName());
        }
        col.setAddTable(true);
        list = col.getList();
        i = 0;
        while (i < list.size()) {
            column = (Column)list.get(i);
            columns = col.getColumnNamesForImportedKey(column.getName());
            n = 0;
            while (n < columns.size()) {
                ccolumn = (Column)columns.get(n);
                if (tables.contains(new Table(ccolumn.getTable()))) {
                    size = col.getExecutor().getRecordCount(tables.get(i).toString());
                    child = new JoinTreeNode(new Join(ccolumn.getTable(), ccolumn.getName(), size, column.getTable(), column.getName(), column.getType()));
                    parent.add(child);
                }
                ++n;
            }
            ++i;
        }
    }

    private void discover(JoinTreeNode parent, Vector tables, boolean removeAttached) {
        if (tables.size() == 0) {
            return;
        }
        if (!removeAttached && this.getMaxDepth() > -1 && parent.getLevel() == this.getMaxDepth()) {
            return;
        }
        if (this.getUseForeignKeys()) {
            this.discoverByRelation(parent, tables, removeAttached);
        } else {
            this.discoverByName(parent, tables, removeAttached);
        }
        int i = 0;
        while (i < parent.getChildCount()) {
            JoinTreeNode child = (JoinTreeNode)parent.getChildAt(i);
            if (!removeAttached) {
                tables = Set.minus(this.allTables, parent.getTablesAlongPath());
                tables = this.removeTable(tables, child.getJoin().getLeftTable());
            }
            this.discover(child, tables, removeAttached);
            if (tables.size() == 0) break;
            ++i;
        }
    }

    private void init() {
        Vector excludes = this.excluder.getList();
        excludes.add(this.getTable());
        this.lister.setExcludes(excludes);
        this.allTables = this.removeTable(this.lister.getList(), this.getTable());
    }

    public JoinTreeNode discover() {
        return this.discover(false);
    }

    private JoinTreeNode discover(boolean attachLeftOvers) {
        JoinTreeNode root = new JoinTreeNode(this.lister.getList(this.getTable()).get(0).toString());
        this.init();
        if (this.getVerbose()) {
            this.println(this.allTables);
            this.println(root.toString());
        }
        if (this.getAssociatedTables() == null) {
            this.discover(root, this.allTables, false);
            if (attachLeftOvers) {
                Vector allNodes = root.getAllNodes();
                int i = 0;
                while (i < allNodes.size()) {
                    Vector leftOvers = this.leftOverTables(root);
                    if (leftOvers.size() != 0) {
                        this.discover((JoinTreeNode)allNodes.get(i), leftOvers, true);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            ProperVector tableVector = new ProperVector();
            for (String table : this.getAssociatedTables()) {
                tableVector.addAll(this.lister.getList(table));
            }
            this.discover(root, tableVector, false);
        }
        return root;
    }

    public Vector leftOverTables() {
        return this.leftOverTables(this.discover());
    }

    public Vector leftOverTables(JoinTreeNode root) {
        this.init();
        Vector result = Set.minus(this.allTables, root.getAllTables());
        return result;
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + "\n";
        result = String.valueOf(result) + "Table   : " + this.getTable() + "\n";
        result = String.valueOf(result) + "MaxDepth: " + this.getMaxDepth() + "\n";
        result = String.valueOf(result) + "Excludes: " + this.getExcludes() + "\n";
        return result;
    }
}

