/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import proper.database.Table;
import proper.util.ProperVector;

public class TableTreeNode
extends DefaultMutableTreeNode {
    public TableTreeNode() {
    }

    public TableTreeNode(Object o) {
        this.setTable(o);
    }

    public void setTable(Object o) {
        if (o instanceof String) {
            this.setUserObject(new Table(o.toString()));
        } else if (o instanceof Table) {
            this.setUserObject(o);
        } else {
            this.setUserObject(null);
        }
    }

    public Table getTable() {
        return (Table)this.getUserObject();
    }

    public Table getChildTableAt(int index) {
        return ((TableTreeNode)this.getChildAt(index)).getTable();
    }

    public boolean isInPath(Table t) {
        Vector tables = this.getTablesAlongPath();
        return tables.indexOf(t) > 1;
    }

    public Vector getTablesAlongPath() {
        ProperVector result = new ProperVector();
        TableTreeNode node = this;
        while (node != null) {
            result.add(node.getTable());
            node = (TableTreeNode)node.getParent();
        }
        return result;
    }

    public Vector getAllNodes() {
        ProperVector result = new ProperVector();
        Enumeration<TreeNode> enm = this.depthFirstEnumeration();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result;
    }

    public Vector getAllTables() {
        ProperVector result = new ProperVector();
        Vector nodes = this.getAllNodes();
        int i = 0;
        while (i < nodes.size()) {
            TableTreeNode anode = (TableTreeNode)nodes.get(i);
            result.add(anode.getTable());
            ++i;
        }
        return result;
    }

    private static String getNextStructure(String tree) {
        int commaPos;
        String result = "";
        int bracketPos = tree.indexOf("[");
        if (bracketPos == -1) {
            bracketPos = tree.length();
        }
        if ((commaPos = tree.indexOf(",")) == -1) {
            commaPos = tree.length();
        }
        if (commaPos < bracketPos) {
            result = tree.substring(0, commaPos);
        } else if (bracketPos < commaPos) {
            if (bracketPos > 0) {
                result = tree.substring(0, bracketPos);
            } else {
                int openCount = 0;
                int closeCount = 0;
                int i = 0;
                while (i < tree.length()) {
                    String chr = tree.substring(i, i + 1);
                    result = String.valueOf(result) + chr;
                    if (chr.equals("[")) {
                        ++openCount;
                    }
                    if (chr.equals("]")) {
                        ++closeCount;
                    }
                    if (openCount <= 0 || openCount != closeCount) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = tree;
        }
        return result;
    }

    private static TableTreeNode createNode(String part) {
        String size;
        String name;
        if (part.indexOf("(") > -1) {
            name = part.substring(0, part.indexOf("("));
            size = part.replaceAll(".*\\(", "").replaceAll("\\)", "");
        } else {
            name = part;
            size = "0";
        }
        return new TableTreeNode(new Table(name, Integer.parseInt(size)));
    }

    private static TableTreeNode parseTreeString(TableTreeNode parent, String tree) {
        if (parent == null) {
            String part = TableTreeNode.getNextStructure(tree);
            parent = TableTreeNode.createNode(part);
            String newTree = tree.substring(part.length() + 1, tree.length() - 1);
            TableTreeNode.parseTreeString(parent, newTree);
        } else {
            String newTree = tree;
            while (!newTree.equals("")) {
                String part = TableTreeNode.getNextStructure(newTree);
                if ((newTree = newTree.substring(part.length(), newTree.length())).startsWith(",")) {
                    newTree = newTree.substring(1, newTree.length());
                    if (part.equals("")) continue;
                    parent.add(TableTreeNode.createNode(part));
                    continue;
                }
                if (newTree.startsWith("[")) {
                    if (!part.equals("")) {
                        parent.add(TableTreeNode.createNode(part));
                    }
                    String tmp = TableTreeNode.getNextStructure(newTree);
                    TableTreeNode.parseTreeString((TableTreeNode)parent.getChildAt(parent.getChildCount() - 1), tmp.substring(1, tmp.length() - 1));
                    newTree = newTree.substring(tmp.length(), newTree.length());
                    continue;
                }
                if (part.equals("")) continue;
                parent.add(TableTreeNode.createNode(part));
            }
        }
        return parent;
    }

    public static TableTreeNode parseTreeString(String tree) {
        return TableTreeNode.parseTreeString(null, tree.replaceAll(" ", ""));
    }

    public String toTreeString() {
        return this.toTreeString(false);
    }

    public String toTreeString(boolean includeSizes) {
        return TableTreeNode.toTreeString(this, includeSizes);
    }

    public static String toTreeString(TableTreeNode node) {
        return TableTreeNode.toTreeString(node, false);
    }

    public static String toTreeString(TableTreeNode node, boolean includeSizes) {
        StringBuffer result = new StringBuffer(node.getTable().getName());
        if (includeSizes) {
            result.append("(" + node.getTable().getSize() + ")");
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (i == 0) {
                result.append("[");
            }
            if (!result.toString().endsWith("[")) {
                result.append(",");
            }
            result.append(TableTreeNode.toTreeString((TableTreeNode)node.getChildAt(i), includeSizes));
            if (i == node.getChildCount() - 1) {
                result.append("]");
            }
            ++i;
        }
        return result.toString();
    }

    private String toString(TableTreeNode node, String str) {
        StringBuffer tmp = new StringBuffer(str);
        int i = 0;
        while (i < node.getLevel()) {
            if (i > 0) {
                tmp.append(" ");
            }
            tmp.append("|");
            ++i;
        }
        if (node.getLevel() > 0) {
            tmp.append("-");
        }
        tmp.append(String.valueOf(node.getTable().toString()) + "\n");
        i = 0;
        while (i < node.getChildCount()) {
            tmp = new StringBuffer(this.toString((TableTreeNode)node.getChildAt(i), tmp.toString()));
            ++i;
        }
        return tmp.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean all) {
        if (all) {
            return this.toString(this, "");
        }
        return this.getTable().toString();
    }
}

