/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import proper.gui.core.dialog.MessageBox;
import proper.gui.core.panel.ProperPanel;

public class OkCancelPanel
extends ProperPanel
implements SwingConstants {
    public static final String ACTION_OK = "ok";
    public static final String ACTION_CANCEL = "cancel";
    public JButton buttonOK;
    public JButton buttonCancel;
    private boolean horizontal;
    private int verticalAlignment;
    private int horizontalAlignment;

    public OkCancelPanel() {
        this(true);
    }

    public OkCancelPanel(boolean horizontal) {
        this(horizontal, 1, 4);
    }

    public OkCancelPanel(boolean horizontal, int verticalAlignment, int horizontalAlignment) {
        this.horizontal = horizontal;
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.createPanel();
    }

    @Override
    protected void createPanel() {
        this.buttonOK = new JButton(MessageBox.BUTTONS_OKCANCEL[0]);
        this.buttonOK.setActionCommand(ACTION_OK);
        this.buttonOK.setMnemonic('O');
        this.buttonCancel = new JButton(MessageBox.BUTTONS_OKCANCEL[1]);
        this.buttonCancel.setActionCommand(ACTION_CANCEL);
        this.buttonCancel.setMnemonic('C');
        JPanel panel = this.horizontal ? new JPanel(new GridLayout(1, 2)) : new JPanel(new GridLayout(2, 1));
        panel.add(this.buttonOK);
        panel.add(this.buttonCancel);
        JPanel panel2 = new JPanel(new BorderLayout());
        if (this.verticalAlignment == 3) {
            panel2.add((Component)panel, "South");
        } else if (this.verticalAlignment == 0) {
            panel2.add((Component)panel, "Center");
        } else {
            panel2.add((Component)panel, "North");
        }
        if (this.horizontalAlignment == 2) {
            this.add((Component)panel2, "West");
        } else if (this.horizontalAlignment == 0) {
            this.add((Component)panel2, "Center");
        } else {
            this.add((Component)panel2, "East");
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.buttonOK.removeActionListener(listener);
        this.buttonCancel.removeActionListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.removeActionListener(listener);
        this.buttonOK.addActionListener(listener);
        this.buttonCancel.addActionListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.buttonOK.removeKeyListener(listener);
        this.buttonCancel.removeKeyListener(listener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.removeKeyListener(listener);
        this.buttonOK.addKeyListener(listener);
        this.buttonCancel.addKeyListener(listener);
    }
}

