/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.util.Vector;
import proper.core.ProperObject;
import proper.imp.CSVParser;
import proper.imp.Data;
import proper.imp.Indexer;
import proper.imp.List;
import proper.imp.Predicate;
import proper.imp.Traverser;
import proper.util.Formatter;
import proper.util.ProperVector;

public class Namer
extends ProperObject {
    private Traverser traverser;
    private Indexer indexer;
    private boolean identifiers;
    private boolean containsID;

    public Namer(Traverser t, Indexer i) {
        this.traverser = t;
        this.indexer = i;
        this.identifiers = t.findFirst(CSVParser.IDENTIFIER_PREDICATE) != null;
        this.containsID = false;
    }

    public void setContainsID(boolean containsID) {
        this.containsID = containsID;
    }

    public boolean getContainsID() {
        return this.containsID;
    }

    public boolean hasIdentifiers() {
        return this.identifiers;
    }

    public Vector createIdNames(Data d) {
        ProperVector result = new ProperVector();
        if (d instanceof Predicate) {
            int i = 0;
            while (i < d.size()) {
                if (this.indexer.isIndex(d, i)) {
                    result.add(this.createName(d, i));
                }
                ++i;
            }
        }
        return result;
    }

    public String fixName(String name) {
        String result = name.toLowerCase();
        result = result.replaceAll("-", "_");
        result = result.replaceAll(" ", "_");
        result = result.replaceAll("[^0-9a-z_]", "");
        return result;
    }

    public String getTable(String name) {
        if (name == null) {
            return null;
        }
        return this.fixName(name);
    }

    public String getTable(Data d) {
        if (d == null) {
            return null;
        }
        return this.getTable(d.getName());
    }

    public String getPrimaryKey(String name) {
        if (name == null) {
            return null;
        }
        return String.valueOf(this.fixName(name)) + "_id";
    }

    public String getPrimaryKey(Data d) {
        if (d == null) {
            return null;
        }
        return this.getPrimaryKey(d.getName());
    }

    public String getParentPrimaryKey(Data d) {
        if (d == null) {
            return null;
        }
        return this.getPrimaryKey(d.getParent());
    }

    private String createName(Data d, int index) {
        String result;
        if (this.hasIdentifiers()) {
            result = this.getColumnName(d, index);
        } else {
            Vector ids;
            result = "id";
            if (d instanceof Predicate && (ids = this.indexer.getIndexes(d.getName())).size() != 1) {
                int i = 0;
                while (i < ids.size()) {
                    if (index == this.indexer.getIndex(d, (String)ids.get(i))) {
                        if (i <= 0) break;
                        result = String.valueOf(result) + Integer.toString(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public String getColumnName(Data d, int index) {
        boolean idIndex = this.indexer.isIndex(d, index);
        String column = null;
        Vector types = this.traverser.findAllArgTypes(d.getName());
        if (this.hasIdentifiers() && d instanceof Predicate) {
            List list;
            Predicate p;
            Vector preds = this.traverser.findAll(CSVParser.FILE_PREDICATE);
            Data file = null;
            int i = 0;
            while (i < preds.size()) {
                p = (Predicate)preds.get(i);
                if (p.get(1).toString().equals(d.getName())) {
                    file = p;
                    break;
                }
                ++i;
            }
            if (file != null && (list = (List)file.get(file.size() - 1)) != null) {
                p = (Predicate)list.get(index);
                column = this.fixName(p.get(p.size() - 1).toString());
            }
        }
        if (column == null) {
            column = this.containsID && idIndex ? this.createName(d, index) : (types.get(index) instanceof Data ? String.valueOf(((Data)types.get(index)).getName()) + "_id" : String.valueOf(this.fixName(d.getName())) + Formatter.format(index, Integer.toString(types.size()).length(), true, '0'));
            if (this.indexer.isSplitIndexId(d, index)) {
                column = "split_id";
            }
        }
        return column;
    }
}

