/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import proper.core.ProperObject;
import proper.imp.Data;
import proper.imp.Fingerprint;
import proper.imp.Indexer;
import proper.imp.List;
import proper.imp.Predicate;
import proper.imp.Traverser;
import proper.util.Counter;
import proper.util.Includer;
import proper.util.ProperVector;
import proper.util.RandomID;
import proper.util.Strings;

public class PostProcessor
extends ProperObject {
    public static final boolean USE_WIDENING = true;
    public static final boolean USE_SPLITTING = true;
    public static final boolean USE_FIXMULTIPLEOCCURENCE = true;
    public static final int ORDER_DIGITS = 5;
    private Traverser traverser;
    private Indexer indexer;
    private Data lastInconsistent;
    private boolean widened;
    private boolean useReducing;
    private boolean reduced;
    private boolean splittened;
    private boolean fixedMultipleOccurence;
    private String foreignKeys;
    private boolean nested;
    private String asymmetric;

    public PostProcessor(Traverser traverser, Indexer indexer) {
        this.traverser = traverser;
        this.traverser.addListener(this);
        this.indexer = indexer;
        this.indexer.addListener(this);
        this.lastInconsistent = null;
        this.useReducing = false;
        this.foreignKeys = "";
        this.asymmetric = "";
    }

    public void setUseReducing(boolean useReducing) {
        this.useReducing = useReducing;
    }

    public boolean getUseReducing() {
        return this.useReducing;
    }

    public void setForeignKeys(String foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public String getForeignKeys() {
        return this.foreignKeys;
    }

    public void setAsymmetric(String asymmetric) {
        this.asymmetric = asymmetric;
    }

    public String getAsymmetric() {
        return this.asymmetric;
    }

    private Vector fingerprint(Data d) {
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < d.size()) {
            result.add(new Fingerprint(d.get(i)));
            ++i;
        }
        return result;
    }

    private Data findFirstInconsistent(String name) {
        if (this.lastInconsistent != null) {
            return this.lastInconsistent;
        }
        Data result = null;
        Vector preds = this.traverser.findAllPredicates(name);
        Vector fp = new ProperVector();
        ProperVector fp2 = new ProperVector();
        boolean match = true;
        int i = 0;
        while (i < preds.size()) {
            Data d = (Data)preds.get(i);
            if (i == 0) {
                fp = this.fingerprint(d);
            } else {
                match = fp.equals(this.fingerprint(d));
            }
            if (!match) {
                result = d;
                break;
            }
            ++i;
        }
        this.lastInconsistent = result;
        return result;
    }

    private boolean isConsistent(String name, boolean output) {
        boolean result;
        Data d = this.findFirstInconsistent(name);
        boolean bl = result = d == null;
        if (!result && output) {
            Vector preds = this.traverser.findAllPredicates(name);
            this.println("Offending predicate: " + d + "\n" + "   with fingerprint: " + this.fingerprint(d) + "\n" + "   instead of      : " + this.fingerprint((Data)preds.get(0)));
        }
        return result;
    }

    private boolean canFixInconsistent(String name) {
        boolean result;
        Vector preds = this.traverser.findAllPredicates(name);
        Data d1 = (Data)preds.get(0);
        Data d2 = this.findFirstInconsistent(name);
        Vector arg1 = this.fingerprint(d1);
        Vector arg2 = this.fingerprint(d2);
        boolean bl = result = arg1.size() == arg2.size();
        if (result) {
            int i = 0;
            while (i < arg1.size()) {
                if (!arg1.get(i).equals(arg2.get(i)) && (arg1.get(i).toString().endsWith(".List") || arg1.get(i).toString().endsWith(".Predicate") || arg2.get(i).toString().endsWith(".List") || arg2.get(i).toString().endsWith(".Predicate"))) {
                    result = false;
                }
                if (!result) break;
                ++i;
            }
        }
        return result;
    }

    private void fixInconsistent(String name) {
        Vector preds = this.traverser.findAllPredicates(name);
        Data d1 = (Data)preds.get(0);
        Data d2 = this.findFirstInconsistent(name);
        this.lastInconsistent = null;
        Vector arg1 = this.fingerprint(d1);
        Vector arg2 = this.fingerprint(d2);
        int i = 0;
        while (i < arg1.size()) {
            if (!arg1.get(i).equals(arg2.get(i))) {
                String className = Fingerprint.getSuperClass((Fingerprint)arg1.get(i), (Fingerprint)arg2.get(i));
                boolean finished = false;
                while (!finished) {
                    boolean castError = false;
                    int index = 0;
                    Predicate p = (Predicate)preds.get(0);
                    int n = 0;
                    while (n < preds.size()) {
                        block12: {
                            p = (Predicate)preds.get(n);
                            try {
                                if (p.get(i).toString().equals("NULL")) break block12;
                                if (className.equals("java.lang.Integer")) {
                                    p.getData().set(i, new Integer(p.get(i).toString()));
                                } else if (className.equals("java.lang.Long")) {
                                    p.getData().set(i, new Long(p.get(i).toString()));
                                } else if (className.equals("java.lang.Double")) {
                                    p.getData().set(i, new Double(p.get(i).toString()));
                                } else {
                                    p.getData().set(i, p.get(i).toString());
                                }
                            }
                            catch (Exception e) {
                                castError = true;
                                index = i;
                                break;
                            }
                        }
                        ++n;
                    }
                    boolean bl = finished = !castError || className.equals("java.lang.String");
                    if (!castError) continue;
                    className = p.get(index).getClass().getName();
                }
            }
            ++i;
        }
    }

    private int discardInconsistent(String name) {
        Integer count;
        String finger;
        Predicate p;
        int result = 0;
        Vector preds = this.traverser.findAllPredicates(name);
        Hashtable<String, Integer> occurrences = new Hashtable<String, Integer>();
        int i = 0;
        while (i < preds.size()) {
            p = (Predicate)preds.get(i);
            finger = this.fingerprint(p).toString();
            count = !occurrences.containsKey(finger) ? new Integer(0) : (Integer)occurrences.get(finger);
            count = new Integer(count + 1);
            occurrences.put(finger, count);
            ++i;
        }
        finger = "";
        count = new Integer(-1);
        Enumeration enm = occurrences.keys();
        while (enm.hasMoreElements()) {
            String finger2 = (String)enm.nextElement();
            Integer count2 = (Integer)occurrences.get(finger2);
            if (count2 <= count) continue;
            finger = finger2;
            count = new Integer(count2);
        }
        if (finger.equals("")) {
            return result;
        }
        i = 0;
        while (i < preds.size()) {
            p = (Predicate)preds.get(i);
            if (!finger.equals(this.fingerprint(p).toString())) {
                ++result;
                this.traverser.remove(p);
                this.lastInconsistent = null;
            }
            ++i;
        }
        return result;
    }

    private void optimizeList(String name) {
        int n;
        Data d;
        Vector lists = this.traverser.findAllLists(name);
        int len = -1;
        boolean lenOK = true;
        boolean predFound = false;
        int i = 0;
        while (i < lists.size()) {
            d = (Data)lists.get(i);
            if (len != d.size()) {
                if (len == -1) {
                    len = d.size();
                } else {
                    lenOK = false;
                }
            }
            n = 0;
            while (n < d.size()) {
                if (d.get(n) instanceof Predicate) {
                    predFound = true;
                    break;
                }
                ++n;
            }
            if (!lenOK || predFound) break;
            ++i;
        }
        if (!lenOK || predFound) {
            return;
        }
        this.reduced = true;
        i = 0;
        while (i < lists.size()) {
            d = (Data)lists.get(i);
            Data p = d.getParent();
            int index = d.getParentIndex();
            p.remove(index);
            n = 0;
            while (n < d.size()) {
                p.add(index + n, d.get(n));
                ++n;
            }
            ++i;
        }
        if (this.getVerbose()) {
            this.println("List '" + name + "' reduced.");
        }
    }

    private String getType(Object o, int index) {
        String result = o == null ? "NULL" : (o instanceof Predicate ? ((Predicate)o).getName() : (o instanceof List ? "proper.imp.List" : "java.lang.String"));
        if (index > -1) {
            long order = StrictMath.round(StrictMath.pow(10.0, 4.0));
            result = String.valueOf(Long.toString(order + (long)index)) + result;
        }
        return result;
    }

    private void widenPredicate(String name) {
        String type;
        int n;
        Predicate p;
        Vector preds = this.traverser.findAllPredicates(name);
        ProperVector argList = new ProperVector();
        int i = 0;
        while (i < preds.size()) {
            p = (Predicate)preds.get(i);
            n = 0;
            while (n < p.size()) {
                type = this.getType(p.get(n), n);
                if (!argList.contains(type)) {
                    argList.add(type);
                }
                ++n;
            }
            ++i;
        }
        Collections.sort(argList);
        i = 0;
        while (i < argList.size()) {
            type = (String)argList.get(i);
            argList.set(i, type.substring(5, type.length()));
            ++i;
        }
        p = (Predicate)preds.get(0);
        if (argList.size() == p.size()) {
            return;
        }
        this.println("Widening necessary!");
        this.widened = true;
        if (this.getVerbose()) {
            this.println(argList);
        }
        i = 0;
        while (i < preds.size()) {
            p = (Predicate)preds.get(i);
            if (p.size() != argList.size()) {
                if (this.getVerbose()) {
                    this.print(p);
                }
                n = 0;
                while (n < argList.size()) {
                    type = this.getType(p.get(n), -1);
                    if (!type.equals(argList.get(n))) {
                        p.add(n, "NULL");
                    }
                    ++n;
                }
                if (this.getVerbose()) {
                    this.println(" -> " + p);
                }
            }
            ++i;
        }
    }

    private void flattenLists() {
        this.flattenLists(this.indexer.getListsWithIndex());
    }

    private void flattenLists(Vector names) {
        boolean finished = false;
        while (!finished) {
            if (names.size() == 0) {
                finished = true;
                continue;
            }
            int i = 0;
            while (i < names.size()) {
                String name = (String)names.get(i);
                Vector lists = this.traverser.findAllLists(name);
                if (lists.size() == 0) {
                    names.remove(i);
                    continue;
                }
                this.println("Flattening list " + name + "...");
                int n = 0;
                while (n < lists.size()) {
                    List l = (List)lists.get(n);
                    int index = l.getParentIndex();
                    if (l.getParent() instanceof Predicate) {
                        Predicate p = (Predicate)l.getParent();
                        try {
                            int m = 0;
                            while (m < l.size()) {
                                if (m > 0) {
                                    p = (Predicate)p.clone();
                                }
                                p.remove(index);
                                p.add(index, l.get(m));
                                if (m > 0) {
                                    this.traverser.add(p);
                                }
                                ++m;
                            }
                        }
                        catch (Exception e) {
                            this.println(e);
                        }
                    }
                    ++n;
                }
                ++i;
            }
            this.traverser.shuffleIDs();
            this.traverser.invalidate();
        }
    }

    private void splitPredicate(String name) {
        this.splitPredicate(name, this.indexer.getIndexes(name), true);
    }

    private void splitPredicate(String name, Vector indexes, boolean updateIndexer) {
        int m;
        this.println("Splitting " + name + " at " + indexes + "...");
        this.splittened = true;
        Vector preds = this.traverser.findAllPredicates(name);
        ProperVector predsNew = new ProperVector();
        RandomID randID = new RandomID(preds.size());
        boolean isAsymmetric = new Includer(this.getAsymmetric()).contains(name);
        String indexStr = "";
        int i = 0;
        while (i < preds.size()) {
            int index;
            Predicate pNew;
            int n;
            Predicate p = (Predicate)preds.get(i);
            Integer id = (Integer)randID.nextElement();
            if (!isAsymmetric) {
                n = 0;
                while (n < indexes.size()) {
                    pNew = new Predicate(name, 0);
                    pNew.setClassLabelAdded(p.getClassLabelAdded());
                    m = 0;
                    while (m < p.size()) {
                        if (updateIndexer) {
                            if (!this.indexer.isIndex(p, m)) {
                                pNew.add(p.get(m));
                            }
                        } else if (!indexes.contains(Integer.toString(m))) {
                            pNew.add(p.get(m));
                        }
                        ++m;
                    }
                    index = pNew.size();
                    if (pNew.getClassLabelAdded()) {
                        --index;
                    }
                    this.indexer.addSplitIndexId(p, index);
                    pNew.add(index, id);
                    index = pNew.size();
                    if (pNew.getClassLabelAdded()) {
                        --index;
                    }
                    pNew.add(index, p.get(this.indexer.getIndex(p, (String)indexes.get(n))));
                    predsNew.add(pNew);
                    ++n;
                }
            } else {
                Predicate pParent = new Predicate(name, 0);
                pParent.add(p.get(p.size() - 1));
                predsNew.add(pParent);
                n = 0;
                while (n < indexes.size()) {
                    pNew = new Predicate(String.valueOf(name) + Integer.toString(n), 0);
                    pParent.add(pParent.size() - 1, pNew);
                    m = 0;
                    while (m < p.size() - 1) {
                        if (updateIndexer) {
                            if (!this.indexer.isIndex(p, m)) {
                                pNew.add(p.get(m));
                            }
                        } else if (!indexes.contains(Integer.toString(m))) {
                            pNew.add(p.get(m));
                        }
                        ++m;
                    }
                    index = pNew.size();
                    pNew.add(index, p.get(this.indexer.getIndex(p, (String)indexes.get(n))));
                    if (i == 0 && updateIndexer) {
                        if (!indexStr.equals("")) {
                            indexStr = String.valueOf(indexStr) + ",";
                        }
                        indexStr = String.valueOf(indexStr) + pNew.getName() + ":last";
                    }
                    ++n;
                }
            }
            ++i;
        }
        if (updateIndexer) {
            Vector names;
            if (!isAsymmetric) {
                indexStr = "";
                names = this.indexer.getIndexNames();
                m = 0;
                while (m < names.size()) {
                    if (!indexStr.equals("") && !indexStr.endsWith(",")) {
                        indexStr = String.valueOf(indexStr) + ",";
                    }
                    indexStr = names.get(m).equals(name) ? String.valueOf(indexStr) + name + ":last" : String.valueOf(indexStr) + this.indexer.getProcessedIndexes((String)names.get(m));
                    ++m;
                }
                this.indexer.setIndexes(indexStr);
            } else {
                names = this.indexer.getIndexNames();
                m = 0;
                while (m < names.size()) {
                    if (!indexStr.equals("") && !indexStr.endsWith(",")) {
                        indexStr = String.valueOf(indexStr) + ",";
                    }
                    if (!names.get(m).equals(name)) {
                        indexStr = String.valueOf(indexStr) + this.indexer.getProcessedIndexes((String)names.get(m));
                    }
                    ++m;
                }
                this.indexer.setIndexes(indexStr);
            }
        }
        i = 0;
        while (i < preds.size()) {
            this.traverser.remove((Data)preds.get(i));
            ++i;
        }
        i = 0;
        while (i < predsNew.size()) {
            this.traverser.add((Predicate)predsNew.get(i));
            ++i;
        }
    }

    private void processForeignKeys() {
        Predicate p2;
        int n;
        Predicate p1;
        String name1;
        this.nested = true;
        Vector relations = Strings.fromCommalistVector(this.getForeignKeys());
        ProperVector names = new ProperVector();
        ProperVector flatten = new ProperVector();
        int i = 0;
        while (i < relations.size()) {
            String[] relation;
            if (this.getVerbose()) {
                this.println(relations.get(i));
            }
            if ((relation = Strings.breakUp((String)relations.get(i), "=")).length != 2) {
                this.println("Wrong Foreign Key Relation: " + relations.get(i));
            } else {
                name1 = Strings.breakUp(relation[0], ":")[0];
                int index1 = this.indexer.getIndex(this.traverser.findFirstPredicate(name1), Strings.breakUp(relation[0], ":")[1]);
                Vector preds1 = this.traverser.findAllPredicates(name1);
                String name2 = Strings.breakUp(relation[1], ":")[0];
                int index2 = this.indexer.getIndex(this.traverser.findFirstPredicate(name2), Strings.breakUp(relation[1], ":")[1]);
                Hashtable indexed2 = this.traverser.indexPredicate(name2, index2);
                if (preds1.size() != 0) {
                    p1 = (Predicate)preds1.get(0);
                    if (p1.get(index1) instanceof List) {
                        flatten.clear();
                        flatten.add(((List)p1.get(index1)).getName());
                        this.flattenLists(flatten);
                        preds1 = this.traverser.findAllPredicates(name1);
                    }
                    n = 0;
                    while (n < preds1.size()) {
                        p1 = (Predicate)preds1.get(n);
                        p2 = (Predicate)indexed2.get(p1.get(index1));
                        if (p2 == null) {
                            this.println(p1.get(index1) + " -> " + p2);
                        } else {
                            p2.setParent(p1);
                            p1.getData().set(index1, p2);
                        }
                        ++n;
                    }
                    if (!names.contains(name1)) {
                        names.add(name1);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < names.size()) {
            Counter counter = new Counter();
            p1 = this.traverser.findFirstPredicate((String)names.get(i));
            n = 0;
            while (n < p1.size()) {
                if (p1.get(n) instanceof Predicate) {
                    counter.inc(((Predicate)p1.get(n)).getName());
                }
                ++n;
            }
            Enumeration enm = counter.ids();
            while (enm.hasMoreElements()) {
                name1 = (String)enm.nextElement();
                if (counter.get(name1) <= 1) continue;
                ProperVector indexes = new ProperVector();
                n = 0;
                while (n < p1.size()) {
                    if (p1.get(n) instanceof Predicate && (p2 = (Predicate)p1.get(n)).getName().equals(name1)) {
                        indexes.add(Integer.toString(n));
                    }
                    ++n;
                }
                this.splitPredicate((String)names.get(i), indexes, false);
            }
            ++i;
        }
    }

    private void fixMultipleOccurence() {
        Vector names = this.traverser.getPredicates();
        HashSet<String> parents = new HashSet<String>();
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            Data d = this.traverser.findFirst(name);
            if (d.hasParent()) {
                Predicate p;
                parents.clear();
                Vector preds = this.traverser.findAllPredicates(name);
                int n = 0;
                while (n < preds.size()) {
                    p = (Predicate)preds.get(n);
                    if (p.hasParent()) {
                        parents.add(p.getParent().getName());
                    }
                    ++n;
                }
                if (parents.size() > 1) {
                    this.fixedMultipleOccurence = true;
                    this.println(String.valueOf(name) + ": multiple occurence (" + parents.size() + ")! fixing...");
                    n = 0;
                    while (n < preds.size()) {
                        p = (Predicate)preds.get(n);
                        if (p.hasParent()) {
                            p.setName(String.valueOf(p.getName()) + "_" + p.getParent().getName());
                        }
                        ++n;
                    }
                }
            }
            ++i;
        }
        if (this.fixedMultipleOccurence) {
            this.traverser.invalidate();
        }
    }

    public Traverser process() {
        Vector names = this.traverser.getAll();
        this.widened = false;
        this.reduced = false;
        this.splittened = false;
        this.nested = false;
        this.fixedMultipleOccurence = false;
        if (!this.getForeignKeys().equals("")) {
            this.processForeignKeys();
        }
        this.flattenLists();
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            this.println("Checking " + name + "...");
            boolean isPredicate = this.traverser.isPredicate(name);
            if (isPredicate && this.indexer.getIndexCount(name) > 1) {
                this.splitPredicate(name);
            }
            if (isPredicate) {
                this.fixMultipleOccurence();
            }
            if (this.getUseReducing() && !isPredicate) {
                this.optimizeList(name);
            }
            if (isPredicate) {
                this.widenPredicate(name);
            }
            if (isPredicate && !this.isConsistent(name, false)) {
                if (this.canFixInconsistent(name)) {
                    this.println("Inconsistent - trying to fix...");
                    do {
                        this.fixInconsistent(name);
                        this.println("Fixing...");
                        System.gc();
                    } while (!this.isConsistent(name, false));
                } else {
                    this.isConsistent(name, true);
                    int count = this.discardInconsistent(name);
                    this.println("Inconsistent - " + count + " instances discarded!");
                }
            }
            ++i;
        }
        if (this.nested || this.widened || this.reduced || this.splittened) {
            this.traverser.invalidate();
        }
        if (this.splittened) {
            this.traverser.shuffleIDs();
        }
        return this.traverser;
    }

    @Override
    public String toString() {
        return this.traverser.toString();
    }
}

