/*
 * Decompiled with CFR 0.152.
 */
package main;

import data.catalog.CatalogFile;
import data.instance.Instances;
import eval.CrossValidation;
import eval.Evaluation;
import eval.SimpleEvaluation;
import java.io.File;
import java.util.Arrays;
import model.Model;
import model.ModelOptions;
import model.reframe.RRS;
import model.reframe.RSHC;
import model.reframe.Reframer;
import model.tree.DecisionTree;
import model.tree.RandomForest;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import util.FileWrite;
import util.GlobalRandom;
import util.Logging;

public class CARAF {
    public static void main(String[] args) throws Exception {
        Options gopts = CARAF.setupOptions();
        String sourceDirectory = String.valueOf(new File(".").getAbsolutePath()) + "/";
        String fileName = new String();
        String baseDirectory = new String();
        String ifname = args[0];
        fileName = ifname.charAt(0) == '/' ? ifname : String.valueOf(sourceDirectory) + ifname;
        baseDirectory = String.valueOf(new File(fileName).getParent()) + "/";
        Logging.setupLogging(baseDirectory, "info");
        FileWrite.setFileWrite(baseDirectory);
        String[] targs = Arrays.copyOfRange(args, 1, args.length);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(gopts, targs);
        Logging.main.info((Object)("CARAF starts with args: " + Arrays.toString(args)));
        String fileNameFct = fileName;
        String fileNamePrd = fileName;
        if (cmd.hasOption("p")) {
            String ifnamePrd = cmd.getOptionValue("p");
            fileNamePrd = ifnamePrd.charAt(0) == '/' ? ifnamePrd : String.valueOf(sourceDirectory) + ifnamePrd;
        } else if (fileNameFct.endsWith(".fct")) {
            fileNamePrd = String.valueOf(fileNamePrd.substring(0, fileNamePrd.length() - 4)) + ".prd";
        } else {
            fileNameFct = String.valueOf(fileNameFct) + ".fct";
            fileNamePrd = String.valueOf(fileNamePrd) + ".prd";
        }
        if (!new File(fileNameFct).exists()) {
            Logging.main.info((Object)"CARAF fails! Fct file not found!");
            Logging.main.info((Object)("Tried to load Fct " + fileNameFct));
            Logging.main.info((Object)("Tried to load Prd " + fileNamePrd));
        } else if (!new File(fileNamePrd).exists()) {
            Logging.main.info((Object)"CARAF fails! Prd file not found!");
            Logging.main.info((Object)("Tried to load Prd " + fileNamePrd));
        } else if (!cmd.hasOption("ta")) {
            Logging.main.info((Object)"CARAF fails! No target predicate defined! Please use option 'ta'!");
            Logging.main.info((Object)("Tried to load Prd " + fileNamePrd));
        } else {
            ModelOptions opts = null;
            if (cmd.hasOption("s")) {
                GlobalRandom.init(new Long(cmd.getOptionValue("s")));
            } else {
                GlobalRandom.init();
            }
            opts = cmd.hasOption("o") ? ModelOptions.getOptions(fileNameFct) : new ModelOptions(cmd);
            CatalogFile cat = new CatalogFile();
            cat.fillCatalog(fileNamePrd, fileNameFct);
            cat.setClassInstances(opts.classPredicate);
            cat.setFunctions(opts.aggFunctions);
            Model mod = null;
            if (cmd.hasOption("m")) {
                mod = Model.fromXML(new File(cmd.getOptionValue("m")), opts, cat);
            } else if (opts.treesInForest > 1) {
                if (!cmd.hasOption("n")) {
                    opts.name = "model";
                }
                mod = new RandomForest(opts);
            } else {
                if (!cmd.hasOption("n")) {
                    opts.name = "model";
                }
                mod = new DecisionTree(opts);
            }
            if (cmd.hasOption("e") && cmd.getOptionValues("e")[0].equals("cv")) {
                Logging.main.info((Object)(String.valueOf(opts.crossValidation) + "-fold cross-validation starts."));
                CrossValidation eval = new CrossValidation(opts.mode, opts.crossValidation, GlobalRandom.instance());
                ((Evaluation)eval).evaluateModel(mod, cat.getClassInstances(), cat, true);
                Logging.main.info((Object)(String.valueOf(opts.crossValidation) + "-fold cross-validation finishes."));
            } else {
                if (!cmd.hasOption("m")) {
                    Logging.main.info((Object)"Model learning starts.");
                    long t1 = System.currentTimeMillis();
                    mod.build(cat.getClassInstances(), cat);
                    long t2 = System.currentTimeMillis();
                    FileWrite.writeToFile(String.valueOf(mod.name()) + "_runtime", String.valueOf(mod.name()) + " training : " + (t2 - t1) + "\n");
                    Logging.main.info((Object)"Model learning finishes.");
                }
                if (cmd.hasOption("r")) {
                    String fileNameReframe = new String();
                    String fnr = cmd.getOptionValues("r")[1];
                    fileNameReframe = fnr.charAt(0) == '/' ? fnr : String.valueOf(sourceDirectory) + fnr;
                    CatalogFile catReframe = new CatalogFile();
                    catReframe.fillCatalog(fileNamePrd, fileNameReframe);
                    catReframe.setClassInstances(opts.classPredicate);
                    catReframe.setFunctions(opts.aggFunctions);
                    Instances reframe = catReframe.getClassInstances();
                    Reframer refr = null;
                    if (cmd.getOptionValues("r")[0].equals("rrs")) {
                        refr = new RRS(mod, opts);
                    } else if (cmd.getOptionValues("r")[0].equals("rshc")) {
                        refr = new RSHC(mod, opts);
                    }
                    Logging.main.info((Object)"Model reframing starts.");
                    long t1 = System.currentTimeMillis();
                    ((Reframer)refr).reframe(reframe, catReframe);
                    long t2 = System.currentTimeMillis();
                    FileWrite.writeToFile(String.valueOf(mod.name()) + "_runtime", String.valueOf(mod.name()) + " reframing : " + (t2 - t1) + "\n");
                    Logging.main.info((Object)"Model reframing finishes.");
                }
                if (cmd.hasOption("e") && cmd.getOptionValues("e")[0].equals("test")) {
                    String fileNameTest = new String();
                    String fname = cmd.getOptionValues("e")[1];
                    fileNameTest = fname.charAt(0) == '/' ? fname : String.valueOf(sourceDirectory) + fname;
                    Logging.main.info((Object)"Model evaluation on test set starts.");
                    CatalogFile catTest = new CatalogFile();
                    catTest.fillCatalog(fileNamePrd, fileNameTest);
                    catTest.setClassInstances(opts.classPredicate);
                    catTest.setFunctions(opts.aggFunctions);
                    SimpleEvaluation eval = new SimpleEvaluation(opts.mode);
                    ((Evaluation)eval).evaluateModel(mod, catTest.getClassInstances(), catTest, true);
                    Logging.main.info((Object)"Model evaluation on test set finishes.");
                } else {
                    Logging.main.info((Object)"Model evaluation on training set starts.");
                    SimpleEvaluation eval = new SimpleEvaluation(opts.mode);
                    ((Evaluation)eval).evaluateModel(mod, cat.getClassInstances(), cat, true);
                    Logging.main.info((Object)"Model evaluation on training set finishes.");
                }
            }
            Logging.main.info((Object)"CARAF finishes successfully!");
        }
    }

    public static Options setupOptions() {
        Options opts = new Options();
        Option prd = new Option("p", "prd", true, "path to prd file");
        Option seed = new Option("s", "seed", true, "seed to use to initialize random number generator");
        Option tObj = Option.builder((String)"to").longOpt("target-object").desc("object to perform prediction on").hasArg().build();
        Option tAttr = Option.builder((String)"ta").longOpt("target-attr").desc("attribute of target object to perform prediction on").hasArg().build();
        Option name = new Option("n", "name", true, "name of the model (default \"tree\"");
        Option forest = new Option("f", "forest", true, "use random forest with <f> trees instead of a single decision tree (default 1, use decision tree)");
        Option leaf = new Option("l", "leaf", true, "minimum number of instances in a leaf of a tree (default 1)");
        Option heur = new Option("h", "heuristic", true, "heuristic to use to generate complex aggregates (rrhcca, random, or global)");
        Option reframe = Option.builder((String)"r").longOpt("reframe").desc("reframing method used to adapt the model (rrs or rshc), and examples set to use for reframing").numberOfArgs(2).build();
        Option eval = Option.builder((String)"e").longOpt("eval").desc("evaluation method (cv or test), and, if cv, number of folds, if test, path to the separate test set").numberOfArgs(2).build();
        Option aggFuncs = Option.builder((String)"a").longOpt("agg").desc("aggregation functions to use, among (count, min, max, sum, mean, std, ratio, median, quartile1, quartile3, interquartile, decile1, decile9)").hasArgs().valueSeparator(',').build();
        Option opt = new Option("o", "opt", false, "is there an option file?");
        Option mod = new Option("m", "model", true, "xml file describing the model to use");
        opts.addOption(prd);
        opts.addOption(seed);
        opts.addOption(tObj);
        opts.addOption(tAttr);
        opts.addOption(eval);
        opts.addOption(name);
        opts.addOption(forest);
        opts.addOption(leaf);
        opts.addOption(heur);
        opts.addOption(aggFuncs);
        opts.addOption(reframe);
        opts.addOption(opt);
        opts.addOption(mod);
        return opts;
    }
}

