/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.catalog.CatalogFile;
import eval.Evaluation;
import eval.SimpleEvaluation;
import java.io.File;
import java.io.IOException;
import model.ModelOptions;
import model.tree.DecisionTree;

public class ReframableTree {
    public DecisionTree dt;

    public void build(String path) throws IOException, CloneNotSupportedException {
        String sourceDirectory = String.valueOf(new File(".").getAbsolutePath()) + "/";
        String fileName = new String();
        fileName = path.charAt(0) == '/' ? path : String.valueOf(sourceDirectory) + path;
        ModelOptions opt = ModelOptions.getOptions(fileName);
        CatalogFile cat = new CatalogFile();
        cat.fillCatalog(String.valueOf(fileName) + ".prd", String.valueOf(fileName) + ".fct");
        cat.setClassInstances(opt.classPredicate);
        cat.setFunctions(opt.aggFunctions);
        this.dt = new DecisionTree(opt);
        this.dt.build(cat.getClassInstances(), cat);
        System.out.println(this.dt.toString());
    }

    public void reframe(String path) throws IOException {
        String sourceDirectory = String.valueOf(new File(".").getAbsolutePath()) + "/";
        String fileName = new String();
        fileName = path.charAt(0) == '/' ? path : String.valueOf(sourceDirectory) + path;
        ModelOptions opt = ModelOptions.getOptions(fileName);
        CatalogFile cat = new CatalogFile();
        cat.fillCatalog(String.valueOf(fileName) + ".prd", String.valueOf(fileName) + ".fct");
        cat.setClassInstances(opt.classPredicate);
        cat.setFunctions(opt.aggFunctions);
    }

    public Evaluation test(String path) throws IOException, CloneNotSupportedException {
        String sourceDirectory = String.valueOf(new File(".").getAbsolutePath()) + "/";
        String fileName = new String();
        fileName = path.charAt(0) == '/' ? path : String.valueOf(sourceDirectory) + path;
        ModelOptions opt = ModelOptions.getOptions(fileName);
        CatalogFile cat = new CatalogFile();
        cat.fillCatalog(String.valueOf(fileName) + ".prd", String.valueOf(fileName) + ".fct");
        cat.setClassInstances(opt.classPredicate);
        cat.setFunctions(opt.aggFunctions);
        SimpleEvaluation eval = new SimpleEvaluation(opt.mode);
        ((Evaluation)eval).evaluateModel(this.dt, cat.getClassInstances(), cat, true);
        return eval;
    }

    public String toString() {
        return this.dt.toString();
    }
}

