/*
 * Decompiled with CFR 0.152.
 */
package model.tree;

import data.catalog.Catalog;
import data.feature.AggregateFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import model.NodeSplit;
import model.distribution.Distribution;
import model.inference.ConditionApplication;
import model.inference.hc.AggregateBase;
import model.tree.AggregatePrototype;
import model.tree.Node;
import org.jdom2.Content;
import org.jdom2.Element;
import util.Couple;

public class InternalNode
extends Node {
    private Node left;
    private Node right;
    private Node noValue;
    private NodeSplit split;

    public InternalNode(NodeSplit spl, Node l, Node r, Node n, Distribution distr, int d) {
        this.split = spl;
        this.left = l;
        this.right = r;
        this.noValue = n;
        this.distribution = distr;
        this.depth = d;
    }

    public InternalNode(Element rootEl, Catalog cat, int d) {
        this(new NodeSplit(rootEl.getChild("split"), cat), Node.fromXML((Element)rootEl.getChild("left").getChildren().get(0), cat, d + 1), Node.fromXML((Element)rootEl.getChild("right").getChildren().get(0), cat, d + 1), Node.fromXML((Element)rootEl.getChild("noval").getChildren().get(0), cat, d + 1), Distribution.fromXML(rootEl.getChild("distribution")), d);
        this.createFiliation();
    }

    public void createFiliation() {
        this.left.setParent(this);
        this.right.setParent(this);
        this.noValue.setParent(this);
    }

    @Override
    public Value classify(Instance id, Catalog cat) {
        ConditionApplication appl = this.split.apply(id, cat);
        switch (appl) {
            case SUCCESS: {
                return this.left.classify(id, cat);
            }
            case FAILURE: {
                return this.right.classify(id, cat);
            }
            case UNAPPLICABLE: {
                return this.noValue.classify(id, cat);
            }
        }
        return null;
    }

    @Override
    public HashSet<Value> classifyMajority(Instance id, Catalog cat) {
        ConditionApplication appl = this.split.apply(id, cat);
        switch (appl) {
            case SUCCESS: {
                return this.left.classifyMajority(id, cat);
            }
            case FAILURE: {
                return this.right.classifyMajority(id, cat);
            }
            case UNAPPLICABLE: {
                return this.noValue.classifyMajority(id, cat);
            }
        }
        return null;
    }

    @Override
    protected String toStringRec(int t) {
        String res = "";
        int i = 0;
        while (i < t) {
            res = String.valueOf(res) + "\t";
            ++i;
        }
        res = String.valueOf(res) + this.split.getSplitCondition().toString() + "\n";
        res = String.valueOf(res) + this.left.toStringRec(t + 1);
        res = String.valueOf(res) + this.right.toStringRec(t + 1);
        res = String.valueOf(res) + this.noValue.toStringRec(t + 1);
        return res;
    }

    @Override
    public HashMap<AggregatePrototype, ArrayList<Double>> getAllFeatures(ArrayList<SimpleFeature> sfs) {
        HashMap<AggregatePrototype, ArrayList<Double>> res = new HashMap<AggregatePrototype, ArrayList<Double>>();
        if (this.split.getSplitCondition().getFeature() instanceof AggregateFeature) {
            AggregateFeature aggFeat = (AggregateFeature)this.split.getSplitCondition().getFeature();
            ArrayList sfsCond = new ArrayList(aggFeat.getLastSelection().getFilters().stream().map(ff -> (SimpleFeature)ff.getFeature()).collect(Collectors.toList()));
            AggregatePrototype aggPro = new AggregatePrototype(new AggregateBase(aggFeat.getAggregateFunction(), aggFeat.getLastSelection().getSelection(), aggFeat.getFeature()), new HashSet<SimpleFeature>(sfsCond));
            res.put(aggPro, new ArrayList());
            res.get(aggPro).add(this.split.getScore());
        }
        HashMap<AggregatePrototype, ArrayList<Double>> l = this.left.getAllFeatures(sfs);
        for (AggregatePrototype aggp : l.keySet()) {
            if (!res.containsKey(aggp)) {
                res.put(aggp, new ArrayList());
            }
            ((ArrayList)res.get(aggp)).addAll((Collection)l.get(aggp));
        }
        HashMap<AggregatePrototype, ArrayList<Double>> r = this.right.getAllFeatures(sfs);
        for (AggregatePrototype aggp : r.keySet()) {
            if (!res.containsKey(aggp)) {
                res.put(aggp, new ArrayList());
            }
            ((ArrayList)res.get(aggp)).addAll((Collection)r.get(aggp));
        }
        HashMap<AggregatePrototype, ArrayList<Double>> n = this.noValue.getAllFeatures(sfs);
        for (AggregatePrototype aggp : n.keySet()) {
            if (!res.containsKey(aggp)) {
                res.put(aggp, new ArrayList());
            }
            res.get(aggp).addAll((Collection<Double>)n.get(aggp));
        }
        return res;
    }

    @Override
    public HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>> getBias() {
        HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>> res = new HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>>();
        if (this.split.getSplitCondition().getFeature() instanceof AggregateFeature) {
            double varScore = this.split.getScore();
            AggregateFeature aggFeat = (AggregateFeature)this.split.getSplitCondition().getFeature();
            AggregateBase ab = new AggregateBase(aggFeat.getAggregateFunction(), aggFeat.getLastSelection().getSelection(), aggFeat.getFeature());
            HashMap value = new HashMap();
            value.put(new HashSet(aggFeat.getLastSelection().getFilters().stream().map(ff -> (SimpleFeature)ff.getFeature()).collect(Collectors.toSet())), new Couple<Double, Long>(varScore, 1L));
            res.put(ab, value);
        }
        HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>> l = this.left.getBias();
        for (AggregateBase ab : l.keySet()) {
            if (res.containsKey(ab)) {
                HashMap valueIn = (HashMap)res.get(ab);
                HashMap<HashSet<SimpleFeature>, Couple<Double, Long>> valueToAdd = l.get(ab);
                for (Map.Entry<HashSet<SimpleFeature>, Couple<Double, Long>> ent : valueToAdd.entrySet()) {
                    if (valueIn.containsKey(ent.getKey())) {
                        valueIn.put(ent.getKey(), new Couple<Double, Long>((Double)((Couple)valueIn.get(ent.getKey())).getLeft() + ent.getValue().getLeft(), (Long)((Couple)valueIn.get(ent.getKey())).getRight() + ent.getValue().getRight()));
                        continue;
                    }
                    valueIn.put(ent.getKey(), ent.getValue());
                }
                continue;
            }
            res.put(ab, l.get(ab));
        }
        HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>> r = this.right.getBias();
        for (AggregateBase ab : r.keySet()) {
            if (res.containsKey(ab)) {
                HashMap valueIn = (HashMap)res.get(ab);
                HashMap<HashSet<SimpleFeature>, Couple<Double, Long>> valueToAdd = r.get(ab);
                for (Map.Entry<HashSet<SimpleFeature>, Couple<Double, Long>> ent : valueToAdd.entrySet()) {
                    if (valueIn.containsKey(ent.getKey())) {
                        valueIn.put(ent.getKey(), new Couple<Double, Long>((Double)((Couple)valueIn.get(ent.getKey())).getLeft() + ent.getValue().getLeft(), (Long)((Couple)valueIn.get(ent.getKey())).getRight() + ent.getValue().getRight()));
                        continue;
                    }
                    valueIn.put(ent.getKey(), ent.getValue());
                }
                continue;
            }
            res.put(ab, r.get(ab));
        }
        HashMap<AggregateBase, HashMap<HashSet<SimpleFeature>, Couple<Double, Long>>> no = this.noValue.getBias();
        for (AggregateBase ab : no.keySet()) {
            if (res.containsKey(ab)) {
                HashMap<HashSet<SimpleFeature>, Couple<Double, Long>> valueIn = res.get(ab);
                HashMap<HashSet<SimpleFeature>, Couple<Double, Long>> valueToAdd = no.get(ab);
                for (Map.Entry<HashSet<SimpleFeature>, Couple<Double, Long>> ent : valueToAdd.entrySet()) {
                    if (valueIn.containsKey(ent.getKey())) {
                        valueIn.put(ent.getKey(), new Couple<Double, Long>(valueIn.get(ent.getKey()).getLeft() + ent.getValue().getLeft(), valueIn.get(ent.getKey()).getRight() + ent.getValue().getRight()));
                        continue;
                    }
                    valueIn.put(ent.getKey(), ent.getValue());
                }
                continue;
            }
            res.put(ab, no.get(ab));
        }
        return res;
    }

    @Override
    public HashMap<Value, Double> classifyProbabilities(Instance inst, Catalog cat) {
        ConditionApplication appl = this.split.apply(inst, cat);
        switch (appl) {
            case SUCCESS: {
                return this.left.classifyProbabilities(inst, cat);
            }
            case FAILURE: {
                return this.right.classifyProbabilities(inst, cat);
            }
            case UNAPPLICABLE: {
                return this.noValue.classifyProbabilities(inst, cat);
            }
        }
        return null;
    }

    @Override
    public HashSet<SimpleFeature> getMainFeatures() {
        HashSet<SimpleFeature> res = new HashSet<SimpleFeature>();
        if (this.split.getSplitCondition().getFeature() instanceof SimpleFeature) {
            res.add((SimpleFeature)this.split.getSplitCondition().getFeature());
        }
        res.addAll(this.left.getMainFeatures());
        res.addAll(this.right.getMainFeatures());
        res.addAll(this.noValue.getMainFeatures());
        return res;
    }

    @Override
    public HashMap<AggregateBase, HashSet<SimpleFeature>> getComplexAggregates() {
        HashMap<AggregateBase, HashSet<SimpleFeature>> res = new HashMap<AggregateBase, HashSet<SimpleFeature>>();
        if (this.split.getSplitCondition().getFeature() instanceof AggregateFeature) {
            AggregateFeature aggFeat = (AggregateFeature)this.split.getSplitCondition().getFeature();
            ArrayList sfsCond = new ArrayList(aggFeat.getLastSelection().getFilters().stream().map(ff -> (SimpleFeature)ff.getFeature()).collect(Collectors.toList()));
            AggregateBase aggregateBase = new AggregateBase(aggFeat.getAggregateFunction(), aggFeat.getLastSelection().getSelection(), aggFeat.getFeature());
            res.put(aggregateBase, new HashSet());
            for (Object sf : sfsCond) {
                res.get(aggregateBase).add((SimpleFeature)sf);
            }
        }
        HashMap<AggregateBase, HashSet<SimpleFeature>> l = this.left.getComplexAggregates();
        for (AggregateBase ab : l.keySet()) {
            if (!res.containsKey(ab)) {
                res.put(ab, l.get(ab));
                continue;
            }
            ((HashSet)res.get(ab)).addAll((Collection)l.get(ab));
        }
        HashMap<AggregateBase, HashSet<SimpleFeature>> r = this.right.getComplexAggregates();
        for (AggregateBase aggregateBase : r.keySet()) {
            if (!res.containsKey(aggregateBase)) {
                res.put(aggregateBase, r.get(aggregateBase));
                continue;
            }
            ((HashSet)res.get(aggregateBase)).addAll((Collection)r.get(aggregateBase));
        }
        HashMap<AggregateBase, HashSet<SimpleFeature>> hashMap = this.noValue.getComplexAggregates();
        for (AggregateBase ab : hashMap.keySet()) {
            if (!res.containsKey(ab)) {
                res.put(ab, hashMap.get(ab));
                continue;
            }
            res.get(ab).addAll((Collection<SimpleFeature>)hashMap.get(ab));
        }
        return res;
    }

    @Override
    public HashMap<NumericShiftFunction, double[]> getShifts(Instances insts, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> shifts = new HashMap<NumericShiftFunction, double[]>();
        shifts.putAll(this.split.getSplitCondition().getShifts(new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList())), cat));
        Instances l = new Instances();
        Instances r = new Instances();
        Instances n = new Instances();
        for (Instance inst2 : insts) {
            ConditionApplication appl = this.split.apply(inst2, cat);
            switch (appl) {
                case SUCCESS: {
                    l.add(inst2);
                }
                case FAILURE: {
                    r.add(inst2);
                }
                case UNAPPLICABLE: {
                    n.add(inst2);
                }
            }
        }
        shifts.putAll(this.left.getShifts(l, cat));
        shifts.putAll(this.right.getShifts(r, cat));
        shifts.putAll(this.noValue.getShifts(n, cat));
        return shifts;
    }

    @Override
    public HashSet<NumericShiftFunction> getShifts() {
        HashSet<NumericShiftFunction> shifts = new HashSet<NumericShiftFunction>();
        shifts.addAll(this.split.getSplitCondition().getShifts());
        shifts.addAll(this.left.getShifts());
        shifts.addAll(this.right.getShifts());
        shifts.addAll(this.noValue.getShifts());
        return shifts;
    }

    @Override
    public void initShifts(Instances insts, Catalog cat) {
        this.split.initShifts(new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList())), cat);
        Instances l = new Instances();
        Instances r = new Instances();
        Instances n = new Instances();
        for (Instance inst2 : insts) {
            ConditionApplication appl = this.split.apply(inst2, cat);
            switch (appl) {
                case SUCCESS: {
                    l.add(inst2);
                }
                case FAILURE: {
                    r.add(inst2);
                }
                case UNAPPLICABLE: {
                    n.add(inst2);
                }
            }
        }
        this.left.initShifts(l, cat);
        this.right.initShifts(r, cat);
        this.noValue.initShifts(n, cat);
    }

    @Override
    public void deployShifts(Instances insts, Catalog cat) {
        this.split.deployShifts(new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList())), cat);
        Instances l = new Instances();
        Instances r = new Instances();
        Instances n = new Instances();
        for (Instance inst2 : insts) {
            ConditionApplication appl = this.split.apply(inst2, cat);
            switch (appl) {
                case SUCCESS: {
                    l.add(inst2);
                }
                case FAILURE: {
                    r.add(inst2);
                }
                case UNAPPLICABLE: {
                    n.add(inst2);
                }
            }
        }
        this.left.deployShifts(l, cat);
        this.right.deployShifts(r, cat);
        this.noValue.deployShifts(n, cat);
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("inode");
        el.addContent((Content)this.distribution.toXMLElement());
        el.addContent((Content)this.split.toXMLElement());
        Element leftEl = new Element("left");
        leftEl.addContent((Content)this.left.toXMLElement());
        el.addContent((Content)leftEl);
        Element rightEl = new Element("right");
        rightEl.addContent((Content)this.right.toXMLElement());
        el.addContent((Content)rightEl);
        Element novalEl = new Element("noval");
        novalEl.addContent((Content)this.noValue.toXMLElement());
        el.addContent((Content)novalEl);
        return el;
    }
}

