/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.table;

import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import proper.gui.core.table.JTableHelper;
import proper.gui.core.table.PropertyTableModel;
import proper.gui.core.table.TableSorter;

public class PropertyTable
extends JTable {
    private PropertyTableModel model;
    private TableSorter sorter;
    private boolean changed;

    public PropertyTable() {
        this(new String[][]{{"", ""}, {"", ""}});
    }

    public PropertyTable(Object[][] rowData) {
        super(rowData, new String[]{"Property", "Value"});
        this.setAutoResizeMode(0);
        this.setProperties(rowData);
        JTableHelper.setOptimalColumnWidth(this);
    }

    public boolean isChanged() {
        boolean result = false;
        if (this.getModel() instanceof TableSorter) {
            PropertyTableModel model = (PropertyTableModel)((TableSorter)this.getModel()).getModel();
            result = model.isChanged();
        }
        return result;
    }

    public void setChanged(boolean changed) {
        if (this.getModel() instanceof TableSorter) {
            PropertyTableModel model = (PropertyTableModel)((TableSorter)this.getModel()).getModel();
            model.setChanged(changed);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
        this.sorter.sortByColumn(0);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        this.sorter.sortByColumn(0);
    }

    public void setProperties(Object[][] values) {
        this.model = new PropertyTableModel(values);
        this.sorter = new TableSorter(this.model);
        this.sorter.addMouseListenerToHeaderInTable(this);
        this.sorter.sortByColumn(0);
        this.setModel(this.sorter);
    }

    public Object[][] getProperties() {
        Object[][] result = new Object[this.getModel().getRowCount()][2];
        int i = 0;
        while (i < result.length) {
            int n = 0;
            while (n < 2) {
                result[i][n] = ((TableSorter)this.getModel()).getModelValueAt(i, n);
                ++n;
            }
            ++i;
        }
        return result;
    }
}

