/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.text;

import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import proper.gui.core.text.ProperHighlightPainter;

public class JTextComponentHelper {
    private JTextComponent textComponent;

    public JTextComponentHelper(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    public void highlight(String pattern) {
        JTextComponentHelper.highlight(this.textComponent, pattern);
    }

    public static void highlight(JTextComponent textComp, String pattern) {
        JTextComponentHelper.removeHighlights(textComp);
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            int pos = 0;
            ProperHighlightPainter painter = new ProperHighlightPainter(textComp.getSelectionColor());
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                hilite.addHighlight(pos, pos + pattern.length(), painter);
                pos += pattern.length();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeHighlights() {
        JTextComponentHelper.removeHighlights(this.textComponent);
    }

    public static void removeHighlights(JTextComponent textComp) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        int i = 0;
        while (i < hilites.length) {
            if (hilites[i].getPainter() instanceof ProperHighlightPainter) {
                hilite.removeHighlight(hilites[i]);
            }
            ++i;
        }
    }
}

