/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import proper.database.Connector;
import proper.gui.core.dialog.DataBaseConnectDialog;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.dialog.ListDialog;
import proper.gui.core.dialog.MessageBox;
import proper.gui.core.event.ConnectorChangeEvent;
import proper.gui.core.event.ConnectorChangeListener;
import proper.gui.core.event.CurrentDirChangeEvent;
import proper.gui.core.event.CurrentDirChangeListener;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.io.SimpleFileFilter;
import proper.gui.core.text.ClassifierTextField;
import proper.gui.core.text.FileTextField;
import proper.gui.core.text.ProperTextField;
import proper.gui.core.util.SpringUtilities;
import proper.gui.experiment.BuilderPanel;
import proper.gui.experiment.BuilderParameter;
import proper.gui.experiment.BuilderProperties;
import proper.gui.experiment.BuilderSteps;
import proper.gui.experiment.BuilderTabPanel;
import proper.io.Loader;
import proper.util.ProperVector;
import proper.util.Strings;
import proper.util.Timestamp;
import proper.xml.Attribute;
import proper.xml.Comment;
import proper.xml.Document;
import proper.xml.Element;
import proper.xml.Path;

public class Builder
extends ChildFrame
implements ConnectorChangeListener,
CurrentDirChangeListener {
    private JTabbedPane tabbedPane;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenuItem menuFileNew;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileSave;
    private JMenuItem menuFileSaveAs;
    private JMenuItem menuFileExit;
    private JMenu menuDatabase;
    private JMenuItem menuDatabaseConnect;
    private JMenuItem menuDatabaseDisconnect;
    private JMenu menuExperiment;
    private JMenuItem menuExperimentCheck;
    private JMenuItem menuExperimentEnableLogs;
    private JMenuItem menuExperimentDisableLogs;
    private BuilderSteps panelSteps;
    private BuilderProperties panelProperties;
    private Vector panels;
    private String filename;
    private FileChooser fileChooser;
    private Connector conn;

    public Builder(ApplicationFrame parent) {
        super(parent, "Builder");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.filename = "";
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setFileFilter(new SimpleFileFilter("xml", "XML-Files"));
        this.panels = new ProperVector();
        try {
            this.conn = new Connector();
        }
        catch (Exception e) {
            this.println(e);
            this.conn = null;
        }
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setSize(this.getWidth(), 650);
        this.setCenteredLocation();
        this.getContentPane().setLayout(new BorderLayout());
        this.createTabs();
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFileNew = new JMenuItem("New", ImageLoader.getImageIcon("new.gif"));
        this.menuFileNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.menuFileOpen = new JMenuItem("Open...", ImageLoader.getImageIcon("open.gif"));
        this.menuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuFileSave = new JMenuItem("Save", ImageLoader.getImageIcon("save.gif"));
        this.menuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuFileSaveAs = new JMenuItem("Save As...", ImageLoader.getImageIcon("empty.gif"));
        this.menuFileSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.menuFileExit = new JMenuItem("Exit", ImageLoader.getImageIcon("forward.gif"));
        this.menuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.menuFileNew.addActionListener(this);
        this.menuFileOpen.addActionListener(this);
        this.menuFileSave.addActionListener(this);
        this.menuFileSaveAs.addActionListener(this);
        this.menuFileExit.addActionListener(this);
        this.menuFile.add(this.menuFileNew);
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.add(this.menuFileSave);
        this.menuFile.add(this.menuFileSaveAs);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuDatabase = new JMenu("Database");
        this.menuBar.add(this.menuDatabase);
        this.menuDatabaseConnect = new JMenuItem("Connect...", ImageLoader.getImageIcon("network.gif"));
        this.menuDatabaseDisconnect = new JMenuItem("Disconnect", ImageLoader.getImageIcon("stop2.gif"));
        this.menuDatabaseConnect.addActionListener(this);
        this.menuDatabaseDisconnect.addActionListener(this);
        this.menuDatabase.add(this.menuDatabaseConnect);
        this.menuDatabase.add(this.menuDatabaseDisconnect);
        this.menuExperiment = new JMenu("Experiment");
        this.menuBar.add(this.menuExperiment);
        this.menuExperimentCheck = new JMenuItem("Check", ImageLoader.getImageIcon("spellcheck.gif"));
        this.menuExperimentCheck.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.menuExperimentCheck.addActionListener(this);
        this.menuExperimentEnableLogs = new JMenuItem("Enable Log-Files", ImageLoader.getImageIcon("log.gif"));
        this.menuExperimentEnableLogs.addActionListener(this);
        this.menuExperimentDisableLogs = new JMenuItem("Disable Log-Files", ImageLoader.getImageIcon("empty.gif"));
        this.menuExperimentDisableLogs.addActionListener(this);
        this.menuExperiment.add(this.menuExperimentCheck);
        this.menuExperiment.addSeparator();
        this.menuExperiment.add(this.menuExperimentEnableLogs);
        this.menuExperiment.add(this.menuExperimentDisableLogs);
        this.newProject();
    }

    private void createSteps(Document doc) {
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//step");
        this.panelSteps = new BuilderSteps(this);
        int i = 0;
        while (i < nodes.size()) {
            Element node = (Element)nodes.get(i);
            ProperVector substeps = new ProperVector();
            int n = 0;
            while (n < node.getChildCount()) {
                Element subnode = (Element)node.getChildAt(n);
                substeps.add(subnode.getAttribute("name").getValue());
                ++n;
            }
            this.panelSteps.addStep(node.getAttribute("name").getValue(), substeps);
            ++i;
        }
        this.tabbedPane.addTab(this.panelSteps.getName(), this.panelSteps);
    }

    private void createProperties(Document doc) {
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//property");
        this.panelProperties = new BuilderProperties(this, "Properties");
        String[][] props = new String[nodes.size()][2];
        int i = 0;
        while (i < nodes.size()) {
            Element node = (Element)nodes.get(i);
            props[i][0] = node.getAttribute("name").getValue();
            props[i][1] = node.getAttribute("value").getValue();
            ++i;
        }
        this.panelProperties.setDefaultValues(props);
        this.tabbedPane.addTab(this.panelProperties.getName(), this.panelProperties);
    }

    private JComponent getInstance(String classname, String additional) {
        JComponent result = null;
        if (classname.equals("")) {
            return result;
        }
        try {
            Class<?> cls = Class.forName(classname);
            if (classname.endsWith("TextField") && !classname.endsWith(".JTextField")) {
                if (classname.endsWith(".DatabaseTextField")) {
                    Class[] clsArgs = new Class[]{ProperFrame.class, Integer.TYPE};
                    Object[] args = new Object[]{this, new Integer(additional)};
                    Constructor<?> constructor = cls.getConstructor(clsArgs);
                    result = (JComponent)constructor.newInstance(args);
                } else {
                    Class[] clsArgs = new Class[]{ProperFrame.class};
                    Object[] args = new Object[]{this};
                    Constructor<?> constructor = cls.getConstructor(clsArgs);
                    result = (JComponent)constructor.newInstance(args);
                }
                if (result instanceof ProperTextField) {
                    ((ProperTextField)result).setColumns(20);
                }
                if (result instanceof FileTextField) {
                    ((FileTextField)result).addCurrentDirChangeListener(this);
                }
            } else {
                String[] params;
                result = (JComponent)cls.newInstance();
                if (result instanceof JTextField) {
                    ((JTextField)result).setColumns(20);
                } else if (result instanceof JSpinner && (params = Strings.breakUp(additional, ",")).length == 3) {
                    SpinnerNumberModel numModel = (SpinnerNumberModel)((JSpinner)result).getModel();
                    numModel.setMinimum(new Integer(params[0]));
                    numModel.setMaximum(new Integer(params[1]));
                    numModel.setStepSize(new Integer(params[2]));
                }
            }
        }
        catch (Exception e) {
            this.println(e);
            result = null;
        }
        return result;
    }

    private JPanel createSingleStep(BuilderPanel panel, Vector fields) {
        JPanel result = new JPanel(new SpringLayout());
        Path path = new Path();
        int i = 0;
        while (i < fields.size()) {
            JComponent comp;
            Element field = (Element)fields.get(i);
            String name = field.getAttribute("name").getValue();
            String classname = field.getAttribute("classname").getValue();
            String additional = field.getAttribute("additional") != null ? field.getAttribute("additional").getValue() : "";
            boolean optional = field.getAttribute("optional").getValue().equals("yes");
            boolean use = field.getAttribute("checked").getValue().equals("yes");
            String tooltip = field.getAttribute("tooltip").getValue();
            if (tooltip.equals("")) {
                tooltip = null;
            }
            if ((comp = this.getInstance(classname, additional)) == null) {
                comp = new JLabel("unknown class: '" + classname + "'");
            }
            comp.setToolTipText(tooltip);
            JLabel label = new JLabel(field.getAttribute("label").getValue());
            label.setLabelFor(comp);
            label.setToolTipText(comp.getToolTipText());
            JComponent useComp = optional ? new JCheckBox("", use) : new JLabel();
            Vector values = path.get(field, ".//value");
            String value = "";
            if (values.size() > 0) {
                if (comp instanceof JComboBox) {
                    JComboBox combo = (JComboBox)comp;
                    combo.removeAllItems();
                    int n = 0;
                    while (n < values.size()) {
                        combo.addItem(((Element)values.get(n)).getContent());
                        ++n;
                    }
                } else {
                    value = ((Element)values.get(0)).getContent();
                    if (value == null) {
                        value = "";
                    }
                }
            }
            panel.addParameter(new BuilderParameter(comp, label.getText(), optional, useComp, use, value, name));
            result.add(useComp);
            result.add(label);
            result.add(comp);
            ++i;
        }
        SpringUtilities.makeCompactGrid(result, fields.size(), 3, 6, 6, 6, 6, false);
        return result;
    }

    private void setLinks(BuilderPanel panel, Vector fields) {
        int i = 0;
        while (i < fields.size()) {
            BuilderParameter linkto;
            Element node = (Element)fields.get(i);
            Attribute att = node.getAttribute("name");
            BuilderParameter source = panel.getParameter(att.getValue());
            att = node.getAttribute("link");
            if (att != null && (linkto = panel.getParameter(att.getValue())) != null && source.getComponent() instanceof ClassifierTextField) {
                ((ClassifierTextField)source.getComponent()).setParametersTextField((JTextField)linkto.getComponent());
            }
            ++i;
        }
    }

    private void createSingleSteps(Document doc) {
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//step");
        int i = 0;
        while (i < nodes.size()) {
            Element node = (Element)nodes.get(i);
            BuilderTabPanel tab = new BuilderTabPanel(this, node.getAttribute("name").getValue());
            this.tabbedPane.addTab(tab.getName(), new JScrollPane(tab));
            Vector subnodes = path.get(node, ".//substep");
            int n = 0;
            while (n < subnodes.size()) {
                Element subnode = (Element)subnodes.get(n);
                BuilderPanel panel = new BuilderPanel(this, String.valueOf(tab.getName()) + "/" + subnode.getAttribute("name").getValue());
                panel.setNeedsDatabase(subnode.getAttribute("database").getValue().equals("yes"));
                panel.setClassname(subnode.getAttribute("classname").getValue());
                String note = subnode.getAttribute("note") != null ? subnode.getAttribute("note").getValue() : "";
                panel.setNote(note);
                tab.getTabbedPane().addTab(subnode.getAttribute("name").getValue(), panel);
                Vector fields = path.get(subnode, ".//parameter");
                panel.add((Component)this.createSingleStep(panel, fields), "North");
                this.setLinks(panel, fields);
                ++n;
            }
            ++i;
        }
    }

    private void createTabs() {
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        Document doc = new Document();
        doc.read(Loader.getReader("/proper/gui/experiment/", "builder.xml"));
        this.createSteps(doc);
        this.createProperties(doc);
        this.createSingleSteps(doc);
        this.retrieveProperties(doc);
        this.updateConnector();
    }

    public BuilderSteps getSteps() {
        return this.panelSteps;
    }

    public void addPanel(BuilderPanel panel) {
        this.panels.add(panel);
    }

    public BuilderPanel getPanel(String name) {
        name = name.toLowerCase();
        BuilderPanel result = null;
        int i = 0;
        while (i < this.panels.size()) {
            BuilderPanel panel = (BuilderPanel)this.panels.get(i);
            if (panel.getName().toLowerCase().equals(name)) {
                result = panel;
                break;
            }
            ++i;
        }
        return result;
    }

    private void setChanged(boolean changed) {
        if (!changed) {
            int i = 0;
            while (i < this.panels.size()) {
                BuilderPanel panel = (BuilderPanel)this.panels.get(i);
                panel.setChanged(false);
                ++i;
            }
        }
    }

    private boolean isChanged() {
        boolean result = false;
        int i = 0;
        while (i < this.panels.size()) {
            BuilderPanel panel = (BuilderPanel)this.panels.get(i);
            result = result || panel.isChanged();
            ++i;
        }
        return result;
    }

    public Connector getConnector() {
        return this.conn;
    }

    public void setConnector(Connector newconn) {
        this.conn = newconn;
        this.updateConnector();
    }

    @Override
    protected void setFrameTitle() {
        if (!this.filename.equals("")) {
            this.setTitle(String.valueOf(this.frameTitle) + " - " + this.filename);
        } else {
            this.setTitle(this.frameTitle);
        }
        super.setFrameTitle();
    }

    public void setConfirm() {
        this.setConfirmExit(this.isChanged());
    }

    private void updateConnector() {
        int i = 0;
        while (i < this.panels.size()) {
            BuilderPanel panel = (BuilderPanel)this.panels.get(i);
            panel.setConnector(this.conn);
            ++i;
        }
    }

    private boolean saveChanges() {
        boolean result;
        boolean bl = result = !this.isChanged();
        if (this.isChanged()) {
            int button = this.showMessageBox("Changed", "The project is not save - Do you want to save it?", MessageBox.BUTTONS_YESNOCANCEL, "question.gif", 350, 100);
            switch (button) {
                case 0: {
                    this.saveProject(this.filename);
                    result = !this.isChanged();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    private Attribute createDepends(Element nodes) {
        Attribute result = new Attribute("depends", "");
        if (nodes != null && nodes.getChildCount() > 0) {
            String list = "";
            int i = 0;
            while (i < nodes.getChildCount()) {
                if (i > 0) {
                    list = String.valueOf(list) + ", ";
                }
                list = String.valueOf(list) + ((Element)nodes.getChildAt(i)).getAttributeAt(0).getValue();
                ++i;
            }
            result.setValue(list);
        }
        return result;
    }

    private void addNodes(Element parent, Element nodes) {
        if (nodes == null) {
            return;
        }
        int i = 0;
        while (i < nodes.getChildCount()) {
            parent.add((Element)nodes.getChildAt(i));
            ++i;
        }
    }

    private Element getTarget(Document doc, String name) {
        Element result = null;
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//target");
        int i = 0;
        while (i < nodes.size()) {
            Element node = (Element)nodes.get(i);
            Attribute att = node.getAttribute("name");
            if (att != null && att.getValue().equals(name)) {
                result = node;
                break;
            }
            ++i;
        }
        return result;
    }

    private void retrieveSteps(Document doc) {
        Element node = this.getTarget(doc, "all");
        if (node == null) {
            return;
        }
        String tmp = node.getAttribute("depends").getValue();
        if ((tmp = tmp.replaceAll(",\\ ", ",").replaceAll("init,", "")).equals("")) {
            return;
        }
        String[] steps = Strings.breakUp(tmp, ",");
        ProperVector substeps = new ProperVector();
        int i = 0;
        while (i < steps.length) {
            node = this.getTarget(doc, steps[i]);
            if (node != null && node.getAttribute("depends") != null) {
                tmp = node.getAttribute("depends").getValue();
                tmp = tmp.replaceAll(",\\ ", ",");
                substeps.addAll(Strings.arrayToVector(Strings.breakUp(tmp, ",")));
            }
            ++i;
        }
        i = 0;
        while (i < substeps.size()) {
            this.getSteps().setChecked((String)substeps.get(i), true);
            ++i;
        }
    }

    private void retrieveProperties(Document doc) {
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//property");
        Element node = new Element(this.panelProperties.getName());
        int i = 0;
        while (i < nodes.size()) {
            Element subnode = (Element)nodes.get(i);
            Attribute att = subnode.getAttribute("name");
            if (att == null || att.getValue().equals("version")) {
                if (att != null && !att.getValue().equals("version")) {
                    this.showMessageBox("Version mismatch", "The version of the file is '" + subnode.getAttribute("value").getValue() + "'" + ", but Proper is of version '" + "Proper_0.2.1" + "'. ", MessageBox.BUTTONS_OK, "information.gif", 450, 100);
                }
                nodes.remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < nodes.size()) {
            node.add((Element)nodes.get(i));
            ++i;
        }
        this.panelProperties.fromXML(node);
        try {
            if (this.conn.isConnected()) {
                this.conn.disconnect();
            }
            this.conn.connect(this.panelProperties.getValue("driver"), this.panelProperties.getValue("url"), this.panelProperties.getValue("database"), this.panelProperties.getValue("user"), this.panelProperties.getValue("password"));
        }
        catch (Exception e) {
            this.println(e);
        }
    }

    private void retrieveData(Document doc) {
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//java");
        int i = 0;
        while (i < nodes.size()) {
            Element node = (Element)nodes.get(i);
            String step = ((Element)node.getParent()).getAttribute("name").getValue();
            BuilderPanel panel = this.getPanel(step);
            if (panel != null) {
                panel.fromXML(node);
            } else {
                this.println("Unknown Step: " + step);
            }
            ++i;
        }
    }

    private void clear() {
        int i = 0;
        while (i < this.panels.size()) {
            BuilderPanel panel = (BuilderPanel)this.panels.get(i);
            panel.clear();
            ++i;
        }
        this.setChanged(false);
        this.filename = "";
    }

    private void open(String file) {
        Document doc = new Document();
        doc.read(file);
        this.retrieveProperties(doc);
        this.retrieveSteps(doc);
        this.retrieveData(doc);
        this.setChanged(false);
    }

    private void save(String file) {
        BuilderTabPanel panel;
        Element nodes;
        Document doc = new Document();
        doc.clear();
        Element project = new Element("project");
        project.addAttribute(new Attribute("name", "WEKA Proper"));
        project.addAttribute(new Attribute("default", "all"));
        project.addAttribute(new Attribute("basedir", "."));
        doc.getRoot().add(project);
        project.add(new Comment("last saved: " + new Timestamp()));
        project.add(new Comment("for accessing the environment variables"));
        Element node = new Element(project, "property");
        node.addAttribute(new Attribute("environment", "env"));
        project.add(new Comment("Version of Proper WEKA"));
        node = new Element(project, "property");
        node.addAttribute(new Attribute("name", "version"));
        node.addAttribute(new Attribute("value", "Proper_0.2.1"));
        project.add(new Comment("Properties"));
        this.addNodes(project, this.panelProperties.toXML());
        project.add(new Comment("Classpath"));
        node = new Element(project, "path");
        node.addAttribute(new Attribute("id", "project.class.path"));
        Element subnode = new Element(node, "pathelement");
        subnode.addAttribute(new Attribute("location", "${env.ANT_HOME}/lib"));
        subnode = new Element(node, "pathelement");
        subnode.addAttribute(new Attribute("location", "."));
        subnode = new Element(node, "fileset");
        subnode.addAttribute(new Attribute("dir", "${dist}"));
        subnode.add(new Element("include"));
        ((Element)subnode.getChildAt(0)).addAttribute(new Attribute("name", "*.jar"));
        project.add(new Comment("default target"));
        node = new Element(project, "target");
        node.addAttribute(new Attribute("name", "all"));
        String depends = "init";
        int i = 0;
        while (i < this.panels.size()) {
            if (this.panels.get(i) instanceof BuilderTabPanel && (nodes = ((BuilderPanel)(panel = (BuilderTabPanel)this.panels.get(i))).toXML()).getChildCount() != 0) {
                panel = (BuilderTabPanel)this.panels.get(i);
                depends = String.valueOf(depends) + ", " + panel.getName().toLowerCase();
            }
            ++i;
        }
        node.addAttribute(new Attribute("depends", depends));
        project.add(new Comment("creates the output directory"));
        node = new Element(project, "target");
        node.addAttribute(new Attribute("name", "init"));
        subnode = new Element(node, "mkdir");
        subnode.addAttribute(new Attribute("dir", "${output}"));
        i = 0;
        while (i < this.panels.size()) {
            if (this.panels.get(i) instanceof BuilderTabPanel && (nodes = ((BuilderPanel)(panel = (BuilderTabPanel)this.panels.get(i))).toXML()).getChildCount() != 0) {
                node = new Element(project, "target");
                node.addAttribute(new Attribute("name", panel.getName().toLowerCase()));
                node.addAttribute(this.createDepends(nodes));
                this.addNodes(project, nodes);
            }
            ++i;
        }
        doc.write(file);
    }

    private void newProject() {
        if (!this.saveChanges()) {
            return;
        }
        this.clear();
        this.setFrameTitle();
        this.setConfirm();
    }

    private void openProject() {
        if (!this.saveChanges()) {
            return;
        }
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.clear();
        this.filename = this.fileChooser.getSelectedFile().getAbsolutePath();
        this.setFrameTitle();
        this.setConfirm();
        this.open(this.filename);
    }

    private void saveProject(String file) {
        if (!this.checkProject()) {
            return;
        }
        if (file.equals("")) {
            int retVal = this.fileChooser.showSaveDialog(this);
            if (retVal != 0) {
                return;
            }
            file = this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        this.filename = file;
        this.setChanged(false);
        this.setFrameTitle();
        this.setConfirm();
        this.save(this.filename);
    }

    private void connectDatabase() {
        DataBaseConnectDialog dialog = new DataBaseConnectDialog(this);
        dialog.setConnector(this.conn);
        dialog.pack();
        dialog.show();
    }

    private void disconnectDatabase() {
        try {
            this.conn.disconnect();
            this.updateConnector();
        }
        catch (Exception e) {
            this.println(e);
        }
    }

    private boolean checkProject() {
        BuilderPanel panel;
        boolean result = false;
        ProperVector errors = new ProperVector();
        int i = 0;
        while (i < this.panels.size()) {
            panel = (BuilderPanel)this.panels.get(i);
            errors.addAll(panel.check());
            ++i;
        }
        if (errors.size() == 0) {
            result = true;
        } else {
            result = false;
            ListDialog dialog = new ListDialog(this);
            dialog.setTitle("Errors...");
            dialog.setItems(errors);
            dialog.show();
            if (dialog.approved() && dialog.getSelectedValue() != null) {
                String item = dialog.getSelectedValue().toString();
                String[] errorStr = Strings.breakUp(item = item.substring(0, item.indexOf(":")), "/");
                panel = this.getPanel(String.valueOf(errorStr[0]) + "/" + errorStr[1]);
                if (panel != null) {
                    if (panel.getParent() instanceof JTabbedPane) {
                        JTabbedPane pane = (JTabbedPane)panel.getParent();
                        pane.setSelectedIndex(pane.indexOfComponent(panel));
                        if (pane.getParent() instanceof BuilderTabPanel && pane.getParent().getParent().getParent().getParent() instanceof JTabbedPane) {
                            BuilderPanel panel2 = (BuilderPanel)pane.getParent();
                            pane = (JTabbedPane)panel2.getParent().getParent().getParent();
                            pane.setSelectedIndex(pane.indexOfComponent(panel2.getParent().getParent()));
                        }
                    }
                    Vector params = panel.getParameters();
                    i = 0;
                    while (i < params.size()) {
                        BuilderParameter param = (BuilderParameter)params.get(i);
                        if (param.getLabel().equals(errorStr[2])) {
                            param.getComponent().requestFocus();
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    private void enableLogFiles(boolean enabled) {
        int i = 0;
        while (i < this.panels.size()) {
            BuilderPanel panel = (BuilderPanel)this.panels.get(i);
            BuilderParameter param = panel.getParameter("log");
            if (param != null) {
                ((JCheckBox)param.getUseComponent()).setSelected(enabled);
            }
            ++i;
        }
    }

    private void close() {
        if (!this.saveChanges()) {
            return;
        }
        this.setChanged(false);
        this.setConfirmExit(false);
        this.windowClosing(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuFileNew) {
            this.newProject();
        } else if (e.getSource() == this.menuFileOpen) {
            this.openProject();
        } else if (e.getSource() == this.menuFileSave) {
            this.saveProject(this.filename);
        } else if (e.getSource() == this.menuFileSaveAs) {
            this.saveProject("");
        } else if (e.getSource() == this.menuFileExit) {
            this.close();
        } else if (e.getSource() == this.menuDatabaseConnect) {
            this.connectDatabase();
        } else if (e.getSource() == this.menuDatabaseDisconnect) {
            this.disconnectDatabase();
        } else if (e.getSource() == this.menuExperimentCheck) {
            this.checkProject();
        } else if (e.getSource() == this.menuExperimentEnableLogs) {
            this.enableLogFiles(true);
        } else if (e.getSource() == this.menuExperimentDisableLogs) {
            this.enableLogFiles(false);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!this.saveChanges()) {
            return;
        }
        this.setChanged(false);
        this.setConfirmExit(false);
        super.windowClosing(e);
    }

    @Override
    public void currentDirChanged(CurrentDirChangeEvent e) {
        int i = 0;
        while (i < this.panels.size()) {
            BuilderPanel panel = (BuilderPanel)this.panels.get(i);
            int n = 0;
            while (n < panel.getParameters().size()) {
                BuilderParameter param = (BuilderParameter)panel.getParameters().get(n);
                if (param.getComponent() instanceof FileTextField && param.getComponent() != e.getSource()) {
                    FileTextField textfield = (FileTextField)param.getComponent();
                    textfield.setCurrentDirectory(e.getCurrentDir());
                }
                ++n;
            }
            ++i;
        }
    }

    @Override
    public void connectorChanged(ConnectorChangeEvent e) {
        this.conn = e.getConnector();
        this.updateConnector();
    }

    @Override
    public void printDescription() {
        System.out.println("The Builder enables one to create Proper-specific ANT files for experiments.");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        Builder frame = new Builder(null);
        frame.run(args);
    }
}

