/*
 * Decompiled with CFR 0.152.
 */
package proper.remote.messages;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.Vector;
import proper.core.ProperObject;
import proper.util.ProperVector;
import proper.xml.Document;
import proper.xml.Element;
import proper.xml.Path;

public class Message
extends ProperObject {
    public static final String MESSAGE = "message";
    public static final String HEADER = "header";
    public static final String FROM = "from";
    public static final String IP = "ip";
    public static final String PORT = "port";
    public static final String TYPE = "type";
    public static final String BODY = "body";
    private Document doc;
    private Path xpath;

    public Message() {
        this.clear();
        try {
            this.setIP(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.read(new StringReader(this.toString()));
    }

    public Message(Reader reader) {
        this.read(reader);
    }

    public Message(Message msg) {
        this.read(new StringReader(msg.toString()));
    }

    public Message(int port) {
        this();
        this.setPort(port);
    }

    public Message(String ip, int port) {
        this();
        this.setIP(ip);
        this.setPort(port);
    }

    protected void read(Reader reader) {
        this.clear();
        this.doc.read(reader);
        boolean other = this.isOtherMessage(this);
        if (other) {
            this.clearBody();
        }
        if (this.getVerbose()) {
            this.println(String.valueOf(this.getClass().getName()) + " (other = " + other + "): \n" + this.doc + "\n");
        }
    }

    protected Element getNode(Element node, String path) {
        if (node == null) {
            return null;
        }
        Vector result = this.xpath.get(node, path);
        if (result.size() > 0) {
            return (Element)result.get(0);
        }
        return null;
    }

    protected Element getNode(String path) {
        return this.getNode(this.doc.getRoot(), path);
    }

    protected Vector getNodes(Element node, String path) {
        if (node == null) {
            return null;
        }
        return this.xpath.get(node, path);
    }

    protected Vector getNodes(String path) {
        return this.getNodes(this.doc.getRoot(), path);
    }

    public Element getHeader() {
        return this.getNode("/message/header");
    }

    public Element getBody() {
        return this.getNode("/message/body");
    }

    public String getBodyContent() {
        return this.getContent(this.getBody());
    }

    public void setBodyContent(String content) {
        this.setContent(this.getBody(), content);
    }

    public String getContent(Element node) {
        return this.getContent(node, false);
    }

    public String getContent(Element node, boolean returnEmptyIfNull) {
        if (node != null) {
            return node.getContent();
        }
        return null;
    }

    public void setContent(Element node, Object content) {
        if (node != null) {
            if (content != null) {
                node.setContent(content.toString());
            } else {
                node.setContent(null);
            }
        }
    }

    public Vector getContent(String path) {
        return this.getContent(this.doc.getRoot(), path);
    }

    public Vector getContent(Element node, String path) {
        return this.getContent(node, path, false);
    }

    public Vector getContent(Element node, String path, boolean returnEmptyIfNull) {
        ProperVector result = new ProperVector();
        Vector nodes = this.getNodes(node, path);
        int i = 0;
        while (i < nodes.size()) {
            Element child = (Element)nodes.get(i);
            String content = child.getContent();
            if (returnEmptyIfNull && content == null) {
                result.add("");
            } else {
                result.add(content);
            }
            ++i;
        }
        return result;
    }

    protected boolean isOtherMessage(Message msg) {
        return false;
    }

    public void clear() {
        this.xpath = new Path();
        this.doc = new Document();
        this.doc.getRoot().add(new Element(MESSAGE));
        Element node = this.getNode("/message");
        node.add(new Element(HEADER));
        node.add(new Element(BODY));
        node = this.getNode("/message/header");
        node.add(new Element(FROM));
        node.add(new Element(TYPE));
        node = this.getNode("/message/header/from");
        node.add(new Element(IP));
        node.add(new Element(PORT));
        this.clearBody();
    }

    public void clearBody() {
        this.getBody().removeAll();
        this.getBody().setContent(null);
    }

    public String getIP() {
        return this.getContent(this.getNode(this.getHeader(), "from/ip"), true);
    }

    public void setIP(String ip) {
        this.setContent(this.getNode(this.getHeader(), "from/ip"), ip);
    }

    public int getPort() {
        String port = this.getContent(this.getNode(this.getHeader(), "from/port"), true);
        if (port.equals("")) {
            return -1;
        }
        return Integer.parseInt(port);
    }

    public void setPort(int port) {
        this.setContent(this.getNode(this.getHeader(), "from/port"), new Integer(port));
    }

    public String getType() {
        return this.getContent(this.getNode(this.getHeader(), TYPE), true);
    }

    public void setType(String type) {
        this.setContent(this.getNode(this.getHeader(), TYPE), type);
    }

    @Override
    public String toString() {
        return this.doc.toString();
    }

    public static void main(String[] args) throws Exception {
        Message msg;
        if (args.length == 0) {
            msg = new Message();
            msg.setIP("192.168.0.1");
            msg.setPort(1234);
            msg.setType("blabla");
            msg.setBodyContent("Important message for Dale!!!");
            System.out.println();
            System.out.println(msg.getIP());
            System.out.println(msg.getPort());
            System.out.println(msg.getBodyContent());
        } else {
            msg = new Message(new BufferedReader(new FileReader(args[0])));
        }
        System.out.println(msg);
    }
}

