/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Literal;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.ilp.treeLiker.Aggregable;
import ida.ilp.treeLiker.Aggregables;
import ida.ilp.treeLiker.AggregablesBuilder;
import ida.ilp.treeLiker.Domain;
import ida.ilp.treeLiker.Example;
import ida.ilp.treeLiker.HavingLiteralDomain;
import ida.ilp.treeLiker.HavingTermDomain;
import ida.ilp.treeLiker.Join;
import ida.ilp.treeLiker.PredicateDefinition;
import ida.ilp.treeLiker.Settings;
import ida.ilp.treeLiker.aggregables.VoidAggregables;
import ida.ilp.treeLiker.aggregables.VoidAggregablesBuilder;
import ida.utils.Sugar;
import ida.utils.collections.Counters;
import ida.utils.collections.IntegerSet;
import ida.utils.tuples.Pair;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Block
implements HavingLiteralDomain,
HavingTermDomain {
    private int id;
    private int arity;
    private int predicate;
    private static int idCounter;
    private int size = 1;
    private Join[] children;
    private PredicateDefinition definition;
    private int input = -1;
    private AggregablesBuilder aggregablesBuilder;
    private SoftReference<String> canonicalString = new SoftReference<Object>(null);
    private int hashCode = -1;
    private final Object lock = new Object();
    private int numAggregators = 0;
    private SoftReference<HashMap<Pair<Integer, Example>, SoftReference<IntegerSet>>> integerSetTermDomainsCache = new SoftReference<Object>(null);
    private SoftReference<HashMap<Pair<Integer, Example>, SoftReference<Aggregable>>> termAggregablesCache = new SoftReference<Object>(null);
    private SoftReference<HashMap<Pair<Integer, Example>, SoftReference<Domain>>> termDomainsCache = new SoftReference<Object>(null);
    private SoftReference<IntegerSet> predicates = new SoftReference<Object>(null);
    private SoftReference<Counters<Integer>> predicateCounts = new SoftReference<Object>(null);

    public Block(PredicateDefinition definition) {
        this(definition, VoidAggregablesBuilder.construct());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block(PredicateDefinition definition, AggregablesBuilder aggregableBuilder) {
        Class<Block> clazz = Block.class;
        synchronized (Block.class) {
            this.id = ++idCounter;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.aggregablesBuilder = aggregableBuilder;
            this.arity = definition.modes().length;
            this.predicate = definition.predicate();
            this.children = new Join[this.arity];
            this.definition = definition;
            this.input = definition.input();
            if (!Settings.COUNT_CONSTANTS_AS_LITERALS && this.definition.isConstant()) {
                this.size = 0;
            }
            if (this.definition.containsAggregator()) {
                this.numAggregators = this.definition.numAggregators();
            }
            return;
        }
    }

    public Join addChild(Block child, int output) {
        Join retVal = this.children[output];
        this.children[output] = retVal == null ? new Join(child) : retVal.addBlock(child);
        this.size += child.size();
        this.numAggregators += child.numAggregators();
        this.deleteEverythingCached();
        return retVal;
    }

    public Join setChildren(Join newChildren, int argument) {
        Join retVal = this.children[argument];
        if (this.children[argument] != null) {
            this.size -= this.children[argument].numLiterals();
            this.numAggregators -= this.children[argument].numAggregators();
        }
        this.children[argument] = newChildren;
        this.size += newChildren.numLiterals();
        this.numAggregators += newChildren.numAggregators();
        this.deleteEverythingCached();
        return retVal;
    }

    public int[] modes() {
        return this.definition.modes();
    }

    public int[] types() {
        return this.definition.types();
    }

    public int[] branchingFactors() {
        return this.definition.branchingFactors();
    }

    public int size() {
        return this.size;
    }

    public int arity() {
        return this.arity;
    }

    @Override
    public int id() {
        return this.id;
    }

    public PredicateDefinition definition() {
        return this.definition;
    }

    public int branchingModPredicate() {
        return this.definition.branchingModPredicate();
    }

    public int numAggregators() {
        return this.numAggregators;
    }

    @Override
    public Domain literalDomain(Example e) {
        Domain domain = null;
        IntegerSet integerSetLiteralDomain = this.integerSetLiteralDomain(e);
        if (integerSetLiteralDomain.isEmpty()) {
            domain = Domain.emptyDomain;
        } else {
            Aggregables aggregables = this.aggregablesBuilder.construct(this.definition, integerSetLiteralDomain, e);
            if (!(aggregables instanceof VoidAggregables)) {
                int index = 0;
                for (int literalID : integerSetLiteralDomain.values()) {
                    Object literalAggregable = aggregables.get(index);
                    for (int argument = 0; argument < this.arity; ++argument) {
                        if (this.children[argument] == null) continue;
                        literalAggregable = literalAggregable.cross(this.children[argument].termAggregable(e.getTerm(literalID, argument), e));
                    }
                    aggregables.set(index, literalAggregable);
                    ++index;
                }
            }
            domain = new Domain(integerSetLiteralDomain, aggregables);
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregable termAggregable(int term, Example e) {
        Pair<Integer, Example> queryPair = new Pair<Integer, Example>(term, e);
        Aggregable aggregable = null;
        HashMap<Pair<Integer, Example>, SoftReference<Aggregable>> map = null;
        SoftReference<Aggregable> softRef = null;
        Object object = this.lock;
        synchronized (object) {
            map = this.termAggregablesCache.get();
            if (map != null && (softRef = map.get(queryPair)) != null && (aggregable = softRef.get()) != null) {
                return aggregable;
            }
        }
        for (int literalID : this.integerSetLiteralDomain(e).values()) {
            if (e.getTerm(literalID, this.definition.input()) != term) continue;
            aggregable = aggregable == null ? this.literalAggregable(literalID, e) : aggregable.plus(this.literalAggregable(literalID, e));
        }
        object = this.lock;
        synchronized (object) {
            if (map == null) {
                map = new HashMap();
                this.termAggregablesCache = new SoftReference<HashMap<Pair<Integer, Example>, SoftReference<Aggregable>>>(map);
            }
            map.put(queryPair, new SoftReference<Aggregable>(aggregable));
        }
        return aggregable;
    }

    public Aggregable literalAggregable(int literal, Example e) {
        Object aggregable = this.aggregablesBuilder.construct(this.definition, IntegerSet.createIntegerSet(literal), e).get(0);
        int arg = 0;
        for (Join join : this.children) {
            if (join != null) {
                aggregable = aggregable.cross(join.termAggregable(e.getTerm(literal, arg), e));
            }
            ++arg;
        }
        return aggregable;
    }

    public IntegerSet integerSetLiteralDomain(Example e) {
        boolean hasAtLeastOneChild = false;
        IntegerSet[] literalDomains = new IntegerSet[this.children.length];
        for (int i = 0; i < this.arity; ++i) {
            if (this.children[i] == null) continue;
            hasAtLeastOneChild = true;
            literalDomains[i] = e.getLiteralDomain(this.predicate, this.children[i].integerSetTermDomain(e), i);
        }
        IntegerSet integerSetLiteralDomain = null;
        integerSetLiteralDomain = hasAtLeastOneChild ? IntegerSet.intersection(literalDomains) : e.getLiteralDomain(this.predicate);
        return integerSetLiteralDomain;
    }

    public IntegerSet integerSetTermDomain(Example e) {
        return this.integerSetTermDomain(this.input(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegerSet integerSetTermDomain(int argument, Example e) {
        Pair<Integer, Example> queryPair = new Pair<Integer, Example>(argument, e);
        IntegerSet domain = null;
        HashMap<Pair<Integer, Example>, SoftReference<IntegerSet>> map = null;
        SoftReference<IntegerSet> softRef = null;
        Object object = this.lock;
        synchronized (object) {
            map = this.integerSetTermDomainsCache.get();
            if (map != null && (softRef = map.get(queryPair)) != null && (domain = softRef.get()) != null) {
                return domain;
            }
        }
        IntegerSet literalDomain = this.integerSetLiteralDomain(e);
        domain = literalDomain.isEmpty() ? IntegerSet.emptySet : e.getTermDomain(literalDomain, argument);
        Object object2 = this.lock;
        synchronized (object2) {
            if (map == null) {
                map = new HashMap();
                this.integerSetTermDomainsCache = new SoftReference<HashMap<Pair<Integer, Example>, SoftReference<IntegerSet>>>(map);
            }
            map.put(queryPair, new SoftReference<IntegerSet>(domain));
        }
        return domain;
    }

    @Override
    public Domain termDomain(Example e) {
        return this.termDomain(this.input(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain termDomain(int argument, Example e) {
        Pair<Integer, Example> queryPair = new Pair<Integer, Example>(argument, e);
        Domain domain = null;
        HashMap<Pair<Integer, Example>, SoftReference<Domain>> map = null;
        SoftReference<Domain> softRef = null;
        Object object = this.lock;
        synchronized (object) {
            map = this.termDomainsCache.get();
            if (map != null && (softRef = map.get(queryPair)) != null && (domain = softRef.get()) != null) {
                return domain;
            }
        }
        IntegerSet literalDomain = this.integerSetLiteralDomain(e);
        if (literalDomain.isEmpty()) {
            domain = Domain.emptyDomain;
        } else {
            IntegerSet termIntegerSetDomain = null;
            termIntegerSetDomain = argument == -1 ? IntegerSet.createIntegerSet(-1) : e.getTermDomain(literalDomain, argument);
            if (this.aggregablesBuilder instanceof VoidAggregablesBuilder) {
                domain = new Domain(termIntegerSetDomain, VoidAggregables.construct(termIntegerSetDomain.size()));
            } else {
                HashMap<Integer, Aggregable> aggregablesMap = new HashMap<Integer, Aggregable>();
                for (int literal : literalDomain.values()) {
                    int term = -1;
                    if (argument != -1) {
                        term = e.getTerm(literal, argument);
                    }
                    Aggregable agg = this.literalAggregable(literal, e);
                    Aggregable aggOld = null;
                    aggOld = (Aggregable)aggregablesMap.get(term);
                    if (aggOld != null) {
                        aggregablesMap.put(term, aggOld.plus(agg));
                        continue;
                    }
                    aggregablesMap.put(term, agg);
                }
                Aggregables<Aggregable> aggregables = new Aggregables<Aggregable>(termIntegerSetDomain.size());
                for (int term : termIntegerSetDomain.values()) {
                    aggregables.add((Aggregable)aggregablesMap.get(term));
                }
                domain = new Domain(termIntegerSetDomain, aggregables);
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (map == null) {
                map = new HashMap();
                this.termDomainsCache = new SoftReference<HashMap<Pair<Integer, Example>, SoftReference<Domain>>>(map);
            }
            map.put(queryPair, new SoftReference<Domain>(domain));
        }
        return domain;
    }

    public Join children(int argument) {
        return this.children[argument];
    }

    public int predicate() {
        return this.predicate;
    }

    public int input() {
        return this.input;
    }

    public int inputType() {
        if (this.definition.isOutputOnly()) {
            return -1;
        }
        return this.types()[this.input()];
    }

    public String toString() {
        return this.toClause();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long h = (Math.abs(this.predicate) + 1) * (this.arity + 1);
            for (Join join : this.children) {
                if (join == null) continue;
                for (Block child : join) {
                    if (child == null) continue;
                    h = h * (long)child.hashCode() % Integer.MAX_VALUE;
                }
            }
            this.hashCode = (int)h;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof Block) {
            Block thlc = (Block)o;
            if (thlc.definition.isOutputOnly() || this.definition.isOutputOnly()) {
                return thlc.size() == this.size() && this.hashCode() == thlc.hashCode() && thlc.toCanonicalString().equals(this.toCanonicalString());
            }
            return thlc.definition.types()[thlc.definition().input()] == this.definition.types()[this.definition().input()] && thlc.toCanonicalString().equals(this.toCanonicalString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEverythingCached() {
        Object object = this.lock;
        synchronized (object) {
            this.deleteCachedDomains();
            this.canonicalString.clear();
            this.hashCode = -1;
        }
    }

    public void deleteCachedDomains() {
        this.termDomainsCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggregablesBuilder(AggregablesBuilder builder) {
        Object object = this.lock;
        synchronized (object) {
            this.termAggregablesCache.clear();
            this.termDomainsCache.clear();
            this.aggregablesBuilder = builder;
        }
    }

    private String niceVariableName(int index) {
        if (index <= 25) {
            return String.valueOf((char)(65 + index));
        }
        return String.valueOf((char)(65 + index % 25)) + index / 25;
    }

    public String toClause() {
        StringBuffer buffer = new StringBuffer();
        this.toClause(buffer, null, new Counters(), new Counters());
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == ' ') {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        return buffer.toString();
    }

    private void toClause(StringBuffer buffer, String parentOutput, Counters counter, Counters realNumberCounters) {
        int i;
        buffer.append(PredicateDefinition.integerToPredicate(this.predicate));
        buffer.append("(");
        String[] variableNames = new String[this.arity];
        for (i = 0; i < this.arity; ++i) {
            if (this.definition().modes()[i] == 1) {
                if (parentOutput == null) {
                    buffer.append("_");
                } else {
                    buffer.append(parentOutput);
                }
                if (i >= this.arity - 1) continue;
                buffer.append(", ");
                continue;
            }
            if (this.definition.originalModes()[i] == 3) {
                if (this.children[i] != null) {
                    Block child = this.children[i].first();
                    if (child != null) {
                        String constant = PredicateDefinition.integerToPredicate(child.predicate);
                        buffer.append(constant);
                    } else {
                        buffer.append("_");
                    }
                    if (i >= this.arity - 1) continue;
                    buffer.append(", ");
                    continue;
                }
                buffer.append("_");
                if (i >= this.arity - 1) continue;
                buffer.append(", ");
                continue;
            }
            if (this.definition.modes()[i] == 9) {
                buffer.append("real(x").append(realNumberCounters.incrementPost(true) + 1).append(")");
                if (i >= this.arity - 1) continue;
                buffer.append(", ");
                continue;
            }
            if (this.children[i] != null) {
                String nice;
                variableNames[i] = nice = this.niceVariableName(counter.incrementPost(true));
                buffer.append(nice);
                if (i >= this.arity - 1) continue;
                buffer.append(", ");
                continue;
            }
            buffer.append("_");
            if (i >= this.arity - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        buffer.append(", ");
        for (i = 0; i < this.arity; ++i) {
            if (this.definition().originalModes()[i] == 3 || this.children[i] == null) continue;
            for (Block child : this.children[i]) {
                child.toClause(buffer, variableNames[i], counter, realNumberCounters);
            }
        }
    }

    public String toCanonicalString() {
        String retVal = this.canonicalString.get();
        if (retVal == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(PredicateDefinition.integerToPredicate(this.predicate));
            buffer.append("[");
            for (int i = 0; i < this.arity; ++i) {
                if (this.definition.modes()[i] == 5) {
                    buffer.append("[!]");
                } else if (this.definition.modes()[i] == 8) {
                    buffer.append("$").append(PredicateDefinition.integerToType(this.definition.types()[i]));
                } else if (this.definition.modes()[i] == 9) {
                    buffer.append("AGG:").append(PredicateDefinition.integerToType(this.definition.types()[i]));
                } else {
                    buffer.append("[");
                    ArrayList<String> childrenStrings = new ArrayList<String>();
                    if (this.children[i] != null) {
                        for (Block child : this.children[i]) {
                            if (child == null) continue;
                            childrenStrings.add(child.toCanonicalString());
                        }
                    }
                    Collections.sort(childrenStrings);
                    for (int j = 0; j < childrenStrings.size(); ++j) {
                        buffer.append((String)childrenStrings.get(j));
                        if (j >= childrenStrings.size() - 1) continue;
                        buffer.append(",");
                    }
                    buffer.append("]");
                }
                if (i >= this.arity - 1) continue;
                buffer.append(",");
            }
            buffer.append("]");
            retVal = buffer.toString();
            this.canonicalString = new SoftReference<String>(retVal);
        }
        return retVal;
    }

    public Block shallowCopy() {
        Block myCopy = new Block(this.definition, this.aggregablesBuilder);
        for (int i = 0; i < this.children.length; ++i) {
            if (this.definition.modes()[i] != 2 || this.children[i] == null) continue;
            myCopy.setChildren(this.children[i], i);
        }
        return myCopy;
    }

    public Set<Block> leaves() {
        HashSet<Block> retVal = new HashSet<Block>();
        for (int i = 0; i < this.children.length; ++i) {
            for (Block child : this.children[i]) {
                if (child == null) continue;
                retVal.addAll(child.leaves());
            }
        }
        if (retVal.isEmpty()) {
            retVal.add(this);
        }
        return retVal;
    }

    public IntegerSet predicates() {
        IntegerSet retVal = this.predicates.get();
        if (retVal != null) {
            return retVal;
        }
        HashSet<IntegerSet> descendantPredicates = new HashSet<IntegerSet>();
        for (int i = 0; i < this.children.length; ++i) {
            for (Block b : this.children[i]) {
                if (b == null) continue;
                descendantPredicates.add(b.predicates());
            }
        }
        descendantPredicates.add(IntegerSet.createIntegerSet(this.predicate));
        retVal = IntegerSet.union(descendantPredicates);
        this.predicates = new SoftReference<IntegerSet>(retVal);
        return retVal;
    }

    public Counters<Integer> predicateCounts() {
        Counters<Integer> cachedRetVal = this.predicateCounts.get();
        if (cachedRetVal != null) {
            return cachedRetVal;
        }
        Counters<Integer> retVal = new Counters<Integer>();
        retVal.increment(this.predicate);
        for (int i = 0; i < this.children.length; ++i) {
            for (Block b : this.children[i]) {
                if (b == null) continue;
                retVal.addAll(b.predicateCounts());
            }
        }
        this.predicateCounts = new SoftReference(retVal);
        return retVal;
    }

    public static Block parse(String clauseAsString) {
        Clause clause = Clause.parse(clauseAsString);
        LinkedHashSet<Literal> literals = clause.literals();
        HashMap<Term, Pair<Block, Integer>> outputVariables = new HashMap<Term, Pair<Block, Integer>>();
        HashMap<Term, Block> constants = new HashMap<Term, Block>();
        Block root = null;
        for (Literal l : literals) {
            int input = -1;
            if (!outputVariables.isEmpty()) {
                for (int i = 0; i < l.arity(); ++i) {
                    if (!outputVariables.containsKey(l.get(i))) continue;
                    input = i;
                    break;
                }
            }
            int predicate = PredicateDefinition.predicateToInteger(l.predicate(), l.arity());
            int[] types = new int[l.arity()];
            int[] modes = new int[l.arity()];
            int[] branching = new int[l.arity()];
            Arrays.fill(branching, Integer.MAX_VALUE);
            int[] originalModes = new int[l.arity()];
            for (int i = 0; i < l.arity(); ++i) {
                if (l.get(i) instanceof Variable) {
                    if (l.get(i).name().equals("_")) {
                        modes[i] = 5;
                        originalModes[i] = 5;
                        continue;
                    }
                    if (i == input) {
                        modes[i] = 1;
                        originalModes[i] = 1;
                        continue;
                    }
                    modes[i] = 2;
                    originalModes[i] = 2;
                    continue;
                }
                modes[i] = 2;
                originalModes[i] = 3;
                PredicateDefinition constantDefinition = new PredicateDefinition(PredicateDefinition.predicateToInteger(l.get(i).name(), l.arity()), new int[]{0}, new int[]{1}, new int[]{Integer.MAX_VALUE}, Integer.MAX_VALUE, new int[]{1});
                constants.put(l.get(i), new Block(constantDefinition));
            }
            Block block = new Block(new PredicateDefinition(predicate, types, modes, branching, Integer.MAX_VALUE, originalModes));
            if (root == null) {
                root = block;
            }
            for (int i = 0; i < l.arity(); ++i) {
                if (i == input) {
                    Pair parent = (Pair)outputVariables.get(l.get(i));
                    ((Block)parent.r).addChild(block, (Integer)parent.s);
                    continue;
                }
                if (l.get(i) instanceof Variable) {
                    outputVariables.put(l.get(i), new Pair<Block, Integer>(block, i));
                    continue;
                }
                block.addChild((Block)constants.get(l.get(i)), i);
            }
        }
        return root;
    }

    public void applyRecursively(Sugar.Fun<Block, Block> function) {
        function.apply(this);
        for (Join join : this.children) {
            if (join == null) continue;
            for (Block child : join) {
                child.applyRecursively(function);
            }
        }
    }
}

