/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import proper.core.Assignable;
import proper.util.ProperVector;

public class Column
implements Comparable,
Cloneable,
Assignable {
    protected String table;
    protected String name;
    protected int type;
    protected String typeName;
    protected int size;

    public Column(String name) {
        this(name, 1111);
    }

    public Column(String name, int type) {
        this(name, type, -1);
    }

    public Column(String name, int type, int size) {
        this(name, type, "", size);
    }

    public Column(String name, int type, String typeName) {
        this(name, type, typeName, -1);
    }

    public Column(String name, int type, String typeName, int size) {
        if (name.indexOf(".") > -1) {
            this.table = name.substring(0, name.indexOf("."));
            this.name = name.substring(name.indexOf(".") + 1, name.length());
        } else {
            this.table = null;
            this.name = name;
        }
        this.type = type;
        this.typeName = typeName;
        this.size = size;
    }

    public Object clone() {
        if (this.table != null) {
            return new Column(String.valueOf(this.table) + "." + this.name, this.type, this.typeName, this.size);
        }
        return new Column(this.name, this.type, this.typeName, this.size);
    }

    public String getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSize() {
        return this.size;
    }

    public String typeToString() {
        return Column.typeToString(this.getType(), this.getTypeName(), this.getSize());
    }

    public static String typeToString(int type) {
        return Column.typeToString(type, -1);
    }

    public static String typeToString(int type, int size) {
        return Column.typeToString(type, "", size);
    }

    public static String typeToString(int type, String typeName, int size) {
        Column col = new Column("dummy", type, size);
        if (col.isBlob()) {
            Object var3_4 = null;
        }
        String result = col.isNominal() ? (size == -1 ? "VARCHAR(255)" : (type == 1 ? "CHAR(" + size + ")" : "VARCHAR(" + size + ")")) : (col.isBoolean() ? "BOOL" : (col.isInteger() ? "INT" : (col.isDecimal() ? "DOUBLE PRECISION" : (col.isDate() ? "DATE" : (!typeName.equals("") ? typeName : null)))));
        return result;
    }

    public boolean isBlob() {
        return this.isNominal() && this.getSize() > 255 || this.getTypeName().toLowerCase().indexOf("blob") > -1;
    }

    public boolean isNominal() {
        return this.type == 1 || this.type == 12 || this.type == -1;
    }

    public boolean isBoolean() {
        return this.type == -7 || this.type == 16;
    }

    public boolean isInteger() {
        return this.type == 4 || this.type == -6 || this.type == 5 || this.type == -5;
    }

    public boolean isDecimal() {
        return this.type == 2 || this.type == 7 || this.type == 6 || this.type == 8 || this.type == 3;
    }

    public boolean isNumerical() {
        return this.isInteger() || this.isDecimal();
    }

    public boolean isDate() {
        return this.type == 91 || this.type == 93;
    }

    @Override
    public void assign(Object o) {
        if (!(o instanceof Column)) {
            return;
        }
        Column col = (Column)o;
        this.table = col.getTable();
        this.name = col.getName();
        this.type = col.getType();
        this.typeName = col.getTypeName();
        this.size = col.getSize();
    }

    public int compareTo(Object o) throws ClassCastException {
        int result = 0;
        if (o != null) {
            Column c = (Column)o;
            result = c.toString().indexOf(".") == -1 ? this.getName().compareToIgnoreCase(c.getName()) : this.toString().compareToIgnoreCase(c.toString());
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public String toString() {
        String result = this.getTable() != null && !this.getTable().equals("") ? String.valueOf(this.getTable()) + "." + this.getName() : this.getName();
        return result;
    }

    public static void main(String[] args) {
        ProperVector list = new ProperVector();
        list.add(new Column("column1", 4));
        list.add(new Column("column3", 1111));
        list.add(new Column("column0", 6));
        list.add(new Column("column1", 0));
        list.add(new Column("table1.column4", 4));
        int i = 0;
        while (i < list.size()) {
            System.out.println(list.get(i) + " = " + ((Column)list.get(i)).getType());
            ++i;
        }
        System.out.println(list.get(0).equals("column1"));
        System.out.println(list.get(0).equals(list.get(3)));
        System.out.println(list.contains("column1"));
        System.out.println(list.contains(new Column("column1")));
        System.out.println(list.contains(list.get(3)));
    }
}

